/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fox.authn;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxScramShaUtil;
import javax.baja.fox.authn.BFoxClientAuthnHandler;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.sys.BIObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraSlots
public class BFoxDigestClientAuthnHandler
extends BFoxClientAuthnHandler {
    public static final Type TYPE = Sys.loadType(BFoxDigestClientAuthnHandler.class);
    private BUsernameCredential username = new BUsernameCredential();

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void handleAuthentication(FoxSession session, AuthenticationClient authenticationClient) throws Exception {
        BUsernameAndPassword seedCredential;
        String scheme;
        BFoxClientConnection foxClientConnection = (BFoxClientConnection)session.conn();
        BFoxSession realm = foxClientConnection.getFoxSession();
        BICredentials credentials = authenticationClient.requestInformation((AuthenticationRealm)realm, scheme = foxClientConnection.getAuthenticationScheme(), 0, (BIObject)(seedCredential = new BUsernameAndPassword(this.username.getUsername(), BPassword.DEFAULT)));
        if (credentials == null) {
            throw new FoxAuthenticationException("Cancelled", scheme, null, session);
        }
        if (!(credentials instanceof BUsernameAndPassword)) {
            throw new FoxAuthenticationException(Lexicon.make((String)"fox").getText("digest.authnHandler.unsupportedCredentials", new Object[]{credentials.getType()}), scheme, null, session);
        }
        BUsernameAndPassword cred = (BUsernameAndPassword)credentials;
        FoxScramShaUtil.handleClientAuthentication(session, cred, scheme);
    }

    @Override
    public void setData(BIObject data) {
        if (!(data instanceof BUsernameCredential)) {
            throw new UnsupportedOperationException("Data type not supported.");
        }
        this.username = (BUsernameCredential)data;
    }
}

