/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.wb;

import com.tridium.portal.api.PortalApi;
import com.tridium.portal.api.XLicense;
import com.tridium.portal.wb.LicenseProcedure;
import com.tridium.workbench.shell.WbMain;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class BLicensePad
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BLicensePad.class);
    private static KeyComparator keyComparator = new KeyComparator();
    static final Lexicon lex = LicenseProcedure.lex;
    static HashMap<String, String> lastValues = new HashMap();
    ArrayList<Entry> entries;
    BWidget owner;
    Entry hostId = new Entry("hostId", lex.getText("hostId"), lastValues.get("hostId"), 40, true);
    Entry name = new Entry("name", lex.getText("name"), lastValues.get("name"), 40, true);
    Entry company = new Entry("company", lex.getText("company"), lastValues.get("company"), 40, true);
    Entry email = new Entry("email", lex.getText("email"), lastValues.get("email"), 40, true);
    Entry po = new Entry("po", lex.getText("po"), lastValues.get("po"), 40, true);

    public Type getType() {
        return TYPE;
    }

    public BLicensePad() {
        this(null);
    }

    public BLicensePad(BWidget owner) {
        this.owner = owner;
        this.entries = new ArrayList(10);
        this.hostId = new Entry("hostId", lex.getText("hostId"), lastValues.get("hostId"), 40, true);
        this.entries.add(this.hostId);
        this.name = new Entry("name", lex.getText("name"), lastValues.get("name"), 40, true);
        this.entries.add(this.name);
        this.company = new Entry("company", lex.getText("company"), lastValues.get("company"), 40, true);
        this.entries.add(this.company);
        this.email = new Entry("email", lex.getText("email"), lastValues.get("email"), 40, true);
        this.entries.add(this.email);
        this.po = new Entry("po", lex.getText("po"), lastValues.get("po"), 40, true);
        this.entries.add(this.po);
        String[] brandKeys = PortalApi.getBrandKeys();
        ArrayList<String> temp = new ArrayList<String>(brandKeys.length);
        for (String key : brandKeys) {
            int dot;
            if (!key.startsWith("submit.") || (dot = key.indexOf(46)) == -1) continue;
            try {
                Integer.parseInt(key.substring(dot + 1));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            temp.add(key);
        }
        Object[] submitKeys = temp.toArray(new String[temp.size()]);
        SortUtil.sort((Object[])submitKeys, (Object[])submitKeys, (Comparator)keyComparator);
        for (Object submitKey : submitKeys) {
            String lastValue;
            String keyValue = PortalApi.brandGet((String)submitKey, null);
            if (keyValue == null) continue;
            StringTokenizer t = new StringTokenizer(keyValue, ",");
            String key = t.nextToken();
            boolean required = t.nextToken().equals("true");
            String defLabel = t.nextToken();
            String label = lex.get(key);
            if (label == null) {
                label = defLabel;
            }
            if ((lastValue = lastValues.get(key)) == null) {
                lastValue = "";
            }
            this.entries.add(new Entry(key, label, lastValue, 40, required, true));
        }
        BGridPane grid = new BGridPane();
        for (Entry entry : this.entries) {
            grid.add(null, (BValue)entry.label);
            grid.add(null, (BValue)entry.field);
        }
        this.setCenter((BWidget)grid);
        BLabel req = new BLabel("* - " + lex.getText("indicateRequired"));
        req.setHalign(BHalign.left);
        this.setBottom((BWidget)new BBorderPane((BWidget)req, 8.0, 4.0, 4.0, 0.0));
    }

    public void load(XLicense lic) {
        this.hostId.load(lic.hostId);
        this.name.load(lic.name);
        this.company.load(lic.company);
        this.email.load(lic.email);
        this.po.load(lic.po);
        for (Entry entry : this.entries) {
            if (!entry.dynamic) continue;
            String value = lic.get(entry.key);
            if (value == null) {
                value = "";
            }
            entry.load(value);
        }
    }

    public XLicense save() {
        try {
            XLicense lic = new XLicense();
            lic.hostId = this.hostId.save();
            lastValues.put("hostId", lic.hostId);
            lic.name = this.name.save();
            lastValues.put("name", lic.name);
            lic.company = this.company.save();
            lastValues.put("company", lic.company);
            lic.email = this.email.save();
            lastValues.put("email", lic.email);
            lic.po = this.po.save();
            lastValues.put("po", lic.po);
            lic.version = "" + Sys.getBajaVersion();
            for (Entry entry : this.entries) {
                if (!entry.dynamic) continue;
                String value = entry.save();
                lic.add(entry.key, value);
                lastValues.put(entry.key, value);
            }
            return lic;
        }
        catch (SaveException e) {
            return null;
        }
    }

    static {
        lastValues.put("hostId", PortalApi.MY_HOST_ID);
        lastValues.put("name", WbMain.getLicenseName() == null ? "" : WbMain.getLicenseName());
        lastValues.put("company", WbMain.getLicenseCompany() == null ? "" : WbMain.getLicenseCompany());
        lastValues.put("email", WbMain.getLicenseEmail() == null ? "" : WbMain.getLicenseEmail());
        lastValues.put("po", "");
    }

    private static class KeyComparator
    implements Comparator<String> {
        private KeyComparator() {
        }

        @Override
        public int compare(String key1, String key2) {
            int i1 = this.index(key1);
            int i2 = this.index(key2);
            return i1 - i2;
        }

        public int index(String key) {
            int dot = key.indexOf(46);
            return Integer.parseInt(key.substring(dot + 1));
        }
    }

    class Entry {
        String key;
        String labelText;
        BLabel label;
        BTextField field;
        boolean required;
        boolean dynamic;

        Entry(String key, String label, String last, int size, boolean req) {
            this(key, label, last, size, req, false);
        }

        Entry(String key, String label, String last, int size, boolean req, boolean dynamic) {
            this.key = key;
            this.labelText = label;
            this.label = new BLabel(req ? label + "*" : label);
            this.field = new BTextField(last, size);
            this.required = req;
            this.dynamic = dynamic;
        }

        public void load(String value) {
            this.field.setText(value.trim());
        }

        public String save() {
            String value = this.field.getText().trim();
            if (value.length() > 0 || !this.required) {
                return value;
            }
            String msg = lex.getText("requiredField", new Object[]{this.labelText});
            BDialog.error((BWidget)BLicensePad.this.owner, (Object)msg);
            throw new SaveException();
        }
    }

    static class SaveException
    extends RuntimeException {
        SaveException() {
        }
    }
}

