/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.videoStream;

import com.tridium.util.EscUtil;
import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPane;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoPlayback;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.UnboundException;

public class BVideoStreamBinding
extends BBinding {
    public static final Type TYPE = Sys.loadType(BVideoStreamBinding.class);
    int videoStreamBindingId;
    static int nextVideoStreamBindingId = 0;
    protected static Logger log = Logger.getLogger("videoDriver.videoStreamBinding");
    protected BPlaybackParams playbackParams;
    protected BIVideoSource videoSource;
    protected BIVideoPlayer videoPlayer;
    protected IVideoStream videoStream;
    protected IVideoDecoder videoDecoder;
    protected IVideoPlayback videoPlaybackWidget;
    protected BComponent stationTargetComponent;
    protected VideoPlaybackSession videoPlaybackSession;
    protected ConnectionManager connectionManager;
    protected volatile boolean isStopped = false;

    public Type getType() {
        return TYPE;
    }

    public BVideoStreamBinding(boolean d) {
        if (nextVideoStreamBindingId == Integer.MAX_VALUE) {
            nextVideoStreamBindingId = 0;
        }
        this.videoStreamBindingId = nextVideoStreamBindingId++;
    }

    public BVideoStreamBinding() {
        if (nextVideoStreamBindingId == Integer.MAX_VALUE) {
            nextVideoStreamBindingId = 0;
        }
        this.videoStreamBindingId = nextVideoStreamBindingId++;
        if (log.isLoggable(Level.FINE)) {
            this.trace(((Object)((Object)this)).getClass().getName());
        }
        this.videoPlaybackWidget = new IVideoPlayback(){

            public void changePlayback(BPlaybackParams playbackParams) {
                if (BVideoStreamBinding.this.connectionManager != null) {
                    BVideoStreamBinding.this.connectionManager.restart();
                }
            }
        };
    }

    public BVideoStreamBinding(IVideoPlayback videoPlaybackWidget) {
        this();
        this.videoPlaybackWidget = videoPlaybackWidget;
    }

    public void started() {
        block3: {
            if (log.isLoggable(Level.FINE)) {
                this.trace("started callback");
            }
            this.connectionManager = new ConnectionManager();
            Thread t = new Thread((Runnable)this.connectionManager, this.getResourcName());
            t.start();
            try {
                super.started();
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, "Exception in BVideoStreamBinding.started()", e);
            }
        }
    }

    public void stopped() {
        block4: {
            this.isStopped = true;
            if (log.isLoggable(Level.FINE)) {
                this.trace("stopped callback.");
            }
            if (this.connectionManager != null) {
                this.connectionManager.done();
            }
            try {
                super.stopped();
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.log(Level.FINE, "Exception in BVideoStreamBinding.stopped()", e);
            }
        }
    }

    public void targetChanged() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("targetChanged callback");
        }
        this.applyDegradeBehavior();
        BWidget widget = this.getWidget();
        if (widget != null) {
            widget.relayout();
        } else {
            new BNullWidget().add("placeHolder?", (BValue)this);
        }
        this.connectionManager.decode();
    }

    public boolean firedOnWidget(Topic topic, BValue event, Context context) {
        if (this.getWidget() instanceof BIVideoPlayer && topic != null && this.videoPlayer != null && this.videoPlayer.getReloadVideoTopic() != null && topic.equals(this.videoPlayer.getReloadVideoTopic())) {
            if (log.isLoggable(Level.FINE)) {
                this.trace("firedOnWidget - topic equals videoPlayer.getReloadVideoTopic()");
            }
            this.connectionManager.restart();
            return true;
        }
        return super.firedOnWidget(topic, event, context);
    }

    private boolean initiateStream(boolean restart) {
        if (log.isLoggable(Level.FINE)) {
            this.trace("initiateStream");
        }
        try {
            if (restart && !this.videoDecoder.isFinished()) {
                if (log.isLoggable(Level.FINE)) {
                    this.trace("stopDecoding");
                }
                this.videoPlaybackSession.stopDecoding(this.videoDecoder, this.videoStream);
            }
            if (!this.resolveFresh()) {
                return false;
            }
            try {
                Thread.sleep((int)(Math.random() * 500.0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isStopped) {
                return false;
            }
            this.videoStream = this.videoPlaybackSession.establishVideoStream(this.videoSource, this.playbackParams, this.videoDecoder, this);
            return this.videoStream != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDown() {
        if (this.videoPlaybackSession != null) {
            if (log.isLoggable(Level.FINE)) {
                this.trace("Stopping video session.");
            }
            this.videoPlaybackSession.stopVideoSession();
        }
        if (this.videoDecoder != null) {
            WaitForStopDecoding monitor;
            if (log.isLoggable(Level.FINE)) {
                this.trace("Stopping decoder.");
            }
            WaitForStopDecoding waitForStopDecoding = monitor = new WaitForStopDecoding();
            synchronized (waitForStopDecoding) {
                try {
                    this.videoDecoder.stopDecoding(monitor);
                    monitor.wait(5000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean resolveFresh() {
        if (this.resolveVideoPlayer() && this.resolveStationTarget() && this.resolveVideoSource()) {
            this.resolveVideoPlaybackSession();
            this.resolvePlaybackParams();
            if (this.resolveVideoDecoder()) {
                return true;
            }
        }
        return false;
    }

    protected boolean resolveVideoPlayer() {
        BWidget boundWidget;
        if (log.isLoggable(Level.FINE)) {
            this.trace("resolveVideoPlayer...");
        }
        if ((boundWidget = this.getWidget()) == null || !(boundWidget instanceof BIVideoPlayer)) {
            if (log.isLoggable(Level.FINE)) {
                this.trace("The expected boundWidget is not a BIVideoPlayer.");
            }
            return false;
        }
        this.videoPlayer = (BIVideoPlayer)boundWidget;
        if (boundWidget instanceof BVideoMultistreamPane) {
            return true;
        }
        BVideoMultistreamPane multistreamPane = BVideoMultistreamPane.getVideoMultistreamPane(boundWidget);
        return multistreamPane == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveStationTarget() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("resolveStationTarget...");
        }
        BObject target = null;
        BComponent stationTarget = null;
        try {
            target = this.get();
            if (target instanceof BComponent && target instanceof BIVideoSource) {
                stationTarget = (BComponent)target;
            }
        }
        catch (UnboundException e) {
            if (log.isLoggable(Level.FINE)) {
                this.trace("Unable to resolve station target: " + (Object)((Object)e));
            }
            target = null;
            stationTarget = null;
        }
        finally {
            this.stationTargetComponent = stationTarget;
        }
        return stationTarget != null;
    }

    protected boolean resolveVideoSource() {
        boolean streamFox;
        BFoxVideoStreamEnum foxStreamEnum;
        BIVideoSource videoSource = (BIVideoSource)this.stationTargetComponent;
        if (videoSource instanceof BDevice) {
            BDevice videoSourceDevice = (BDevice)videoSource;
            if (videoSourceDevice.isFault()) {
                if (videoSourceDevice instanceof BIVideoCamera) {
                    this.videoPlayer.setMessage(VideoDriverLexicon.getLexString((String)"VideoStreamBinding.cameraDeviceFault", (Object)((BIVideoCamera)videoSourceDevice).getCameraDescription(), (Object)videoSourceDevice.getFaultCause()));
                } else {
                    this.videoPlayer.setMessage(VideoDriverLexicon.getLexString((String)"VideoStreamBinding.cameraDeviceFault", (Object)videoSourceDevice.getName(), (Object)videoSourceDevice.getFaultCause()));
                }
                return false;
            }
        } else if (videoSource instanceof BIRemoteVideoCamera) {
            this.videoPlayer.setMessage(VideoDriverLexicon.LEX.getText("VideoStreamBiding.ResolvingThroughNiagaraStation"));
            boolean isCameraFault = ((BIRemoteVideoCamera)videoSource).isCameraFault();
            if (isCameraFault) {
                String cameraDescription = ((BIRemoteVideoCamera)videoSource).getCameraDescription();
                String cameraFaultCause = ((BIRemoteVideoCamera)videoSource).getCameraFaultCause();
                this.videoPlayer.setMessage(VideoDriverLexicon.getLexString((String)"VideoStreamBinding.cameraDeviceFault", (Object)cameraDescription, (Object)cameraFaultCause));
                return false;
            }
        }
        if ((foxStreamEnum = this.videoPlayer.getVideoStreamFox()) == BFoxVideoStreamEnum.yes) {
            streamFox = true;
        } else if (foxStreamEnum == BFoxVideoStreamEnum.no) {
            streamFox = false;
        } else if (foxStreamEnum == BFoxVideoStreamEnum.inherit) {
            streamFox = videoSource.isFoxVideoStreamPreferred();
        } else {
            throw new IllegalStateException("Unrecognized foxStreamEnum: " + foxStreamEnum);
        }
        if (streamFox) {
            return this.resolveFoxVideoSource();
        }
        this.videoSource = videoSource;
        return true;
    }

    protected void resolveVideoPlaybackSession() {
        if (this.videoPlaybackSession == null) {
            if (log.isLoggable(Level.FINE)) {
                this.trace("Allocating video playback session object.");
            }
            this.videoPlaybackSession = new VideoPlaybackSession(this.videoPlaybackWidget);
        }
    }

    protected void resolvePlaybackParams() {
        if (log.isLoggable(Level.FINE)) {
            this.trace("resolvePlaybackParams...");
        }
        BPlaybackParams playbackParams = (BPlaybackParams)this.videoPlayer.getPlaybackParams().newCopy();
        playbackParams.setVideoSourceOrd(this.videoSource.getSlotPathOrd());
        this.videoSource.initPlaybackParams(playbackParams, (IVideoSession)this.videoPlaybackSession);
        this.playbackParams = playbackParams;
    }

    protected boolean resolveVideoDecoder() {
        IVideoDecoder newVideoDecoder = this.videoSource.makeVideoDecoder(this.playbackParams);
        if (newVideoDecoder == null) {
            if (log.isLoggable(Level.FINE)) {
                this.trace("ERROR : videoSource.makeVideoDecoder Returned null");
            }
            return false;
        }
        try {
            newVideoDecoder.init(this.videoSource, this.videoPlayer, BRelTime.makeSeconds((int)10), (IVideoSession)this.videoPlaybackSession);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.videoPlayer.setVideoDecoder(newVideoDecoder);
        this.videoDecoder = newVideoDecoder;
        return true;
    }

    protected boolean resolveFoxVideoSource() {
        BFoxVideoSource foxVideoSource = null;
        BFoxVideoSource[] foxVideoSources = (BFoxVideoSource[])this.stationTargetComponent.getChildren(BFoxVideoSource.class);
        if (foxVideoSources != null && foxVideoSources.length > 0) {
            foxVideoSource = foxVideoSources[0];
        } else {
            foxVideoSource = new BFoxVideoSource();
            try {
                String foxVideoSourcePropName = EscUtil.slot.escape("Fox Video Source");
                Mark newCopy = new Mark((BObject)foxVideoSource, foxVideoSourcePropName);
                newCopy.copyTo((BObject)this.stationTargetComponent, null);
            }
            catch (Exception e) {
                log.severe("Unexpected scenario: Unable to create Fox Video Source");
                foxVideoSource = null;
            }
        }
        this.videoSource = foxVideoSource;
        return foxVideoSource != null;
    }

    protected void trace(String memo) {
        log.fine("[" + this.videoStreamBindingId + "] " + memo);
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    String getResourcName() {
        return "VideoStreamBinding" + this.videoStreamBindingId;
    }

    class ConnectionManager
    extends Thread {
        static final int IDLE = 1;
        static final int ESTABLISH = 2;
        static final int REESTABLISH = 3;
        static final int DECODING = 4;
        static final int STOP = 5;
        int state = 1;
        boolean done = false;

        ConnectionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.done) {
                long tmo = -1L;
                if (log.isLoggable(Level.FINE)) {
                    BVideoStreamBinding.this.trace("ConnectionManager " + this.stateToString());
                }
                switch (this.state) {
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        if (BVideoStreamBinding.this.initiateStream(false)) {
                            this.state = 4;
                            break;
                        }
                        tmo = 3000L;
                        break;
                    }
                    case 3: {
                        if (BVideoStreamBinding.this.initiateStream(true)) {
                            this.state = 4;
                            break;
                        }
                        tmo = 10000L;
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
                if (this.done) break;
                ConnectionManager connectionManager = this;
                synchronized (connectionManager) {
                    if (tmo > 0L) {
                        try {
                            this.wait(tmo);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        try {
                            this.wait();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                BVideoStreamBinding.this.trace("ConnectionManager shutDown");
            }
            BVideoStreamBinding.this.shutDown();
        }

        synchronized void decode() {
            if (this.state == 1) {
                this.state = 2;
            }
            this.notify();
        }

        synchronized void restart() {
            if (this.state == 1) {
                this.state = 2;
            } else if (this.state == 4) {
                this.state = 3;
            }
            this.notify();
        }

        synchronized void done() {
            this.state = 5;
            this.done = true;
            this.notify();
        }

        String stateToString() {
            switch (this.state) {
                case 1: {
                    return "IDLE";
                }
                case 2: {
                    return "ESTABLISH";
                }
                case 3: {
                    return "REESTABLISH";
                }
                case 4: {
                    return "DECODING";
                }
                case 5: {
                    return "STOP";
                }
            }
            return "invalid state";
        }
    }
}

