/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.multistream;

import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.ui.videoStream.BVideoMultistreamBinding;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;

public class BVideoMultistreamPane
extends BBorderPane
implements BIVideoPlayer {
    public static final Property label = BVideoMultistreamPane.newProperty((int)4, (BValue)new BNullWidget(), null);
    public static final Property content = BVideoMultistreamPane.newProperty((int)0, (BValue)new BCanvasPane(), null);
    public static final Property videoStreamFox = BVideoMultistreamPane.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, null);
    public static final Property resolution = BVideoMultistreamPane.newProperty((int)0, (BValue)BVideoResolutionEnum.low, null);
    public static final Property frameRate = BVideoMultistreamPane.newProperty((int)0, (BValue)BVideoFrameRateEnum.low, null);
    public static final Property compression = BVideoMultistreamPane.newProperty((int)0, (BValue)BVideoCompressionEnum.medium, null);
    public static final Property streamFacets = BVideoMultistreamPane.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Topic reloadVideo = BVideoMultistreamPane.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoMultistreamPane.class);
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/multistreamPane.png");
    protected String message;
    protected IVideoMultistreamDecoder videoMultistreamDecoder;
    protected BPlaybackParams playBackParams = new BPlaybackParams();
    protected BIVideoPlayer[] videoPlayers = new BIVideoPlayer[0];

    public BWidget getLabel() {
        return (BWidget)this.get(label);
    }

    public void setLabel(BWidget v) {
        this.set(label, (BValue)v, null);
    }

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public BFoxVideoStreamEnum getVideoStreamFox() {
        return (BFoxVideoStreamEnum)this.get(videoStreamFox);
    }

    public void setVideoStreamFox(BFoxVideoStreamEnum v) {
        this.set(videoStreamFox, (BValue)v, null);
    }

    public BVideoResolutionEnum getResolution() {
        return (BVideoResolutionEnum)this.get(resolution);
    }

    public void setResolution(BVideoResolutionEnum v) {
        this.set(resolution, (BValue)v, null);
    }

    public BVideoFrameRateEnum getFrameRate() {
        return (BVideoFrameRateEnum)this.get(frameRate);
    }

    public void setFrameRate(BVideoFrameRateEnum v) {
        this.set(frameRate, (BValue)v, null);
    }

    public BVideoCompressionEnum getCompression() {
        return (BVideoCompressionEnum)this.get(compression);
    }

    public void setCompression(BVideoCompressionEnum v) {
        this.set(compression, (BValue)v, null);
    }

    public BFacets getStreamFacets() {
        return (BFacets)this.get(streamFacets);
    }

    public void setStreamFacets(BFacets v) {
        this.set(streamFacets, (BValue)v, null);
    }

    public void fireReloadVideo(BPlaybackParams event) {
        this.fire(reloadVideo, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.loadVideoPlayers();
    }

    protected void loadVideoPlayers() {
        this.videoPlayers = BVideoMultistreamPane.getVideoPlayers((BWidget)this);
    }

    protected void dispatchMessage(String message) {
        BIVideoPlayer[] players = this.getVideoPlayers();
        for (int i = 0; i < players.length; ++i) {
            players[i].setMessage(message);
        }
    }

    private static BOrd makeStationOrd(BOrd ord) {
        if (ord == null) {
            return null;
        }
        if (!ord.toString().startsWith("station:|")) {
            ord = BOrd.make((String)("station:|" + ord.toString()));
        }
        return ord;
    }

    private void updateNextFrame(VidFrame newFrame) {
        BIVideoPlayer[] players = this.getVideoPlayers();
        IVideoMultistreamDecoder.MultistreamFrame nextMultistreamFrame = (IVideoMultistreamDecoder.MultistreamFrame)newFrame;
        BOrdList camerasToUpdate = nextMultistreamFrame.videoCameras;
        for (int i = 0; i < camerasToUpdate.size(); ++i) {
            BOrd particularCameraForFrame = BVideoMultistreamPane.makeStationOrd(camerasToUpdate.get(i));
            for (int j = 0; j < players.length; ++j) {
                BDevice videoCameraDevice;
                BOrd cameraForVideoPlayer = BVideoMultistreamPane.makeStationOrd(BVideoMultistreamBinding.getCameraOrdForVideoPlayer(players[j]));
                if (cameraForVideoPlayer == null || !cameraForVideoPlayer.equals((Object)particularCameraForFrame)) continue;
                BObject multistreamSourceObject = this.videoMultistreamDecoder.getVideoSource().asObject();
                BObject videoCameraObject = cameraForVideoPlayer.get(multistreamSourceObject);
                if (videoCameraObject instanceof BDevice && (videoCameraDevice = (BDevice)videoCameraObject).isFault()) {
                    if (videoCameraObject instanceof BIVideoCamera) {
                        players[j].setMessage(VideoDriverLexicon.getLexString((String)"VideoStreamBinding.cameraDeviceFault", (Object)((BIVideoCamera)videoCameraObject).getCameraDescription(), (Object)videoCameraDevice.getFaultCause()));
                        continue;
                    }
                    players[j].setMessage(VideoDriverLexicon.getLexString((String)"VideoStreamBinding.cameraDeviceFault", (Object)videoCameraDevice.getName(), (Object)videoCameraDevice.getFaultCause()));
                    continue;
                }
                players[j].setVideoDecoder((IVideoDecoder)this.videoMultistreamDecoder);
                players[j].updateVideoFrame(newFrame);
            }
        }
    }

    public BIVideoPlayer[] getVideoPlayers() {
        return this.videoPlayers;
    }

    public static BVideoMultistreamPane getVideoMultistreamPane(BWidget videoPlayer) {
        if (videoPlayer == null) {
            return null;
        }
        if (videoPlayer instanceof BVideoMultistreamPane) {
            return (BVideoMultistreamPane)videoPlayer;
        }
        if (videoPlayer instanceof BVideoPlayer) {
            BVideoMultistreamPaneForView multistreamPaneForView = ((BVideoPlayer)videoPlayer).getMultistreamPaneForView();
            if (multistreamPaneForView != null) {
                return multistreamPaneForView;
            }
            return BVideoMultistreamPane.getVideoMultistreamPane(videoPlayer.getParentWidget());
        }
        return BVideoMultistreamPane.getVideoMultistreamPane(videoPlayer.getParentWidget());
    }

    protected static BIVideoPlayer[] getVideoPlayers(BWidget root) {
        BWidget[] childWidgets = root.getChildWidgets();
        if (childWidgets == null) {
            return new BIVideoPlayer[0];
        }
        Array videoPlayers = new Array(BIVideoPlayer.class);
        for (int i = 0; i < childWidgets.length; ++i) {
            if (childWidgets[i] instanceof BIVideoPlayer) {
                videoPlayers.add((Object)((BIVideoPlayer)childWidgets[i]));
                continue;
            }
            videoPlayers.addAll((Object[])BVideoMultistreamPane.getVideoPlayers(childWidgets[i]));
        }
        return (BIVideoPlayer[])videoPlayers.trim();
    }

    public void resetImage() {
        for (int i = 0; i < this.videoPlayers.length; ++i) {
            this.videoPlayers[i].resetImage();
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.dispatchMessage(message);
    }

    public void setVideoDecoder(IVideoDecoder videoDecoder) {
        this.videoMultistreamDecoder = videoDecoder.getMultistreamDecoder();
    }

    public IVideoDecoder getVideoDecoder() {
        return this.videoMultistreamDecoder;
    }

    public void updateVideoFrame(VidFrame newFrame) {
        this.updateNextFrame(newFrame);
    }

    public BPlaybackParams getPlaybackParams() {
        this.playBackParams.setResolution(this.getResolution());
        this.playBackParams.setFrameRate(this.getFrameRate());
        this.playBackParams.setCompression(this.getCompression());
        this.playBackParams.setVideoFacets(BFacets.make((BFacets)this.playBackParams.getVideoFacets(), (BFacets)this.getStreamFacets()));
        return this.playBackParams;
    }

    public Topic getReloadVideoTopic() {
        return reloadVideo;
    }

    public BIcon getIcon() {
        return icon;
    }
}

