/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.multistream;

import com.tridium.videoDriver.ui.multistream.BVideoMultistreamCameraChooserList;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;

public class BVideoMultistreamDragAndDropCamera
extends BLabel {
    public static final Property cameraOrd = BVideoMultistreamDragAndDropCamera.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property background = BVideoMultistreamDragAndDropCamera.newProperty((int)0, (BValue)BBrush.makeSolid((BColor)BColor.make((int)0, (int)0, (int)0, (int)0)), null);
    public static final Type TYPE = Sys.loadType(BVideoMultistreamDragAndDropCamera.class);
    private boolean mouseOver = false;
    private boolean isReadOnly;
    protected BVideoMultistreamCameraChooserList cameraChooserList;
    public static BBrush HALF_TRANSPARENT_LIGHT_BLUE = BBrush.makeSolid((BColor)BColor.make((int)BColor.lightBlue.getRed(), (int)BColor.lightBlue.getGreen(), (int)BColor.lightBlue.getBlue(), (int)128));

    public BOrd getCameraOrd() {
        return (BOrd)this.get(cameraOrd);
    }

    public void setCameraOrd(BOrd v) {
        this.set(cameraOrd, (BValue)v, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoMultistreamDragAndDropCamera() {
    }

    public BVideoMultistreamDragAndDropCamera(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setVideoCameraChooserList(BVideoMultistreamCameraChooserList cameraChooserList) {
        this.cameraChooserList = cameraChooserList;
    }

    public void paint(Graphics g) {
        if (this.isMouseOver() && !this.isReadOnly) {
            g.setBrush(HALF_TRANSPARENT_LIGHT_BLUE);
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        } else {
            g.setBrush(this.getBackground());
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null && !this.isReadOnly) {
            shell.showStatus(this.getText());
            this.setMouseCursor(MouseCursor.openHand);
        }
        this.mouseOver = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(null);
        }
        this.mouseOver = false;
        this.setMouseCursor(MouseCursor.normal);
        this.repaint();
    }

    public void mouseDragStarted(BMouseEvent event) {
        if (!this.isReadOnly) {
            this.cameraChooserList.mouseDragStarted(event, this);
        }
    }
}

