/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.display;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayLayout;
import com.tridium.videoDriver.display.BVideoDisplayMultistream;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamViewer;
import java.util.logging.Level;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BVideoDisplayView
extends BVideoMultistreamViewer {
    public static final Type TYPE = Sys.loadType(BVideoDisplayView.class);
    protected BIVideoDisplay videoDisplay;
    private int lastLayoutOrdinal;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.videoDisplay = (BIVideoDisplay)value;
        if (!(this.videoDisplay instanceof BComponent)) {
            return;
        }
        BVideoDisplayMultistream vdm = this.videoDisplay.getVideoDisplayMultistream();
        vdm.lease();
        super.doLoadValue((BObject)vdm, context);
        this.lastLayoutOrdinal = vdm.getLayout().getOrdinal();
        this.updateVideoDisplay(true);
    }

    @Override
    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        super.doSaveValue((BObject)this.videoDisplay.getVideoDisplayMultistream(), context);
        this.updateVideoDisplay(false);
        return value;
    }

    @Override
    public void drawMultistreamViewer() {
        super.drawMultistreamViewer();
        BPermissions displayPermissions = this.getCurrentValue().asComponent().getPermissions(this.getCurrentContext());
        if (!displayPermissions.hasAdminWrite()) {
            this.mainLeftPane.setEnabled(false);
        }
    }

    protected void updateVideoDisplay(boolean init) {
        BVideoDisplayMultistream vdm = this.videoDisplay.getVideoDisplayMultistream();
        vdm.lease();
        BFrozenEnum layout = vdm.getLayout();
        if (!(layout instanceof BIVideoDisplayLayout)) {
            return;
        }
        BIVideoDisplayLayout displayLayout = (BIVideoDisplayLayout)layout;
        BComponentSpace cs = ((BComponent)this.videoDisplay).getComponentSpace();
        if (init || this.layoutChanged()) {
            FoxRpcUtil.doSilentRpc((BISpaceNode)((BISpaceNode)this.videoDisplay), (String)"switchToLayout", (Object[])new Object[]{displayLayout});
        }
        BOrdList ordList = BOrdList.make((BOrd[])this.multistreamViewerCameraOrds);
        BComponent args = new BComponent();
        args.add("ords", (BValue)ordList);
        args.add("layout", (BValue)layout);
        FoxRpcUtil.doSilentRpc((BISpaceNode)((BISpaceNode)this.videoDisplay), (String)"mapCamerasToLayout", (Object[])new Object[]{args});
    }

    private boolean layoutChanged() {
        BVideoDisplayMultistream vdm = this.videoDisplay.getVideoDisplayMultistream();
        vdm.lease();
        int newLayoutOrdinal = vdm.getLayout().getOrdinal();
        if (newLayoutOrdinal != this.lastLayoutOrdinal) {
            this.lastLayoutOrdinal = newLayoutOrdinal;
            return true;
        }
        return false;
    }

    @Override
    public void doSwitchVideoLayout() {
        BDevice videoDisplayDevice;
        if (this.videoDisplay instanceof BDevice && !(videoDisplayDevice = (BDevice)this.videoDisplay).getEnabled()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Video Display is disabled");
            }
            return;
        }
        super.doSwitchVideoLayout();
    }
}

