/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public class BVideoZoomSlider
extends BWidget {
    public static final Property background = BVideoZoomSlider.newProperty((int)0, (BValue)Theme.scrollBar().getControlBackground(), null);
    public static final Property border = BVideoZoomSlider.newProperty((int)0, (BValue)BBorder.inset, null);
    public static final Property keepDownInterval = BVideoZoomSlider.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    public static final Action checkMouseStillPressed = BVideoZoomSlider.newAction((int)0, null);
    public static final Topic zoom = BVideoZoomSlider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoZoomSlider.class);
    private static final BIcon icon = BIcon.std((String)"zoomIn.png");
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING_BUTTON = 1;
    public static final int SPEED_NONE = 0;
    public static final int SPEED_SLOW = 1;
    public static final int SPEED_MEDIUM = 2;
    public static final int SPEED_FAST = 3;
    public static final int DIRECTION_ZOOM_IN = 1;
    public static final int DIRECTION_ZOOM_OUT = 2;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final double BUTTON_DIAMETER_PERCENT = 0.95;
    private static final double slowPercent = 0.65;
    private static final int cap = 102;
    private static final int join = 203;
    private static final BPen solidPen = BPen.make((double)1.0, (int)102, (int)203, null);
    protected int joystickState;
    protected double mouseX = 0.0;
    protected double mouseY = 0.0;
    protected double boxX;
    protected double boxY;
    protected double boxW;
    protected double boxH;
    protected double buttonX;
    protected double buttonY;
    protected double buttonW;
    protected double buttonH;
    protected int speed = -1;
    protected int direction = -1;
    protected int orientation = -1;
    protected BVideoZoomEnum zoomAction = null;
    protected PolygonGeom zoomInRegion;
    protected PolygonGeom zoomOutRegion;
    protected RectGeom deadRegion;
    protected RectGeom slowRegion;
    protected RectGeom mediumRegion;
    public Clock.Ticket checkMouseStillPressedTicket = null;
    public static Queue movementProcessingQueue = new Queue();
    public static Worker movementProcessingWorker = new Worker((Worker.ITodo)movementProcessingQueue);
    public static final BImage MAGNIFYING_GLASS_IMAGE = BImage.make((BIcon)BIcon.std((String)"magnifyingGlass.png"));
    public static final BImage MAGNIFYING_GLASS_DISABLED_IMAGE = MAGNIFYING_GLASS_IMAGE.getDisabledImage();

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush v) {
        this.set(background, (BValue)v, null);
    }

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder v) {
        this.set(border, (BValue)v, null);
    }

    public BRelTime getKeepDownInterval() {
        return (BRelTime)this.get(keepDownInterval);
    }

    public void setKeepDownInterval(BRelTime v) {
        this.set(keepDownInterval, (BValue)v, null);
    }

    public void checkMouseStillPressed() {
        this.invoke(checkMouseStillPressed, null, null);
    }

    public void fireZoom(BVideoZoomEnum event) {
        this.fire(zoom, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoZoomSlider() {
        this.setLayout(BLayout.makeAbs((double)1.0, (double)1.0, (double)20.0, (double)100.0));
    }

    public void doCheckMouseStillPressed() {
        movementProcessingQueue.enqueue((Object)new Runnable(){

            @Override
            public void run() {
                BVideoZoomSlider.this.asyncCheckMouseStillPressed();
            }
        });
    }

    public synchronized void asyncCheckMouseStillPressed() {
        this.fireZoom(this.zoomAction);
        if (this.joystickState >= 1) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(20.0, 100.0);
    }

    public void doLayout(BWidget[] kids) {
        this.boxX = 1.0;
        this.boxY = 1.0;
        this.boxW = this.getWidth() - 2.0;
        this.boxH = this.getHeight() - 2.0;
        this.computeRegionCoordinates();
    }

    public void setSize(double width, double height) {
        if (width < height) {
            width = MAGNIFYING_GLASS_IMAGE.getWidth() + 4.0;
        } else {
            height = MAGNIFYING_GLASS_IMAGE.getHeight() + 4.0;
        }
        super.setSize(width, height);
    }

    public void paint(Graphics g) {
        g.useAntiAliasing(true);
        try {
            g.push();
            if (this.isEnabled()) {
                g.setBrush(this.getBackground());
            } else {
                g.setBrush(BBrush.makeSolid((BColor)BColor.lightGray));
            }
            g.fillRect(this.boxX, this.boxY, this.boxW, this.boxH);
        }
        finally {
            g.pop();
        }
        this.getBorder().paint(g, this.boxX, this.boxY, this.boxW, this.boxH);
        this.computeButtonCoordinates();
        if (this.joystickState >= 1) {
            this.paintCurrentRegion(g);
            if (this.speed >= 1) {
                g.setPen(solidPen);
                g.setBrush(this.computeSpeedBrush());
                g.strokeRect(this.boxX, this.boxY, this.boxW, this.boxH);
            }
        }
        this.paintButton(g);
        g.useAntiAliasing(false);
    }

    protected void computeButtonCoordinates() {
        double buttonPercent = 0.95;
        if (this.joystickState >= 1) {
            double smallerSide;
            this.buttonW = this.boxW * (buttonPercent / 1.2);
            this.buttonH = this.boxH * (buttonPercent / 1.2);
            this.buttonW = smallerSide = this.buttonW > this.buttonH ? this.buttonH : this.buttonW;
            this.buttonH = smallerSide;
            this.buttonX = this.mouseX - this.buttonW / 2.0;
            this.buttonY = this.mouseY - this.buttonH / 2.0;
            this.joystickState = 1;
            if (this.buttonX < this.boxX) {
                this.buttonX = this.boxX;
            }
            if (this.buttonX > this.boxW - this.buttonW) {
                this.buttonX = this.boxW - this.buttonW;
            }
            if (this.buttonY < this.boxY) {
                this.buttonY = this.boxY;
            }
            if (this.buttonY > this.boxH - this.buttonH) {
                this.buttonY = this.boxH - this.buttonH;
            }
        } else {
            double smallerSide;
            this.buttonW = this.boxW * buttonPercent;
            this.buttonH = this.boxH * buttonPercent;
            this.buttonW = smallerSide = this.buttonW > this.buttonH ? this.buttonH : this.buttonW;
            this.buttonH = smallerSide;
            this.buttonX = this.boxX + this.boxW / 2.0 - this.buttonW / 2.0;
            this.buttonY = this.boxY + this.boxH / 2.0 - this.buttonH / 2.0;
        }
    }

    protected void paintCurrentRegion(Graphics g) {
        if (this.speed >= 1 && this.speed <= 3) {
            g.setBrush(this.computeSpeedBrush());
            if (this.direction > 0) {
                this.fillCurrentRegion(g);
            }
        }
    }

    protected BBrush computeSpeedBrush() {
        BBrush speedBrush = null;
        speedBrush = this.speed == 1 ? BBrush.makeSolid((BColor)BColor.make((int)0x333399FF, (boolean)true)) : (this.speed == 2 ? BBrush.makeSolid((BColor)BColor.make((int)-2009884161, (boolean)true)) : BBrush.makeSolid((BColor)BColor.make((int)-298608129, (boolean)true)));
        return speedBrush;
    }

    protected void fillCurrentRegion(Graphics g) {
        switch (this.direction) {
            case 2: {
                g.fill((IGeom)this.zoomOutRegion);
                break;
            }
            case 1: {
                g.fill((IGeom)this.zoomInRegion);
            }
        }
    }

    protected void computeRegionCoordinates() {
        this.computeOrientation();
        this.computeZoomOutRegion();
        this.computeZoomInRegion();
        this.computeDeadRegion();
        this.computeSlowRegion();
        this.computeMediumRegion();
    }

    protected void computeZoomInRegion() {
        if (this.orientation == 1) {
            double[] xCoords = new double[]{this.boxX, this.boxW, this.boxW, this.boxX};
            double[] yCoords = new double[]{this.boxY, this.boxY, this.boxH / 2.0, this.boxH / 2.0};
            this.zoomInRegion = new PolygonGeom(xCoords, yCoords, xCoords.length);
        } else {
            double[] xCoords = new double[]{this.boxW / 2.0, this.boxW, this.boxW, this.boxW / 2.0};
            double[] yCoords = new double[]{this.boxY, this.boxY, this.boxH, this.boxH};
            this.zoomInRegion = new PolygonGeom(xCoords, yCoords, xCoords.length);
        }
    }

    protected void computeZoomOutRegion() {
        if (this.orientation == 1) {
            double[] xCoords = new double[]{this.boxX, this.boxW, this.boxW, this.boxX};
            double[] yCoords = new double[]{this.boxH, this.boxH, this.boxH / 2.0, this.boxH / 2.0};
            this.zoomOutRegion = new PolygonGeom(xCoords, yCoords, xCoords.length);
        } else {
            double[] xCoords = new double[]{this.boxX, this.boxW / 2.0, this.boxW / 2.0, this.boxX};
            double[] yCoords = new double[]{this.boxY, this.boxY, this.boxH, this.boxH};
            this.zoomOutRegion = new PolygonGeom(xCoords, yCoords, xCoords.length);
        }
    }

    protected void computeOrientation() {
        this.orientation = this.boxW > this.boxH ? 0 : 1;
    }

    protected void computeDeadRegion() {
        double deadW = 0.0;
        double deadH = 0.0;
        if (this.orientation == 1) {
            deadW = this.boxW;
            deadH = this.boxW;
        } else {
            deadW = this.boxH;
            deadH = this.boxH;
        }
        double deadX = this.boxW / 2.0 - deadW / 2.0;
        double deadY = this.boxH / 2.0 - deadH / 2.0;
        this.deadRegion = new RectGeom(deadX, deadY, deadW, deadH);
    }

    protected void computeSlowRegion() {
        double slowW = this.orientation == 1 ? this.boxW : this.boxW * 0.65;
        double slowH = this.orientation == 1 ? this.boxH * 0.65 : this.boxH;
        double slowX = this.boxW / 2.0 - slowW / 2.0;
        double slowY = this.boxH / 2.0 - slowH / 2.0;
        this.slowRegion = new RectGeom(slowX, slowY, slowW, slowH);
    }

    protected void computeMediumRegion() {
        this.mediumRegion = new RectGeom(this.boxX, this.boxY, this.boxW, this.boxH);
    }

    protected void paintButton(Graphics g) {
        try {
            g.push();
            if (this.isEnabled()) {
                g.drawImage(MAGNIFYING_GLASS_IMAGE, this.buttonX + this.buttonW / 2.0 - MAGNIFYING_GLASS_IMAGE.getWidth() / 2.0, this.buttonY + this.buttonH / 2.0 - MAGNIFYING_GLASS_IMAGE.getHeight() / 2.0);
            } else {
                g.drawImage(MAGNIFYING_GLASS_DISABLED_IMAGE, this.buttonX, this.buttonY);
            }
        }
        finally {
            g.pop();
        }
    }

    public synchronized void mouseReleased(BMouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        this.handleMouseReleased();
        this.repaint();
    }

    protected void handleMouseReleased() {
        this.joystickState = 0;
        this.speed = 0;
        this.direction = -1;
        this.zoomAction = BVideoZoomEnum.none;
        this.setMouseCursor(MouseCursor.normal);
        if (this.checkMouseStillPressedTicket != null) {
            this.checkMouseStillPressedTicket.cancel();
            this.fireZoom(this.zoomAction);
        }
    }

    public void mouseDragged(BMouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        int priorJoystickState = this.joystickState;
        BVideoZoomEnum priorZoomAction = this.zoomAction;
        this.joystickState = 1;
        this.speed = this.computeSpeed();
        this.direction = this.computeDirection();
        this.zoomAction = this.computeZoomAction();
        this.setMouseCursor(MouseCursor.grabHand);
        if (priorJoystickState < 1 || priorZoomAction != this.zoomAction) {
            if (this.checkMouseStillPressedTicket != null) {
                this.checkMouseStillPressedTicket.cancel();
            }
            this.fireZoom(this.zoomAction);
        }
        if (this.checkMouseStillPressedTicket == null || this.checkMouseStillPressedTicket.isExpired()) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
        this.repaint();
    }

    protected BVideoZoomEnum computeZoomAction() {
        if (this.joystickState >= 1) {
            switch (this.speed) {
                case 0: {
                    return BVideoZoomEnum.none;
                }
                case 1: {
                    return this.computeZoomActionSlow();
                }
                case 2: {
                    return this.computeZoomActionMedium();
                }
                case 3: {
                    return this.computeZoomActionFast();
                }
            }
            throw new IllegalStateException("Unrecognized speed index (" + this.speed + ").");
        }
        return BVideoZoomEnum.none;
    }

    protected BVideoZoomEnum computeZoomActionSlow() {
        this.computeDirection();
        switch (this.direction) {
            case 1: {
                return BVideoZoomEnum.zoomInSlow;
            }
            case 2: {
                return BVideoZoomEnum.zoomOutSlow;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected BVideoZoomEnum computeZoomActionMedium() {
        switch (this.direction) {
            case 1: {
                return BVideoZoomEnum.zoomInMedium;
            }
            case 2: {
                return BVideoZoomEnum.zoomOutMedium;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected BVideoZoomEnum computeZoomActionFast() {
        switch (this.direction) {
            case 1: {
                return BVideoZoomEnum.zoomInFast;
            }
            case 2: {
                return BVideoZoomEnum.zoomOutFast;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected int computeSpeed() {
        double checkX;
        double buttonMidX = this.buttonX + this.buttonW / 2.0;
        double buttonMidY = this.buttonY + this.buttonH / 2.0;
        double checkY = this.orientation == 1 ? this.mouseY : buttonMidY;
        double d = checkX = this.orientation == 1 ? buttonMidX : this.mouseX;
        if (this.deadRegion.contains(checkX, checkY)) {
            return 0;
        }
        if (this.slowRegion.contains(checkX, checkY)) {
            return 1;
        }
        if (this.mediumRegion.contains(checkX, checkY)) {
            return 2;
        }
        return 3;
    }

    protected int computeDirection() {
        double buttonMidX = this.buttonX + this.buttonW / 2.0;
        double buttonMidY = this.buttonY + this.buttonH / 2.0;
        if (this.zoomInRegion.contains(buttonMidX, buttonMidY)) {
            return 1;
        }
        if (this.zoomOutRegion.contains(buttonMidX, buttonMidY)) {
            return 2;
        }
        return -1;
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        movementProcessingWorker.start("BVideoZoomSlider:worker");
    }
}

