/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.ui.UiEnv;
import com.tridium.util.EscUtil;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.BVideoPlaybackChooser;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamViewer;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.workbench.BWbEditor;

public class BVideoCameraPickerFE
extends BWbEditor {
    public static final Action listActionPerformed = BVideoCameraPickerFE.newAction((int)0, null);
    public static final Topic cameraChosen = BVideoCameraPickerFE.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BVideoCameraPickerFE.class);
    ListPopulatorThreadGroup listPopulatorThreads = new ListPopulatorThreadGroup();
    protected BWidget parentWidget;
    protected BVideoPlaybackChooser videoPlaybackChooser;
    protected BDropDown dropDown;
    protected BList dropDownList = new BList();
    protected BLabel dropDownDisplay;
    protected Item[] items;
    public static final BImage QUESTION_MARK_IMAGE = BImage.make((BIcon)BIcon.std((String)"questionMark.png"));

    public void listActionPerformed() {
        this.invoke(listActionPerformed, null, null);
    }

    public void fireCameraChosen(BOrd event) {
        this.fire(cameraChosen, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVideoCameraPickerFE() {
        this.dropDownList.setMultipleSelection(false);
        this.dropDownDisplay = new BLabel("", BHalign.center);
        this.dropDownDisplay.setValign(BValign.center);
        this.dropDown = new BDropDown((BWidget)new BBorderPane((BWidget)this.dropDownDisplay, BBorder.none, BInsets.make((double)0.0, (double)4.0, (double)0.0, (double)4.0)), (BWidget)this.dropDownList);
        this.setContent((BWidget)this.dropDown);
        this.linkTo("la", (BComponent)this.dropDown, (Slot)BDropDown.valueModified, (Slot)setModified);
        this.linkTo("lb", (BComponent)this.dropDown, (Slot)BDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lc", (BComponent)this.dropDownList, (Slot)BList.actionPerformed, (Slot)listActionPerformed);
        this.dropDown.linkTo("ld_r2d2_c3p0", (BComponent)this.dropDownList, (Slot)BList.cancelled, (Slot)BDropDown.closeDropDown);
    }

    public BVideoCameraPickerFE(BWidget playbackChooserView, BVideoPlaybackChooser videoPlaybackChooser) {
        this();
        this.parentWidget = playbackChooserView;
        this.videoPlaybackChooser = videoPlaybackChooser;
    }

    protected void doSetReadonly(boolean readonly) {
        this.dropDown.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.loadSlotPath(value.toString());
    }

    public void defaultLoad() {
        this.dropDownDisplay.setText("Choose a Camera");
        this.dropDownDisplay.setImage(QUESTION_MARK_IMAGE);
    }

    public void loadSlotPath(String slotPath) {
        this.dropDownDisplay.setText(VideoDriverLexicon.LEX.getText("VideoPlaybackChooserView.ChooseCameraBox.ChooseCamera"));
        this.dropDownDisplay.setImage(QUESTION_MARK_IMAGE);
        this.dropDownList.removeAllItems();
        this.items = null;
        try {
            Object[] components = this.list();
            try {
                Array a = new Array(components);
                a = a.filter(new IFilter(){

                    public boolean accept(Object obj) {
                        BComponent c = (BComponent)obj;
                        BComplex parent = c.getParent();
                        return parent == null || !Flags.isHidden((BComplex)parent, (Slot)c.getPropertyInParent());
                    }
                });
                components = (BComponent[])a.trim();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.items = new Item[components.length];
            Item match = null;
            for (int i = 0; i < this.items.length; ++i) {
                components[i].loadSlots();
                Item item = this.items[i] = new Item((BComponent)components[i]);
                if (item.slotPath.equals(slotPath)) {
                    match = item;
                }
                this.dropDownList.addItem(item.icon, (Object)item);
            }
            if (match != null) {
                this.dropDownList.setSelectedItem(match);
                this.listActionPerformed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return BString.make((String)this.saveSlotPath());
    }

    public void stopped() {
        try {
            this.listPopulatorThreads.stopAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String saveSlotPath() {
        String slotPath = this.dropDownDisplay.getText();
        Item i = (Item)this.dropDownList.getSelectedItem();
        if (i != null) {
            slotPath = i.slotPath;
        }
        return slotPath;
    }

    public void doListActionPerformed() {
        this.syncLabelFromList();
        if (this.isDropDownOpen()) {
            UiEnv.get().closePopup(null);
        }
    }

    protected void syncLabelFromList() {
        Object o = this.dropDownList.getSelectedItem();
        if (o != null && o instanceof Item) {
            Item i = (Item)o;
            this.dropDownDisplay.setText(i.displayName);
            this.dropDownDisplay.setImage(i.icon);
        }
    }

    protected BComponent[] getVideoCameras() {
        BOrdList ordList = null;
        ordList = !this.videoPlaybackChooser.getPermissions(this.getCurrentContext()).hasAdminWrite() ? (BOrdList)FoxRpcUtil.doSilentRpc((BISpaceNode)this.videoPlaybackChooser, (String)"getAllCamerasUsingCacheRPC", (Object[])new Object[0]).orElseThrow(() -> new BajaRuntimeException("RPC Failed for VideoPlaybackChooser#getAllCamerasUsingCacheRPC")) : this.videoPlaybackChooser.getAllCamerasUsingCache();
        BOrd[] ords = ordList.toArray();
        BComponent[] videoCameras = new BComponent[ords.length];
        for (int i = 0; i < ords.length; ++i) {
            videoCameras[i] = (BComponent)ords[i].get((BObject)this.videoPlaybackChooser);
        }
        return videoCameras;
    }

    public BComponent[] list() {
        BComponent[] videoCameras = this.getVideoCameras();
        return videoCameras;
    }

    public boolean isDropDownOpen() {
        return UiEnv.get().isPopupOpen((BWidget)this.dropDownList);
    }

    public void doCloseDropDown() {
        UiEnv.get().closePopup(null);
        this.repaint();
    }

    public BDropDown getDropDown() {
        return this.dropDown;
    }

    public BList getDropDownList() {
        return this.dropDownList;
    }

    public BLabel getDropDownDisplay() {
        return this.dropDownDisplay;
    }

    public class Item {
        public String slotPath;
        public String displayName;
        public String description;
        public BImage icon;
        public BComponent component;

        protected Item(BComponent c) {
            this.component = c;
            this.slotPath = c.getSlotPath().toString();
            if (c instanceof BIVideoCamera) {
                this.displayName = this.description = BVideoMultistreamViewer.getDefaultCameraDragAndDropDescription(c, true);
                this.icon = BVideoMultistreamViewer.SMALL_LOADING_ICON;
                RetrieveListItemThread goldenRetriever = new RetrieveListItemThread(BOrd.make((String)("station:|" + this.slotPath)), this);
                BVideoCameraPickerFE.this.listPopulatorThreads.add(goldenRetriever);
                goldenRetriever.start();
            } else {
                this.displayName = c.getDisplayName(null);
                String descriptionAccumulator = this.slotPath.substring(6);
                descriptionAccumulator = EscUtil.slot.unescape(descriptionAccumulator);
                StringTokenizer st = new StringTokenizer(descriptionAccumulator, "/");
                descriptionAccumulator = null;
                while (st.hasMoreTokens()) {
                    if (descriptionAccumulator == null) {
                        descriptionAccumulator = st.nextToken();
                        continue;
                    }
                    descriptionAccumulator = descriptionAccumulator + " -> " + st.nextToken();
                }
                this.description = descriptionAccumulator;
                this.icon = BImage.make((BIcon)c.getIcon());
            }
        }

        public String toString() {
            return this.description;
        }
    }

    public class RetrieveListItemThread
    extends Thread {
        BOrd cameraOrd;
        Item cameraPickerListItem;
        boolean running;

        public RetrieveListItemThread(BOrd cameraOrd, Item cameraPickerListItem) {
            super("MultistreamViewer.RetrieveListItem");
            this.cameraOrd = cameraOrd;
            this.cameraPickerListItem = cameraPickerListItem;
            this.running = true;
            BVideoCameraPickerFE.this.listPopulatorThreads.add(this);
        }

        public void pleaseStop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                block7: while (true) {
                    try {
                        while (BVideoCameraPickerFE.this.isRunning() && this.running) {
                            BObject cameraObject = this.cameraOrd.get((BObject)BVideoCameraPickerFE.this.videoPlaybackChooser);
                            try {
                                String displayName = BVideoMultistreamViewer.getCameraDragAndDropDescription(cameraObject);
                                String description = "";
                                BIVideoDvr videoCameraDvr = ((BIVideoCamera)cameraObject).getDvr();
                                if (videoCameraDvr != null) {
                                    String dvrDescription = videoCameraDvr.getDvrDescription();
                                    if (dvrDescription != null) {
                                        if (dvrDescription.length() > 43) {
                                            dvrDescription = dvrDescription.substring(0, 40) + "...";
                                        }
                                        description = dvrDescription + " - " + displayName;
                                    } else {
                                        description = displayName;
                                    }
                                } else {
                                    description = displayName;
                                }
                                this.cameraPickerListItem.description = description;
                                this.cameraPickerListItem.displayName = displayName;
                                this.cameraPickerListItem.icon = BVideoMultistreamViewer.getCameraDragAndDropImage(cameraObject);
                                int itemId = BVideoCameraPickerFE.this.dropDownList.indexOfItem((Object)this.cameraPickerListItem);
                                BVideoCameraPickerFE.this.dropDownList.removeItem((Object)this.cameraPickerListItem);
                                BVideoCameraPickerFE.this.dropDownList.insertItem(itemId, this.cameraPickerListItem.icon, (Object)this.cameraPickerListItem);
                                BVideoCameraPickerFE.this.syncLabelFromList();
                                if (!BVideoCameraPickerFE.this.isRunning() || !this.running) continue block7;
                                this.running = false;
                                continue block7;
                            }
                            catch (RuntimeException rte) {
                                if (BVideoPlayback.log.isLoggable(Level.FINE)) {
                                    BVideoPlayback.log.log(Level.FINE, "Exception setting text of a list item.\n>> Ord = " + this.cameraOrd + "\n>> Exception = " + rte, rte);
                                }
                                Thread.sleep(1000L);
                            }
                        }
                        break block17;
                    }
                    catch (InterruptedException ie) {
                        if (BVideoPlayback.log.isLoggable(Level.FINE)) {
                            BVideoPlayback.log.log(Level.FINE, "List populator thread interrupted and stopped. Ord = " + this.cameraOrd, ie);
                        }
                        break block17;
                    }
                }
                finally {
                    if (BVideoPlayback.log.isLoggable(Level.FINE)) {
                        BVideoPlayback.log.fine("List populator thread stopped. Ord = " + this.cameraOrd);
                    }
                }
            }
        }
    }

    public class ListPopulatorThreadGroup {
        LinkedList<RetrieveListItemThread> threads = new LinkedList();

        public synchronized void add(RetrieveListItemThread r) {
            this.threads.add(r);
        }

        public synchronized void stopAll() throws InterruptedException {
            LinkedList<RetrieveListItemThread> itemsToRemove = new LinkedList<RetrieveListItemThread>();
            RetrieveListItemThread r2 = null;
            for (RetrieveListItemThread r2 : this.threads) {
                if (r2 == null || !r2.isAlive()) continue;
                r2.pleaseStop();
                r2.join(100L);
                if (r2.isAlive()) continue;
                itemsToRemove.add(r2);
            }
            this.threads.removeAll(itemsToRemove);
        }
    }
}

