/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm.monitoring;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.alarm.monitoring.BMonitor;
import com.tridium.videoDriver.alarm.monitoring.BMonitorNotification;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BNotification;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.util.BNotificationHandler;

public abstract class BMonitorNotificationHandler
extends BNotificationHandler {
    public static final Type TYPE = Sys.loadType(BMonitorNotificationHandler.class);
    protected BWbShell shell;
    protected BMonitorNotification notification;
    protected BMonitor monitor;
    protected BFoxSession foxSession;
    protected Context cx;

    public Type getType() {
        return TYPE;
    }

    public void handle(BWbShell shell, BNotification notify, Context cx) {
        if (shell == null || notify == null || !notify.getType().is(BMonitorNotification.TYPE) || cx == null) {
            return;
        }
        this.shell = shell;
        this.notification = (BMonitorNotification)notify;
        this.cx = cx;
        this.foxSession = this.getFoxSession();
        if (this.foxSession == null) {
            return;
        }
        this.monitor = (BMonitor)this.notification.getMonitorOrd().get(BOrd.make((String)("station:" + this.foxSession.getPort() + "|slot:/")).get((BObject)this.foxSession));
        this.processNotification();
    }

    protected BFoxSession getFoxSession() {
        BFacets facets = this.cx.getFacets();
        Object pickle = facets.getPickle();
        BFoxSession session = null;
        if (pickle instanceof BComponent) {
            BComponent pickComponent = (BComponent)pickle;
            session = (BFoxSession)pickComponent.getSession();
        }
        return session;
    }

    protected BUser getUser() {
        BFoxSession foxSession = this.getFoxSession();
        BUserService userService = (BUserService)foxSession.getService(BUserService.TYPE);
        userService.lease(10);
        BUser user = userService.getUser(foxSession.getUsername());
        return user;
    }

    protected BMonitor getMonitor(Type monitorType, BUser user) {
        return (BMonitor)user.getMixIn(monitorType);
    }

    protected abstract void processNotification();
}

