/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.ui.Binder;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.alarm.BVideoAlarmConsoleLayoutEnum;
import com.tridium.videoDriver.alarm.BVideoAlarmConsoleOptions;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleController;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.workbench.view.BWbView;

public class LayoutController {
    private static Logger log = Logger.getLogger("videoDriver.LayoutController");
    private static final double DIVIDER_POSITION = 35.0;
    protected AlarmConsoleController alarmConsoleController;
    protected BVideoAlarmConsole console;
    protected BWidget alarmTablePane;
    protected BWidget instructionsPane;
    protected BWidget liveVideoPane;
    protected BWidget videoPlaybackPane;
    protected BWbView liveVideo;
    protected BWbView videoPlayback;
    protected Worker backgroundWorker;
    protected Queue backgroundQueue;

    private LayoutController(AlarmConsoleController controller) {
        this.alarmConsoleController = controller;
        this.console = controller.console;
        if (this.backgroundQueue == null) {
            this.backgroundQueue = new Queue();
            this.backgroundWorker = new Worker((Worker.ITodo)this.backgroundQueue);
            this.backgroundWorker.start("LayoutController.worker");
        }
    }

    public static LayoutController make(AlarmConsoleController controller) {
        return new LayoutController(controller);
    }

    static BWidget makeSplitPane(BWidget w1, BWidget w2, BOrientation orientation) {
        BSplitPane splitPane = new BSplitPane(w1, w2);
        splitPane.setOrientation(orientation);
        return splitPane;
    }

    static BWidget makeTwoWidgetPaneVertical(BWidget upper, BWidget lower, double dividerPosition) {
        BSplitPane splitPane = (BSplitPane)LayoutController.makeTwoWidgetPaneVertical(upper, lower);
        splitPane.setDividerPosition(dividerPosition);
        return splitPane;
    }

    static BWidget makeTwoWidgetPaneVertical(BWidget upper, BWidget lower) {
        return LayoutController.makeSplitPane(upper, lower, BOrientation.vertical);
    }

    static BWidget makeTwoWidgetPaneHorizontal(BWidget left, BWidget right) {
        return LayoutController.makeSplitPane(left, right, BOrientation.horizontal);
    }

    static BWidget makeThreeWidgetPane(BWidget upper, BWidget lowerLeft, BWidget lowerRight, double mainDividerPosition) {
        BSplitPane splitPane = (BSplitPane)LayoutController.makeThreeWidgetPane(upper, lowerLeft, lowerRight);
        splitPane.setDividerPosition(mainDividerPosition);
        return splitPane;
    }

    static BWidget makeThreeWidgetPane(BWidget upper, BWidget lowerLeft, BWidget lowerRight) {
        BWidget innerSplitPane = LayoutController.makeTwoWidgetPaneHorizontal(lowerLeft, lowerRight);
        BWidget outerSplitPane = LayoutController.makeTwoWidgetPaneVertical(upper, innerSplitPane);
        return outerSplitPane;
    }

    static BWidget makeFourWidgetPane(BWidget topLeft, BWidget topRight, BWidget bottomLeft, BWidget bottomRight) {
        BWidget upperCompositeWidget = LayoutController.makeTwoWidgetPaneHorizontal(topLeft, topRight);
        BWidget lowerCompositeWidget = LayoutController.makeTwoWidgetPaneHorizontal(bottomLeft, bottomRight);
        BWidget mainWidget = LayoutController.makeTwoWidgetPaneVertical(upperCompositeWidget, lowerCompositeWidget);
        return mainWidget;
    }

    private void setVideoPanesVisibility(boolean showLive, boolean showPlayback) {
        this.liveVideoPane.setVisible(showLive);
        this.videoPlaybackPane.setVisible(showPlayback);
    }

    public void layout() {
        BAlarmRecord alarm;
        BVideoAlarmConsoleOptions vacOptions = this.alarmConsoleController.getVideoAlarmConsoleOptions();
        if (vacOptions == null) {
            log.warning("No video alarm console options found. Defaulting to normal layout");
            return;
        }
        this.cacheAndUnparentWidgets();
        BVideoAlarmConsoleLayoutEnum layout = vacOptions.getLayout();
        this.console.setContent((BWidget)new BNullWidget());
        if (!vacOptions.getEnabled()) {
            if (this.console.options.getViewInstructions()) {
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.instructionsPane));
            } else {
                this.console.setContent(this.alarmTablePane);
            }
            return;
        }
        switch (layout.getOrdinal()) {
            case 0: {
                this.setVideoPanesVisibility(false, false);
                this.console.setContent(this.alarmTablePane);
                break;
            }
            case 6: {
                this.setVideoPanesVisibility(true, false);
                this.console.setContent(this.liveVideoPane);
                break;
            }
            case 7: {
                this.setVideoPanesVisibility(false, true);
                this.console.setContent(this.videoPlaybackPane);
                break;
            }
            case 1: {
                this.setVideoPanesVisibility(false, false);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.instructionsPane));
                break;
            }
            case 2: {
                this.setVideoPanesVisibility(true, false);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.liveVideoPane, 35.0));
                break;
            }
            case 3: {
                this.setVideoPanesVisibility(false, true);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.videoPlaybackPane, 35.0));
                break;
            }
            case 4: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeThreeWidgetPane(this.alarmTablePane, this.liveVideoPane, this.videoPlaybackPane, 35.0));
                break;
            }
            case 5: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeFourWidgetPane(this.alarmTablePane, this.instructionsPane, this.liveVideoPane, this.videoPlaybackPane));
                break;
            }
            case 8: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeTwoWidgetPaneHorizontal(this.liveVideoPane, this.videoPlaybackPane));
                break;
            }
            case 9: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.liveVideoPane, this.videoPlaybackPane));
                break;
            }
            default: {
                this.setVideoPanesVisibility(false, false);
                this.console.setContent(this.alarmTablePane);
            }
        }
        BComponent monitor = this.alarmConsoleController.getAlarmMonitor();
        if (monitor == null) {
            return;
        }
        BValue lastValueSignaled = monitor.get("lastValueSignaled");
        if (lastValueSignaled instanceof BAlarmRecord && (alarm = (BAlarmRecord)lastValueSignaled) != null) {
            this.alarmConsoleController.processAlarm(alarm, true);
        }
    }

    private void cacheAndUnparentWidgets() {
        if (this.alarmTablePane == null) {
            this.alarmTablePane = this.getAlarmTablePane();
        }
        this.unparent(this.alarmTablePane);
        if (this.instructionsPane == null) {
            this.instructionsPane = this.getInstructionsPane();
        }
        this.unparent(this.instructionsPane);
        if (this.liveVideoPane == null) {
            this.liveVideoPane = this.makeLiveVideoPane();
        } else {
            this.unparent(this.liveVideoPane);
        }
        if (this.videoPlaybackPane == null) {
            this.videoPlaybackPane = this.makeVideoPlaybackPane();
        } else {
            this.unparent(this.videoPlaybackPane);
        }
    }

    private void unparent(BWidget widget) {
        BWidget parentWidget = widget.getParentWidget();
        if (parentWidget != null) {
            if (parentWidget instanceof BWbView) {
                BWbView view = (BWbView)parentWidget;
                view.setContent((BWidget)new BNullWidget());
            } else if (parentWidget instanceof BSplitPane) {
                BSplitPane splitPane = (BSplitPane)parentWidget;
                splitPane.setWidget1((BWidget)new BNullWidget());
                splitPane.setWidget2((BWidget)new BNullWidget());
            }
        }
    }

    protected BWidget getAlarmTablePane() {
        if (this.console.options.getViewInstructions()) {
            BSplitPane splitPane = (BSplitPane)this.console.getContent();
            BWidget alarmTablePane = splitPane.getWidget1();
            return alarmTablePane;
        }
        return this.console.getContent();
    }

    protected BWidget getInstructionsPane() {
        return this.console.getInstructionsPane();
    }

    protected BWidget makeLiveVideoPane() {
        this.liveVideo = new BLiveVideo();
        return new BTitlePane("Live Video", (BWidget)this.liveVideo);
    }

    protected BWidget makeVideoPlaybackPane() {
        this.videoPlayback = new BVideoPlayback();
        return new BTitlePane("Video Playback", (BWidget)this.videoPlayback);
    }

    protected void loadVideoAlarm(final BAlarmRecord alarm) {
        BOrd cameraOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)this.console.getConsoleRecipient(), alarm);
        if (cameraOrd == null || cameraOrd.isNull()) {
            return;
        }
        final BComponent camera = cameraOrd.get((BObject)this.console.getConsoleRecipient()).asComponent();
        if (camera == null) {
            return;
        }
        camera.lease();
        Runnable loadLiveVideo = new Runnable(){

            @Override
            public void run() {
                LayoutController.this.loadVideoPane(LayoutController.this.liveVideoPane, alarm, camera, true);
            }
        };
        Runnable loadPlaybackVideo = new Runnable(){

            @Override
            public void run() {
                LayoutController.this.loadVideoPane(LayoutController.this.videoPlaybackPane, alarm, camera, false);
            }
        };
        if (this.liveVideoPane.isVisible()) {
            this.backgroundQueue.enqueue((Object)loadLiveVideo);
        }
        if (this.videoPlaybackPane.isVisible()) {
            this.backgroundQueue.enqueue((Object)loadPlaybackVideo);
        }
    }

    protected void deactivate() {
        if (this.liveVideo != null) {
            LayoutController.deactivateView(this.liveVideo);
        }
        if (this.videoPlayback != null) {
            LayoutController.deactivateView(this.videoPlayback);
        }
        if (this.backgroundWorker != null) {
            this.backgroundWorker.stop();
        }
        this.backgroundQueue.clear();
    }

    private void loadVideoPane(BWidget videoPane, BAlarmRecord alarm, BComponent camera, boolean isLive) {
        BTitlePane videoTitlePane = (BTitlePane)videoPane;
        BEdgePane contentPane = (BEdgePane)videoTitlePane.getCenter();
        BLiveVideo view = null;
        if (isLive) {
            if (this.liveVideo != null) {
                LayoutController.deactivateView(this.liveVideo);
            }
            this.liveVideo = new BLiveVideo();
            view = this.liveVideo;
            contentPane.setCenter((BWidget)this.liveVideo);
        } else {
            BAbsTime alarmTime = (BAbsTime)alarm.getAlarmData().get("videoEventTimestamp");
            String alarmSummary = LayoutController.toSummaryString(alarm, alarmTime);
            if (alarmTime == null || alarmTime.isNull()) {
                alarmTime = alarm.getTimestamp();
                alarmSummary = VideoDriverLexicon.LEX.getText("AlarmRecallTimeApproximate", new Object[]{alarmSummary});
            }
            if (this.videoPlayback != null) {
                LayoutController.deactivateView(this.videoPlayback);
            }
            this.videoPlayback = new BVideoPlayback(alarmSummary, alarmTime, false);
            view = this.videoPlayback;
            contentPane.setCenter((BWidget)view);
        }
        LayoutController.hookViewToCamera(view, camera);
    }

    private static void deactivateView(BWbView view) {
        view.fw(402);
        view.deactivated();
    }

    private static String toSummaryString(BAlarmRecord alarm, BAbsTime alarmTime) {
        StringBuffer s = new StringBuffer(alarm.getAlarmData().gets("msgText", ""));
        if (s.toString().trim().length() > 0) {
            s.append(" <-> ");
        }
        if (alarmTime == null || BAbsTime.NULL.equals((Object)alarmTime)) {
            s.append(alarm.getTimestamp().toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        } else {
            s.append(alarmTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        }
        s.append(": (").append(alarm.getAckState()).append(':').append(alarm.getSourceState()).append(") ");
        return s.toString();
    }

    private static void hookViewToCamera(BWbView view, BComponent camera) {
        if (view == null) {
            return;
        }
        camera.lease();
        view.fw(403);
        Context context = null;
        try {
            BISession session = BOrd.toSession((BObject)camera);
            if (session != null) {
                context = session.getSessionContext();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        view.prime();
        view.relayout();
        view.start();
        view.loadValue((BObject)camera, context);
        if (view.getLoadError() != null) {
            throw new BajaRuntimeException(view.getLoadError());
        }
        Binder binder = (Binder)view.fw(302);
        binder.start(camera.getNavOrd().resolve(), context);
    }
}

