/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.workbench.ord.BComponentChooser;
import com.tridium.workbench.ord.RefFilter;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BVideoCameraChooserFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BVideoCameraChooserFE.class);
    public static final RefFilter SHOW_ALARM_RECORDERS_ONLY = new RefFilter(){

        public boolean accept(BObject parent, Slot slot) {
            return slot != null && parent != null && slot.isProperty() && parent.asComplex().get(slot.asProperty()) instanceof BIVideoSource;
        }
    };
    protected BWbShell shell = null;
    protected BTextField field = new BTextField(LEX.getText("ChooseCamera"), 60);
    protected BButton browse;
    public static final Lexicon LEX = UiLexicon.make(BVideoCameraChooserFE.class);

    public Type getType() {
        return TYPE;
    }

    public BVideoCameraChooserFE() {
        this.field.setEditable(true);
        this.linkTo((BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.browse = new BButton((Command)new InternalBrowseCommand());
        this.browse.setButtonStyle(BButtonStyle.toolBar);
        BGridPane gp = new BGridPane(2);
        gp.add("textField", (BValue)this.field);
        gp.add("browseButton", (BValue)this.browse);
        this.setContent((BWidget)gp);
    }

    public void started() {
        this.shell = this.getWbShell();
    }

    protected void doLoadValue(BObject value, Context context) {
        BOrd cameraOrd = (BOrd)value;
        this.field.setText(cameraOrd.toString());
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        return BOrd.make((String)this.field.getText());
    }

    protected void doSetReadonly(boolean readonly) {
        this.field.setEnabled(!readonly);
        this.browse.setEnabled(!readonly);
    }

    public boolean isRelativize(BOrd currentOrd) {
        return BVideoCameraChooserFE.isRelativize(currentOrd, this.getCurrentContext(), this.shell);
    }

    public static boolean isRelativize(BOrd currentOrd, Context cx, BWbShell shell) {
        BBoolean val;
        BFacets facets;
        if (cx != null && (facets = cx.getFacets()) != null && (val = (BBoolean)facets.get("ordRelativize")) instanceof BBoolean) {
            return val.getBoolean();
        }
        if (shell != null) {
            BOrd activeOrd = shell.getActiveOrd();
            OrdQuery[] active = activeOrd.parse();
            OrdQuery[] current = currentOrd.parse();
            if (active.length > 1 && current.length > 1) {
                if (!active[0].toString().equals(current[0].toString())) {
                    return false;
                }
                if (!active[1].toString().equals(current[1].toString())) {
                    return false;
                }
            }
        }
        return true;
    }

    class InternalBrowseCommand
    extends Command {
        public InternalBrowseCommand() {
            super((BWidget)BVideoCameraChooserFE.this, LEX, "BrowseCamera");
        }

        public CommandArtifact doInvoke() {
            BComponent base = null;
            BWbShell shell = BVideoCameraChooserFE.this.getWbShell();
            if (shell != null) {
                BComponent tempNavTreeWalker;
                for (tempNavTreeWalker = base = (BComponent)shell.getActiveOrdTarget().get(); tempNavTreeWalker != null && !(tempNavTreeWalker instanceof BStation); tempNavTreeWalker = tempNavTreeWalker.getParent()) {
                }
                if (tempNavTreeWalker == null) {
                    throw new IllegalStateException("Value not in a station!");
                }
                BStation station = (BStation)tempNavTreeWalker;
                Object[] driverContainers = station.getChildren(BDriverContainer.class);
                if (driverContainers.length <= 0) {
                    throw new IllegalStateException("Station contains no 'drivers' container.");
                }
                BDriverContainer driverContainer = (BDriverContainer)driverContainers[0];
                BOrd tempOrd = BOrd.make((String)BVideoCameraChooserFE.this.field.getText());
                SlotPath defaultSlotPath = null;
                try {
                    defaultSlotPath = ((BComponent)tempOrd.get((BObject)base)).getSlotPath();
                }
                catch (Exception e) {
                    defaultSlotPath = null;
                }
                BOrd ord = BComponentChooser.prompt((BWidget)BVideoCameraChooserFE.this, (String)LEX.getText("BrowseCamera"), (BComponent)driverContainer, (SlotPath)defaultSlotPath, (RefFilter)RefFilter.components, (RefFilter)SHOW_ALARM_RECORDERS_ONLY);
                if (ord != null) {
                    if (BVideoCameraChooserFE.this.isRelativize(ord)) {
                        ord = ord.relativizeToSession();
                    }
                    BVideoCameraChooserFE.this.field.setText(ord.toString());
                }
            }
            return null;
        }
    }
}

