/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.BStationRecipient;
import com.tridium.videoDriver.alarm.BIVideoAlarmRecorder;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayLayout;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

public class BVideoAlarmRecipient
extends BConsoleRecipient {
    public static final Property presetOnNormal = BVideoAlarmRecipient.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BVideoAlarmRecipient.class);
    protected static Worker backgroundWorker;
    protected static Queue backgroundQueue;
    protected BAlarmService alarmService;
    public static final Logger log;

    public boolean getPresetOnNormal() {
        return this.getBoolean(presetOnNormal);
    }

    public void setPresetOnNormal(boolean v) {
        this.setBoolean(presetOnNormal, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected static BStationRecipient[] filterStationRecipientsForAlarmClass(String alarmClass, BStationRecipient[] allStationRecipients) {
        Array filteredStationRecipientsForAlarmClass = new Array(BStationRecipient.class);
        block0: for (int i = 0; i < allStationRecipients.length; ++i) {
            String[] alarmClassesForStationRecipient = BVideoAlarmRecipient.getAlarmClassesForRecipient((BAlarmRecipient)allStationRecipients[i]);
            for (int j = 0; j < alarmClassesForStationRecipient.length; ++j) {
                if (!alarmClassesForStationRecipient[j].equals(alarmClass)) continue;
                filteredStationRecipientsForAlarmClass.add((Object)allStationRecipients[i]);
                continue block0;
            }
        }
        return (BStationRecipient[])filteredStationRecipientsForAlarmClass.trim();
    }

    protected BStationRecipient[] getStationRecipients() {
        BITable result = (BITable)BOrd.make((String)"slot:/|bql:select from alarm:StationRecipient").get((BObject)this);
        Array stationRecipientsDynamicArray = new Array(BStationRecipient.class);
        TableCursor c = result.cursor();
        while (c.next()) {
            stationRecipientsDynamicArray.add(c.get());
        }
        return (BStationRecipient[])stationRecipientsDynamicArray.trim();
    }

    protected static String[] getAlarmClassesForRecipient(BAlarmRecipient alarmRecipient) {
        Array alarmClassesDynamicSringArray = new Array(String.class);
        Object[] nonEscalatedAlarmClasses = alarmRecipient.getSubscribedAlarmClasses();
        alarmClassesDynamicSringArray.addAll(nonEscalatedAlarmClasses);
        int maxEscalationLevel = 3;
        for (int i = 1; i <= 3; ++i) {
            Object[] escalatedAlarmClasses = alarmRecipient.getSubscribedEscalatedAlarmClasses(i);
            alarmClassesDynamicSringArray.addAll(escalatedAlarmClasses);
        }
        return (String[])alarmClassesDynamicSringArray.trim();
    }

    public void started() throws Exception {
        super.started();
        if (backgroundQueue == null) {
            backgroundQueue = new Queue();
            backgroundWorker = new Worker((Worker.ITodo)backgroundQueue);
            backgroundWorker.start("VideoAlarmRecipient.worker");
        }
    }

    public void handleAlarm(BAlarmRecord alarmRecord) {
        super.handleAlarm(alarmRecord);
        BObject cameraObject = this.getCameraObject(alarmRecord);
        if (cameraObject != null) {
            this.addFieldDeviceCameraTime(alarmRecord, cameraObject);
            if (this.getStartRecording(alarmRecord)) {
                this.startRecording(alarmRecord, cameraObject);
            }
            if (BVideoAlarmRecipient.isVideoAlarm(alarmRecord) && this.getSendAlarmToDisplay(alarmRecord)) {
                this.sendAlarmToDisplay(alarmRecord, cameraObject);
            }
        }
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    protected void addFieldDeviceCameraTime(BAlarmRecord alarmRecord, BObject cameraObject) {
        BFacets alarmRecordFacets = alarmRecord.getAlarmData();
        BAbsTime videoEventTimestamp = (BAbsTime)alarmRecordFacets.get("videoEventTimestamp");
        if ((videoEventTimestamp == null || videoEventTimestamp.isNull()) && cameraObject instanceof BIVideoCamera) {
            backgroundQueue.enqueue((Object)new AddFieldDeviceCameraTimeRunnable(alarmRecord, cameraObject));
        }
    }

    protected static boolean isVideoAlarm(BAlarmRecord alarm) {
        String cameraOrd = alarm.getAlarmData().gets("cameraOrd", null);
        String cameraHandleOrd = alarm.getAlarmData().gets("cameraHandleOrd", null);
        return cameraOrd != null || cameraHandleOrd != null;
    }

    protected void startRecording(final BAlarmRecord alarmRecord, final BObject cameraObject) {
        Runnable todo = new Runnable(){

            @Override
            public void run() {
                boolean isNormal;
                BValue cameraPreset = BVideoAlarmRecipient.this.getCameraPreset(alarmRecord);
                if (cameraPreset != null && cameraObject instanceof BIVideoMoveToPresetControl && (!(isNormal = alarmRecord.isNormal()) || BVideoAlarmRecipient.this.getPresetOnNormal())) {
                    ((BIVideoMoveToPresetControl)cameraObject).moveToPreset(cameraPreset);
                }
                if (cameraObject instanceof BIVideoAlarmRecorder) {
                    ((BIVideoAlarmRecorder)cameraObject).startRecordingAlarm(alarmRecord);
                }
            }
        };
        backgroundQueue.enqueue((Object)todo);
    }

    protected void sendAlarmToDisplay(final BAlarmRecord alarm, final BObject camera) {
        Runnable todo = new Runnable(){

            @Override
            public void run() {
                if (camera != null && camera instanceof BIVideoCamera) {
                    BIVideoCamera videoCamera = (BIVideoCamera)camera;
                    BIVideoDvr dvr = videoCamera.getDvr();
                    if (dvr == null) {
                        return;
                    }
                    BIVideoDisplay[] displays = videoCamera.getDvr().getDisplayExt().getAllDisplays();
                    if (displays.length > 0) {
                        BIVideoDisplay display = displays[0];
                        if (display == null) {
                            return;
                        }
                        BFrozenEnum layout = display.getVideoDisplayMultistream().getLayout();
                        if (layout instanceof BIVideoDisplayLayout) {
                            BIVideoDisplayLayout singleCameraLayout = ((BIVideoDisplayLayout)layout).getSingleSegmentLayout();
                            display.switchToLayout(singleCameraLayout);
                            BOrd videoCameraOrd = camera.asComponent().getHandleOrd();
                            display.mapCamerasToLayout(new BOrd[]{videoCameraOrd}, singleCameraLayout);
                            BAbsTime time = alarm.getTimestamp();
                            display.gotoPlaybackTime(time);
                        }
                    }
                }
            }
        };
        backgroundQueue.enqueue((Object)todo);
    }

    protected BValue getCameraPreset(BAlarmRecord alarmRecord) {
        return (BValue)alarmRecord.getAlarmData().get("cameraPreset");
    }

    protected boolean getStartRecording(BAlarmRecord alarmRecord) {
        return alarmRecord.getAlarmData().getb("startRecording", true);
    }

    protected boolean getSendAlarmToDisplay(BAlarmRecord alarmRecord) {
        return alarmRecord.getAlarmData().getb("sendAlarmToDisplay", false);
    }

    protected BObject getCameraObject(BAlarmRecord alarmRecord) {
        BObject cameraObject;
        String cameraOrdString = alarmRecord.getAlarmData().gets("cameraOrd", null);
        if (cameraOrdString != null) {
            BOrd cameraOrd;
            try {
                cameraOrd = BOrd.make((String)cameraOrdString);
            }
            catch (Exception e) {
                cameraOrd = null;
            }
            if (cameraOrd == null || cameraOrd.equals((Object)BOrd.NULL)) {
                cameraObject = null;
            } else {
                try {
                    cameraObject = cameraOrd.get((BObject)this);
                }
                catch (Exception e) {
                    cameraObject = null;
                }
            }
        } else {
            cameraObject = null;
        }
        return cameraObject;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        int alarmConsoleIndex = list.indexOf("alarm:AlarmConsole");
        if (alarmConsoleIndex != -1) {
            list.remove(alarmConsoleIndex);
        }
        return list;
    }

    static {
        log = Logger.getLogger("alarm.videoAlarmRecipient");
    }

    public class AddFieldDeviceCameraTimeRunnable
    implements Runnable {
        protected long startTicks;
        protected BAlarmRecord alarmRecord;
        protected BObject cameraObject;

        public AddFieldDeviceCameraTimeRunnable(BAlarmRecord alarmRecord, BObject cameraObject) {
            this.alarmRecord = alarmRecord;
            this.cameraObject = cameraObject;
            this.startTicks = Clock.ticks();
        }

        @Override
        public void run() {
            BIVideoCamera videoCamera = (BIVideoCamera)this.cameraObject;
            BAbsTime fieldDeviceCameraTime = videoCamera.getCameraTime();
            if (fieldDeviceCameraTime != null && !fieldDeviceCameraTime.isNull()) {
                BFacets metaData = this.alarmRecord.getAlarmData();
                long deltaMillis = Clock.ticks() - this.startTicks;
                if (deltaMillis < 0L) {
                    deltaMillis = 0L;
                }
                fieldDeviceCameraTime = fieldDeviceCameraTime.subtract(BRelTime.make((long)deltaMillis));
                BFacets cameraTime = BFacets.make((String)"videoEventTimestamp", (BIDataValue)fieldDeviceCameraTime);
                this.alarmRecord.setAlarmData(BFacets.make((BFacets)metaData, (BFacets)cameraTime));
                BAlarmService as = BVideoAlarmRecipient.this.getAlarmService();
                try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                    conn.update(this.alarmRecord);
                    this.reRouteToStationRecipients();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Cannot add field-device camera time to alarm.", e);
                }
            }
        }

        protected void reRouteToStationRecipients() {
            BStationRecipient[] stationRecipients = BVideoAlarmRecipient.this.getStationRecipients();
            String[] alarmClassesForThisVideoRecipient = BVideoAlarmRecipient.getAlarmClassesForRecipient((BAlarmRecipient)BVideoAlarmRecipient.this);
            for (int i = 0; i < alarmClassesForThisVideoRecipient.length; ++i) {
                String alarmClass = alarmClassesForThisVideoRecipient[i];
                BStationRecipient[] stationRecipientsForAlarmClass = BVideoAlarmRecipient.filterStationRecipientsForAlarmClass(alarmClass, stationRecipients);
                for (int j = 0; j < stationRecipientsForAlarmClass.length; ++j) {
                    try {
                        stationRecipientsForAlarmClass[j].routeAlarm(this.alarmRecord);
                        continue;
                    }
                    catch (RuntimeException rte) {
                        log.log(Level.SEVERE, "Unable to re-route updated alarm record to station recipient. Alarm record = [" + this.alarmRecord + "] station recipient = [" + stationRecipientsForAlarmClass[j].getSlotPath() + "]", rte);
                    }
                }
            }
        }
    }
}

