/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.portal.BAlarmPortalOptions;
import com.tridium.alarm.ui.portal.BAlarmPortalTool;
import com.tridium.alarm.ui.portal.BConsoleRecord;
import com.tridium.alarm.ui.portal.BConsoleRecordList;
import com.tridium.fox.session.ServerException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.nd.BNiagaraStation;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.UnresolvedOrOfflineStationException;
import com.tridium.videoDriver.ui.alarm.BAlarmConsoleVideoPlayerDialog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.BTypeSpec;

public class AlarmConsoleExt {
    public static Logger log = Logger.getLogger("videoDriver:AlarmConsoleExt");
    public static int START_OF_REMOTE_VIDEO_LOCALIZATION_CODE = 37;
    public static String SERVER_MESSAGE_REMOTE_VIDEO_LOCALIZATION_CODE = "javax.baja.sys.BajaRuntimeException: RemoteVideo.";

    protected static BAlarmRecord refreshAlarmRecord(BAlarmConsole alarmConsole, BAlarmRecord selectedRecord) {
        BObject bqlQueryResult;
        String uuid = selectedRecord.getUuid().toString();
        BOrd bqlQueryForTheUpdatedAlarmRecord = BOrd.make((String)("service:baja:AlarmService|alarm:|bql:select * where uuid = '" + uuid + "'"));
        if (log.isLoggable(Level.FINE)) {
            log.fine("Looking up alarm record using bql query: " + bqlQueryForTheUpdatedAlarmRecord);
        }
        try {
            bqlQueryResult = bqlQueryForTheUpdatedAlarmRecord.get(alarmConsole.getCurrentValue());
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception occurred while trying to look up alarm record from the station-side database", e);
            }
            bqlQueryResult = null;
        }
        if (bqlQueryResult == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Unable to refresh alarm record from the station-side database");
            }
        } else if (bqlQueryResult instanceof BITable) {
            TableCursor bqlCursor = ((BITable)bqlQueryResult).cursor();
            if (bqlCursor.next()) {
                selectedRecord = (BAlarmRecord)bqlCursor.get();
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("The bql query result does not contain an alarm record.");
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("The bql query did not return a BICollection as expected. Instead, it returned a " + bqlQueryResult.getClass());
        }
        return selectedRecord;
    }

    protected static BOrd resolveVideoCameraObject(BAlarmConsole alarmConsole, BAlarmRecord selectedRecord, String ordFacetKey) {
        return AlarmConsoleExt.resolveVideoCameraObject(alarmConsole.getCurrentValue(), selectedRecord, ordFacetKey);
    }

    public static BOrd resolveVideoCameraObject(BObject obj, BAlarmRecord selectedRecord, String ordFacetKey) {
        BOrdList alarmSource = selectedRecord.getSource();
        String alarmSourceExtCamera = selectedRecord.getAlarmData().gets(ordFacetKey, null);
        BOrd videoCameraOrd = null;
        if (alarmSourceExtCamera != null) {
            if (obj instanceof BAlarmPortalTool) {
                return AlarmConsoleExt.resolveVideoCameraObjectForAlarmPortal((BAlarmPortalTool)obj, selectedRecord, alarmSourceExtCamera);
            }
            if (alarmSourceExtCamera.indexOf("remoteVideo:") >= 0) {
                videoCameraOrd = BOrd.make((String)alarmSourceExtCamera);
            } else {
                if (alarmSource.size() > 2) {
                    throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.SupervisorVideo.MultipleTiers.NotSupported"));
                }
                if (alarmSource.size() == 2) {
                    BComponent bNiagaraStationAlarms;
                    if (alarmSourceExtCamera.startsWith("h:")) {
                        throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.SupervisorVideo.HandleOrd.NotSupported"));
                    }
                    BOrd bNiagaraStationOrd = alarmSource.get(1);
                    try {
                        bNiagaraStationAlarms = (BComponent)bNiagaraStationOrd.get(obj);
                    }
                    catch (UnresolvedException ue) {
                        throw new BajaRuntimeException(VideoDriverLexicon.getLexString((String)"AlarmConsoleExt.SupervisorVideo.NiagaraStation.NotFound", (Object)bNiagaraStationOrd), (Throwable)ue);
                    }
                    BNiagaraStation bNiagaraStation = (BNiagaraStation)bNiagaraStationAlarms.getParent();
                    String remoteOrd = alarmSourceExtCamera;
                    if (remoteOrd.startsWith("station:|")) {
                        remoteOrd = remoteOrd.substring(9);
                    }
                    if (remoteOrd.startsWith("slot:/")) {
                        remoteOrd = remoteOrd.substring(6);
                    }
                    if (bNiagaraStation != null) {
                        bNiagaraStation.lease();
                        if (bNiagaraStation.getSession() instanceof BFoxSession) {
                            BFoxSession foxSession = (BFoxSession)bNiagaraStation.getSession();
                            String currentStationName = foxSession.getStationName();
                            if (alarmSourceExtCamera.indexOf("/" + currentStationName + "/remoteVideo_NiagaraCameraExt/") > -1) {
                                BComponent c = foxSession.getService(BTypeSpec.make((String)"remoteVideo:RemoteVideoService").getResolvedType());
                                BComponent params = new BComponent();
                                params.add("stationName", (BValue)BString.make((String)bNiagaraStation.getName()));
                                params.add("cameraOrd", (BValue)BOrd.make((String)alarmSourceExtCamera));
                                Object returnValue = FoxRpcUtil.doSilentRpc((BISpaceNode)c, (String)"getLocalCameraOrdFromAlarmRPC", (Object[])new Object[]{params}).orElseThrow(() -> new BajaRuntimeException("RPC call to RemoteVideoService#getLocalCameraOrdFromAlarmRPC failed"));
                                videoCameraOrd = (BOrd)returnValue;
                                videoCameraOrd.get((BObject)bNiagaraStation);
                                return videoCameraOrd;
                            }
                        }
                    }
                    videoCameraOrd = BOrd.make((String)("remoteVideo:" + bNiagaraStation.getName() + "//" + remoteOrd));
                } else {
                    videoCameraOrd = BOrd.make((String)alarmSourceExtCamera);
                }
            }
            if (videoCameraOrd != null && !videoCameraOrd.equals((Object)BOrd.NULL)) {
                try {
                    videoCameraOrd.get(obj);
                    return videoCameraOrd;
                }
                catch (Exception e) {
                    String serverMessage;
                    Throwable cause = e;
                    while (cause != null && !(cause instanceof ServerException)) {
                        try {
                            Method getCauseMethod = cause.getClass().getMethod("getCause", new Class[0]);
                            if (getCauseMethod == null) {
                                cause = null;
                                continue;
                            }
                            try {
                                Object nextCause = getCauseMethod.invoke((Object)cause, new Object[0]);
                                if (nextCause == null) {
                                    cause = null;
                                    continue;
                                }
                                if (nextCause instanceof Throwable) {
                                    cause = (Throwable)nextCause;
                                    continue;
                                }
                                cause = null;
                            }
                            catch (IllegalArgumentException e1) {
                                cause = null;
                            }
                            catch (IllegalAccessException e1) {
                                cause = null;
                            }
                            catch (InvocationTargetException e1) {
                                cause = null;
                            }
                        }
                        catch (NoSuchMethodException nsme) {
                            cause = null;
                        }
                    }
                    if (cause == null) {
                        cause = e;
                    }
                    if (cause != null && cause instanceof ServerException && (serverMessage = cause.getMessage()).startsWith(SERVER_MESSAGE_REMOTE_VIDEO_LOCALIZATION_CODE)) {
                        String remoteVideoLocalizationCode = serverMessage.substring(START_OF_REMOTE_VIDEO_LOCALIZATION_CODE);
                        throw new BajaRuntimeException(AlarmConsoleExt.getLocalizedMessage(remoteVideoLocalizationCode));
                    }
                    throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.ErrorResolvingCameraOrd", new Object[]{videoCameraOrd}), (Throwable)e);
                }
            }
            return null;
        }
        return null;
    }

    public static BOrd resolveVideoCameraObjectForAlarmPortal(BAlarmPortalTool obj, BAlarmRecord selectedRecord, String alarmSourceExtCamera) {
        BOrdList alarmSource = selectedRecord.getSource();
        BAlarmPortalTool tool = obj;
        BOrd consoleOrd = alarmSource.get(alarmSource.size() - 1);
        BAlarmPortalOptions options = BAlarmPortalOptions.getDefault();
        BConsoleRecordList consoleList = options.getConsoleList();
        for (int i = 0; i < consoleList.size(); ++i) {
            BConsoleRecord entry = consoleList.get(i);
            BConsoleRecipient r = tool.getRecipientForRecord(entry);
            if (r == null) continue;
            String foxScheme = "|fox:";
            BOrd entryConsoleOrd = BOrd.make((String)(entry.getHostOrd() + foxScheme + entry.getPort() + "|station:|" + r.getSlotPathOrd()));
            if (!consoleOrd.equals((Object)entryConsoleOrd)) continue;
            r.lease();
            if (r.getSession() instanceof BFoxSession) {
                BFoxSession foxSession = (BFoxSession)r.getSession();
                String currentStationName = foxSession.getStationName();
                if (alarmSourceExtCamera.indexOf("/" + currentStationName + "/remoteVideo_NiagaraCameraExt/") > -1) {
                    BComponent bNiagaraStationAlarms;
                    BComponent c = foxSession.getService(BTypeSpec.make((String)"remoteVideo:RemoteVideoService").getResolvedType());
                    BComponent params = new BComponent();
                    BOrd bNiagaraStationOrd = alarmSource.get(1);
                    try {
                        bNiagaraStationAlarms = (BComponent)bNiagaraStationOrd.get((BObject)r);
                        bNiagaraStationAlarms.lease();
                    }
                    catch (UnresolvedException ue) {
                        throw new BajaRuntimeException(VideoDriverLexicon.getLexString((String)"AlarmConsoleExt.SupervisorVideo.NiagaraStation.NotFound", (Object)bNiagaraStationOrd), (Throwable)ue);
                    }
                    BNiagaraStation bNiagaraStation = (BNiagaraStation)bNiagaraStationAlarms.getParent();
                    params.add("stationName", (BValue)BString.make((String)bNiagaraStation.getName()));
                    params.add("cameraOrd", (BValue)BOrd.make((String)alarmSourceExtCamera));
                    try {
                        Object returnValue = FoxRpcUtil.doSilentRpc((BISpaceNode)c, (String)"getLocalCameraOrdFromAlarmRPC", (Object[])new Object[]{params}).orElseThrow(() -> new BajaRuntimeException("RPC call to RemoteVideoService#getLocalCameraOrdFromAlarmRPC failed"));
                        alarmSourceExtCamera = returnValue.toString();
                    }
                    catch (Exception e) {
                        throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.SupervisorVideo.MultipleTiers.NotSupported"), (Throwable)e);
                    }
                }
            }
            BOrd videoCameraOrd = BOrd.make((String)(entry.getHostOrd() + foxScheme + entry.getPort() + "|station:|" + alarmSourceExtCamera));
            try {
                videoCameraOrd.get();
            }
            catch (Exception e) {
                if (alarmSource.size() > 2) {
                    throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.SupervisorVideo.MultipleTiers.NotSupported"));
                }
                throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.ErrorResolvingCameraOrd", new Object[]{videoCameraOrd}), (Throwable)e);
            }
            return videoCameraOrd;
        }
        throw new BajaRuntimeException(VideoDriverLexicon.LEX.getText("AlarmConsoleExt.AlarmPortal.ErrorResolvingConsoleOrd", new Object[]{consoleOrd}));
    }

    protected static String getLocalizedMessage(String remoteVideoLocalizationCode) {
        Object[] args;
        String key;
        int indexOfOpeningBrace = remoteVideoLocalizationCode.indexOf(123);
        if (indexOfOpeningBrace < 0) {
            key = remoteVideoLocalizationCode;
            args = null;
        } else {
            key = remoteVideoLocalizationCode.substring(0, indexOfOpeningBrace);
            Array argStrArray = new Array(String.class);
            int indexOfClosingBrace = remoteVideoLocalizationCode.indexOf(125, indexOfOpeningBrace + 1);
            while (indexOfClosingBrace >= 0) {
                argStrArray.add((Object)remoteVideoLocalizationCode.substring(indexOfOpeningBrace + 1, indexOfClosingBrace));
                indexOfOpeningBrace = remoteVideoLocalizationCode.indexOf(123, indexOfClosingBrace + 1);
                if (indexOfOpeningBrace < 0) {
                    indexOfClosingBrace = -1;
                    continue;
                }
                indexOfClosingBrace = remoteVideoLocalizationCode.indexOf(125, indexOfOpeningBrace + 1);
            }
            args = argStrArray.size() > 0 ? argStrArray.trim() : null;
        }
        return VideoDriverLexicon.LEX.getText(key, args);
    }

    protected static BOrd resolveVideoCameraObject(BAlarmConsole alarmConsole, BAlarmRecord selectedRecord) {
        return AlarmConsoleExt.resolveVideoCameraObject(alarmConsole.getCurrentValue(), selectedRecord);
    }

    public static BOrd resolveVideoCameraObject(BObject obj, BAlarmRecord selectedRecord) {
        BOrd videoCameraHandleOrd;
        try {
            videoCameraHandleOrd = AlarmConsoleExt.resolveVideoCameraObject(obj, selectedRecord, "cameraHandleOrd");
        }
        catch (BajaRuntimeException bre) {
            videoCameraHandleOrd = null;
        }
        if (videoCameraHandleOrd == null) {
            return AlarmConsoleExt.resolveVideoCameraObject(obj, selectedRecord, "cameraOrd");
        }
        return videoCameraHandleOrd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doShowVideo(BAlarmConsole alarmConsole, BAlarmRecord selectedRecord) {
        BAlarmConsoleVideoPlayerDialog d = new BAlarmConsoleVideoPlayerDialog(alarmConsole);
        AlarmConsoleReviewVideoThread t = new AlarmConsoleReviewVideoThread(d, alarmConsole, selectedRecord);
        t.start();
        d.open();
        if (t.error == null) {
            if (!t.isAlive()) return;
            try {
                for (int i = 0; i < 20 && t.isAlive(); ++i) {
                    t.interrupt();
                    t.join(100L);
                }
                return;
            }
            catch (InterruptedException ie) {
                if (!log.isLoggable(Level.FINE)) return;
                log.fine("Interrupted while trying to stop the async load thread.");
                return;
            }
        } else {
            BDialog.error((BWidget)alarmConsole, (String)t.errorTitle, (Object)t.errorMessage, (Throwable)t.error);
        }
    }

    public static String toLocalizedServerException(Exception e) {
        Throwable cause = e;
        while (cause != null && !(cause instanceof ServerException)) {
            try {
                Method getCauseMethod = cause.getClass().getMethod("getCause", new Class[0]);
                if (getCauseMethod == null) {
                    cause = null;
                    continue;
                }
                Object nextCause = getCauseMethod.invoke((Object)cause, new Object[0]);
                if (nextCause == null) {
                    cause = null;
                    continue;
                }
                if (nextCause instanceof Throwable) {
                    cause = (Throwable)nextCause;
                    continue;
                }
                cause = null;
            }
            catch (Exception introspectionException) {
                cause = null;
            }
        }
        if (cause == null) {
            cause = e;
        }
        if (cause != null && cause instanceof ServerException) {
            String serverMessage = cause.getMessage();
            if (serverMessage.startsWith(SERVER_MESSAGE_REMOTE_VIDEO_LOCALIZATION_CODE)) {
                String remoteVideoLocalizationCode = serverMessage.substring(START_OF_REMOTE_VIDEO_LOCALIZATION_CODE);
                return AlarmConsoleExt.getLocalizedMessage(remoteVideoLocalizationCode);
            }
            return null;
        }
        return null;
    }

    public static class AlarmConsoleReviewVideoThread
    extends Thread {
        public BAlarmConsole alarmConsole;
        public BAlarmRecord selectedRecord;
        public BAlarmConsoleVideoPlayerDialog d;
        public Exception error;
        public String errorTitle;
        public Object errorMessage;

        public AlarmConsoleReviewVideoThread(BAlarmConsoleVideoPlayerDialog d, BAlarmConsole alarmConsole, BAlarmRecord selectedRecord) {
            super("AlarmConsole.ReviewVideo");
            this.d = d;
            this.alarmConsole = alarmConsole;
            this.selectedRecord = selectedRecord;
        }

        @Override
        public void run() {
            block8: {
                try {
                    BOrd videoCameraOrd = AlarmConsoleExt.resolveVideoCameraObject(this.alarmConsole, this.selectedRecord);
                    if (videoCameraOrd == null || videoCameraOrd.equals((Object)BOrd.NULL)) {
                        this.error = new UnresolvedException(VideoDriverLexicon.LEX.getText("UnableToResolveCameraForAlarmRecord"));
                        this.errorTitle = VideoDriverLexicon.LEX.getText("UnableToResolveCameraForAlarmRecord");
                        this.errorMessage = VideoDriverLexicon.LEX.getText("UnableToResolveCameraForAlarmRecord.Details");
                        if (!this.d.isClosed()) {
                            this.d.close();
                        }
                    } else {
                        this.d.loadAsync(this.alarmConsole, this.selectedRecord, videoCameraOrd, videoCameraOrd.get(this.alarmConsole.getCurrentValue()));
                    }
                }
                catch (BajaRuntimeException bre) {
                    UnresolvedOrOfflineStationException ue;
                    Throwable ueCause;
                    this.error = bre;
                    this.errorTitle = VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo");
                    this.errorMessage = VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo2", new Object[]{bre.getMessage()});
                    Throwable breCause = bre.getCause();
                    if (breCause instanceof UnresolvedOrOfflineStationException && (ueCause = (ue = (UnresolvedOrOfflineStationException)breCause).getCause()) instanceof LocalizableRuntimeException) {
                        this.errorMessage = this.errorTitle;
                    }
                    if (!this.d.isClosed()) {
                        this.d.close();
                    }
                }
                catch (Exception e) {
                    this.error = e;
                    this.errorTitle = VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo");
                    this.errorMessage = VideoDriverLexicon.LEX.getText("UnableToPlayAlarmVideo");
                    if (this.d.isClosed()) break block8;
                    this.d.close();
                }
            }
        }
    }
}

