/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.sys.service.ServiceManager;
import com.tridium.systemIndex.SystemIndexLog;
import java.security.AccessController;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="jobName", type="String", defaultValue="System Index", flags=7)
public final class BSystemIndexJob
extends BJob {
    public static final Property jobName = BSystemIndexJob.newProperty((int)7, (String)"System Index", null);
    public static final Type TYPE = Sys.loadType(BSystemIndexJob.class);
    private static final BIcon icon = BIcon.std((String)"index.png");
    private static final Object cleanupLock = new Object();
    private static final int LOG_LIMIT = AccessController.doPrivileged(() -> Integer.getInteger("systemIndex.job.logLimit", 10000));

    public String getJobName() {
        return this.getString(jobName);
    }

    public void setJobName(String v) {
        this.setString(jobName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSystemIndexJob() {
        this.log().setLimit(LOG_LIMIT);
    }

    public BSystemIndexJob(String name) {
        this.setJobName(name);
        this.log().setLimit(LOG_LIMIT);
    }

    public void resetLog() {
        super.resetLog();
        this.log().setLimit(LOG_LIMIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrd submit(Context cx) {
        BComponent jobService = (BComponent)BJobService.getService();
        Object object = cleanupLock;
        synchronized (object) {
            int numShouldDispose;
            BJob[] jobs = (BJob[])jobService.getChildren(BSystemIndexJob.class);
            if (jobs != null && (numShouldDispose = jobs.length - ServiceManager.jobMaxCountPerType + 1) > 0) {
                int deleteCount = 0;
                for (int i = 0; i < jobs.length && deleteCount < numShouldDispose; ++i) {
                    BJobState jobState = jobs[i].getJobState();
                    if (jobState == BJobState.running || jobState == BJobState.unknown) continue;
                    jobs[i].dispose();
                    ++deleteCount;
                }
            }
        }
        return super.submit(cx);
    }

    public void doRun(Context cx) throws Exception {
    }

    public void doCancel(Context cx) throws Exception {
    }

    public String toString(Context cx) {
        return this.getJobName();
    }

    public BIcon getIcon() {
        return icon;
    }

    static class JobSystemIndexLog
    implements SystemIndexLog {
        private BJob job;
        private boolean logIndividualEntityRecords;

        public JobSystemIndexLog(BJob job, boolean logIndividualEntityRecords) {
            this.job = job;
            this.logIndividualEntityRecords = logIndividualEntityRecords;
        }

        @Override
        public void combine(SystemIndexLog log) {
            if (log instanceof JobSystemIndexLog) {
                BJob otherJob = ((JobSystemIndexLog)log).job;
                int size = otherJob.log().size();
                for (int i = 0; i < size; ++i) {
                    this.job.log().add(otherJob.log().getItem(i));
                }
            }
        }

        @Override
        public boolean isLoggingEnabled() {
            return true;
        }

        @Override
        public boolean isLoggingIndividualEntityRecords() {
            return this.logIndividualEntityRecords;
        }

        @Override
        public void setLimit(int limit) {
            this.job.log().setLimit(limit);
        }

        @Override
        public void progress(int percent) {
            this.job.progress(percent);
        }

        @Override
        public void start(String nonLocalizedMessage) {
            this.job.log().start(nonLocalizedMessage);
        }

        @Override
        public void start(String lexModule, String lexKey, String[] lexArgPatterns) {
            this.job.log().start(lexModule, lexKey, lexArgPatterns);
        }

        @Override
        public void endSuccess(String nonLocalizedAppendText) {
            this.job.log().endSuccess(nonLocalizedAppendText);
        }

        @Override
        public void endSuccess(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
            this.job.log().endSuccess(appendLexModule, appendLexKey, appendLexArgPatterns);
        }

        @Override
        public void endSuccess() {
            this.job.log().endSuccess();
        }

        @Override
        public void endFailed(String nonLocalizedAppendText, Throwable exception) {
            this.job.log().endFailed(nonLocalizedAppendText, exception);
        }

        @Override
        public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns, Throwable exception) {
            this.job.log().endFailed(appendLexModule, appendLexKey, appendLexArgPatterns, exception);
        }

        @Override
        public void message(String nonLocalizedMessage) {
            this.job.log().message(nonLocalizedMessage);
        }

        @Override
        public void message(String lexModule, String lexKey, String[] lexArgPatterns) {
            this.job.log().message(lexModule, lexKey, lexArgPatterns);
        }

        @Override
        public void success(String nonLocalizedMessage) {
            this.job.log().success(nonLocalizedMessage);
        }

        @Override
        public void success(String lexModule, String lexKey, String[] lexArgPatterns) {
            this.job.log().success(lexModule, lexKey, lexArgPatterns);
        }

        @Override
        public void failed(String nonLocalizedMessage) {
            this.job.log().failed(nonLocalizedMessage);
        }

        @Override
        public void failed(String lexModule, String lexKey, String[] lexArgPatterns) {
            this.job.log().failed(lexModule, lexKey, lexArgPatterns);
        }

        @Override
        public void failed(String msg, Throwable exception) {
            this.job.log().failed(msg, exception);
        }

        @Override
        public void failed(String lexModule, String lexKey, String[] lexArgPatterns, Throwable exception) {
            this.job.log().failed(lexModule, lexKey, lexArgPatterns, exception);
        }
    }

    static class DefaultSystemIndexLog
    implements SystemIndexLog {
        DefaultSystemIndexLog() {
        }

        @Override
        public void combine(SystemIndexLog log) {
        }

        @Override
        public boolean isLoggingEnabled() {
            return false;
        }

        @Override
        public boolean isLoggingIndividualEntityRecords() {
            return false;
        }

        @Override
        public void setLimit(int limit) {
        }

        @Override
        public void progress(int percent) {
        }

        @Override
        public void start(String nonLocalizedMessage) {
        }

        @Override
        public void start(String lexModule, String lexKey, String[] lexArgPatterns) {
        }

        @Override
        public void endSuccess(String nonLocalizedAppendText) {
        }

        @Override
        public void endSuccess(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        }

        @Override
        public void endSuccess() {
        }

        @Override
        public void endFailed(String nonLocalizedAppendText, Throwable exception) {
        }

        @Override
        public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns, Throwable exception) {
        }

        @Override
        public void endFailed(Throwable exception) {
        }

        @Override
        public void endFailed(String nonLocalizedAppendText) {
        }

        @Override
        public void endFailed(String appendLexModule, String appendLexKey, String[] appendLexArgPatterns) {
        }

        @Override
        public void message(String nonLocalizedMessage) {
        }

        @Override
        public void message(String lexModule, String lexKey, String[] lexArgPatterns) {
        }

        @Override
        public void message(String lexModule, String lexKey, String lexArgPattern) {
        }

        @Override
        public void message(String lexModule, String lexKey) {
        }

        @Override
        public void success(String nonLocalizedMessage) {
        }

        @Override
        public void success(String lexModule, String lexKey, String lexArgPattern) {
        }

        @Override
        public void success(String lexModule, String lexKey) {
        }

        @Override
        public void success(String lexModule, String lexKey, String[] lexArgPatterns) {
        }

        @Override
        public void failed(String nonLocalizedMessage) {
        }

        @Override
        public void failed(String lexModule, String lexKey, String[] lexArgPatterns) {
        }

        @Override
        public void failed(String lexModule, String lexKey, String lexArgPattern) {
        }

        @Override
        public void failed(String lexModule, String lexKey) {
        }

        @Override
        public void failed(String msg, Throwable exception) {
        }

        @Override
        public void failed(String lexModule, String lexKey, String[] lexArgPatterns, Throwable exception) {
        }

        @Override
        public void failed(String lexModule, String lexKey, String lexArgPattern, Throwable exception) {
        }

        @Override
        public void failed(String lexModule, String lexKey, Throwable exception) {
        }
    }
}

