/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemIndex;

import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.baja.collection.BITable;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.query.BQueryResult;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BLocalSystemIndexer
extends BSystemIndexer
implements BIRestrictedComponent {
    public static final Type TYPE = Sys.loadType(BLocalSystemIndexer.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/device.png"));
    private static final String LOCAL_ENTITIES_LICENSE_ATTRIBUTE = "local.entity.limit";
    private static final String LOCAL_UNLICENSED = Lexicon.make((String)"systemIndex").getText("systemIndex.missingEntityLimit", new Object[]{"local.entity.limit"});
    private static final AtomicInteger localEntityLimit = new AtomicInteger(-1);
    private volatile String lastLimitExceededMsg;

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeFullIndex(SystemIndexLog log, Context cx) throws Exception {
        long start;
        block8: {
            block7: {
                int size;
                BLocalSystemIndexer.checkServicesOperational(log);
                int limit = this.getLocalEntityLicenseLimit();
                if (limit <= 0) {
                    throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", new Object[]{Sys.getStation().getStationName(), LOCAL_UNLICENSED});
                }
                start = DiagnosticUtil.startIfLoggable((String)"systemIndexer_local_executeFull");
                AtomicInteger counter = new AtomicInteger();
                Supplier<Stream<Entity>> entityStreamSupplier = () -> {
                    try {
                        Stream<Entity> entities = BLocalSystemIndexer.resolveLocalIndexQueries(this.getOperationalIndexQueries(), true, cx);
                        counter.set(0);
                        if (limit != Integer.MAX_VALUE) {
                            entities = entities.filter(e -> counter.incrementAndGet() <= limit);
                        }
                        return entities;
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e2) {
                        throw new BajaRuntimeException((Throwable)e2);
                    }
                };
                try {
                    BLocalSystemIndexer.systemIndexToSystemDb(Sys.getStation().getStationName(), entityStreamSupplier, log, SystemIndexContextHolder.INDEX_CONTEXT);
                    size = counter.get();
                    if (size <= limit) break block7;
                }
                catch (Throwable throwable) {
                    int size2 = counter.get();
                    if (size2 > limit) {
                        String[] args = new String[]{Sys.getStation().getStationName(), Integer.toString(size2), Integer.toString(limit)};
                        this.lastLimitExceededMsg = Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args);
                        this.setFaultCause(this.lastLimitExceededMsg);
                        if (log.isLoggingEnabled()) {
                            log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                        }
                    } else {
                        this.lastLimitExceededMsg = null;
                        this.setFaultCause("");
                    }
                    DiagnosticUtil.complete((long)start, (String)"systemIndexer_local_executeFull");
                    throw throwable;
                }
                String[] args = new String[]{Sys.getStation().getStationName(), Integer.toString(size), Integer.toString(limit)};
                this.lastLimitExceededMsg = Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args);
                this.setFaultCause(this.lastLimitExceededMsg);
                if (log.isLoggingEnabled()) {
                    log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                }
                break block8;
            }
            this.lastLimitExceededMsg = null;
            this.setFaultCause("");
        }
        DiagnosticUtil.complete((long)start, (String)"systemIndexer_local_executeFull");
    }

    @Override
    public void executeOk() {
        String oldFaultCause = this.getFaultCause();
        super.executeOk();
        if (this.lastLimitExceededMsg != null && oldFaultCause.equals(this.lastLimitExceededMsg)) {
            this.setFaultCause(oldFaultCause);
        }
    }

    public static Stream<Entity> resolveLocalIndexQueries(BOrdList indexQueries, boolean processForLocalConsumption, Context cx) throws Exception {
        BIPostQueryFilter filter;
        BIPostQueryFilter bIPostQueryFilter = filter = processForLocalConsumption ? LocalQueryFilter.localConsumptionFilter : LocalQueryFilter.remoteConsumptionFilter;
        if (filter == null) {
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.local.unusable");
        }
        BIQueryHandler.validateQueryOrds((BOrdList)indexQueries);
        Stream mergedEntityStream = null;
        for (BOrd queryOrd : indexQueries) {
            BOrd ord = BOrd.make((BOrd)BOrd.make((String)"local:|station:|slot:/"), (BOrd)queryOrd);
            BObject queryResult = ord.get();
            Stream<Entity> entityStream = null;
            if (queryResult.getType().is(BQueryResult.TYPE)) {
                entityStream = ((BQueryResult)queryResult).stream();
            } else if (queryResult.getType().is(BITable.TYPE)) {
                BITable table = (BITable)queryResult;
                entityStream = table.cursor().stream().filter(obj -> obj instanceof Entity).map(obj -> (Entity)obj);
            }
            if (entityStream == null) continue;
            if (mergedEntityStream == null) {
                mergedEntityStream = entityStream;
                continue;
            }
            mergedEntityStream = Stream.concat(mergedEntityStream, entityStream);
        }
        mergedEntityStream = mergedEntityStream == null ? Stream.empty() : filter.postQueryFilter(mergedEntityStream.distinct(), cx);
        return mergedEntityStream;
    }

    @Override
    protected String getIndexDescription(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemIndex.local");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BSystemIndexService.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    protected String checkFatalFault() {
        if (this.getLocalEntityLicenseLimit() <= 0) {
            return Lexicon.make((String)"systemIndex").getText("systemIndex.unlicensedStation", new Object[]{Sys.getStation().getStationName(), LOCAL_UNLICENSED});
        }
        return null;
    }

    private int getLocalEntityLicenseLimit() {
        if (localEntityLimit.get() == -1) {
            int limit;
            try {
                limit = LicenseUtil.parseLimit((Feature)this.getSystemIndexService().getLicenseFeature(), (String)LOCAL_ENTITIES_LICENSE_ATTRIBUTE);
            }
            catch (Exception e) {
                limit = 0;
                BSystemIndexService.log.warning(() -> "LocalSystemIndexer is unlicensed");
            }
            localEntityLimit.set(limit <= 0 ? 0 : limit);
        }
        return localEntityLimit.get();
    }

    private static final class LocalQueryFilter {
        static final BIPostQueryFilter remoteConsumptionFilter;
        static final BIPostQueryFilter localConsumptionFilter;

        private LocalQueryFilter() {
        }

        static {
            BIPostQueryFilter remoteFilter;
            BComplex localFilter;
            try {
                localFilter = (BComplex)Sys.getType((String)"niagaraDriver:NiagaraRemoteQueryFilter").getInstance();
                localFilter.set("translateOrds", (BValue)BBoolean.TRUE);
                remoteFilter = (BIPostQueryFilter)localFilter.newCopy(true);
                localFilter.set("persistCategoryMask", (BValue)BBoolean.TRUE);
            }
            catch (Exception e) {
                remoteFilter = null;
                localFilter = null;
                BSystemIndexService.log.log(Level.SEVERE, e, () -> "Could not initialize filter for the LocalSystemIndexer, so it will be unusable. Ensure niagaraDriver-rt is installed with a compatible version and restart.");
            }
            remoteConsumptionFilter = remoteFilter;
            localConsumptionFilter = localFilter instanceof BIPostQueryFilter ? (BIPostQueryFilter)localFilter : null;
        }
    }

    private static final class SystemIndexContextHolder {
        static final Context INDEX_CONTEXT = AccessController.doPrivileged(() -> BSystemDb.getSystemIndexContext());

        private SystemIndexContextHolder() {
        }
    }
}

