/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRandom
extends BNumericPoint {
    public static final Property multiplier = BRandom.newProperty((int)0, (double)1.0, null);
    public static final Property offset = BRandom.newProperty((int)0, (int)50, null);
    public static final Property updateInterval = BRandom.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Type TYPE = Sys.loadType(BRandom.class);
    private static final BIcon icon = BIcon.std((String)"control/util/sine.png");
    private long start;
    private Clock.Ticket ticket;

    public double getMultiplier() {
        return this.getDouble(multiplier);
    }

    public void setMultiplier(double v) {
        this.setDouble(multiplier, v, null);
    }

    public double getOffset() {
        return this.getDouble(offset);
    }

    public void setOffset(double v) {
        this.setDouble(offset, v, null);
    }

    public BRelTime getUpdateInterval() {
        return (BRelTime)this.get(updateInterval);
    }

    public void setUpdateInterval(BRelTime v) {
        this.set(updateInterval, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    private void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateInterval(), (Action)execute, null);
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == updateInterval) {
            if (this.getUpdateInterval().getMillis() < 1000L) {
                this.setUpdateInterval(BRelTime.make((long)1000L));
            }
            if (this.isRunning()) {
                this.initTimer();
            }
        }
    }

    public void onExecute(BStatusValue o, Context cx) {
        double multiplier = this.getMultiplier();
        double offset = this.getOffset();
        double value = Math.random() * multiplier + offset;
        BStatusNumeric out = (BStatusNumeric)o;
        out.setValue(value);
    }

    public BIcon getIcon() {
        return icon;
    }
}

