/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import com.tridium.kitControl.util.BRampWaveform;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRamp
extends BNumericPoint {
    public static final Property enabled = BRamp.newProperty((int)0, (boolean)true, null);
    public static final Property period = BRamp.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property amplitude = BRamp.newProperty((int)0, (int)50, null);
    public static final Property offset = BRamp.newProperty((int)0, (int)50, null);
    public static final Property updateInterval = BRamp.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property waveform = BRamp.newProperty((int)0, (BValue)BRampWaveform.triangle, null);
    public static final Type TYPE = Sys.loadType(BRamp.class);
    private static final BIcon icon = BIcon.std((String)"control/util/sine.png");
    private long start;
    private Clock.Ticket ticket;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getPeriod() {
        return (BRelTime)this.get(period);
    }

    public void setPeriod(BRelTime v) {
        this.set(period, (BValue)v, null);
    }

    public double getAmplitude() {
        return this.getDouble(amplitude);
    }

    public void setAmplitude(double v) {
        this.setDouble(amplitude, v, null);
    }

    public double getOffset() {
        return this.getDouble(offset);
    }

    public void setOffset(double v) {
        this.setDouble(offset, v, null);
    }

    public BRelTime getUpdateInterval() {
        return (BRelTime)this.get(updateInterval);
    }

    public void setUpdateInterval(BRelTime v) {
        this.set(updateInterval, (BValue)v, null);
    }

    public BRampWaveform getWaveform() {
        return (BRampWaveform)this.get(waveform);
    }

    public void setWaveform(BRampWaveform v) {
        this.set(waveform, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.execute();
        this.initTimer();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    private void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.start = Clock.ticks();
        if (this.getEnabled()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateInterval(), (Action)execute, null);
        }
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (prop == updateInterval || prop == enabled) {
            if (this.getUpdateInterval().getMillis() < 1000L) {
                this.setUpdateInterval(BRelTime.make((long)1000L));
            }
            if (this.isRunning()) {
                this.initTimer();
            }
        }
    }

    public void onExecute(BStatusValue o, Context cx) {
        if (this.getEnabled()) {
            double value;
            o.setStatus(BStatus.makeDisabled((BStatus)o.getStatus(), (boolean)false));
            long period = this.getPeriod().getMillis();
            long runtime = Clock.ticks() - this.start;
            long millisIntoPeriod = runtime % period;
            double periodPercent = (double)millisIntoPeriod / (double)period;
            double amplitude = this.getAmplitude();
            double offset = this.getOffset();
            switch (this.getWaveform().getOrdinal()) {
                case 0: {
                    value = offset - amplitude + (periodPercent < 0.5 ? amplitude * periodPercent : amplitude * (1.0 - periodPercent)) * 4.0;
                    break;
                }
                case 1: {
                    value = offset - amplitude + amplitude * periodPercent * 2.0;
                    break;
                }
                case 2: {
                    value = offset - amplitude + amplitude * (1.0 - periodPercent) * 2.0;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            BStatusNumeric out = (BStatusNumeric)o;
            out.setValue(value);
        } else {
            o.setStatus(BStatus.makeDisabled((BStatus)o.getStatus(), (boolean)true));
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

