/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.math;

import com.tridium.kitControl.math.BMath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BQuadMath
extends BMath {
    public static final Property inA = BQuadMath.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property inB = BQuadMath.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property inC = BQuadMath.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property inD = BQuadMath.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Type TYPE = Sys.loadType(BQuadMath.class);

    public BStatusNumeric getInA() {
        return (BStatusNumeric)this.get(inA);
    }

    public void setInA(BStatusNumeric v) {
        this.set(inA, (BValue)v, null);
    }

    public BStatusNumeric getInB() {
        return (BStatusNumeric)this.get(inB);
    }

    public void setInB(BStatusNumeric v) {
        this.set(inB, (BValue)v, null);
    }

    public BStatusNumeric getInC() {
        return (BStatusNumeric)this.get(inC);
    }

    public void setInC(BStatusNumeric v) {
        this.set(inC, (BValue)v, null);
    }

    public BStatusNumeric getInD() {
        return (BStatusNumeric)this.get(inD);
    }

    public void setInD(BStatusNumeric v) {
        this.set(inD, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric inA = this.getInA();
        BStatusNumeric inB = this.getInB();
        BStatusNumeric inC = this.getInC();
        BStatusNumeric inD = this.getInD();
        BStatus aStatus = inA.getStatus();
        BStatus bStatus = inB.getStatus();
        BStatus cStatus = inC.getStatus();
        BStatus dStatus = inD.getStatus();
        int a = 0;
        int b = 0;
        int c = 0;
        int d = 0;
        a = aStatus.getBits();
        b = bStatus.getBits();
        c = cStatus.getBits();
        d = dStatus.getBits();
        int nonNullCount = 0;
        boolean forceNull = false;
        if (aStatus.isValid()) {
            ++nonNullCount;
        }
        if (bStatus.isValid()) {
            ++nonNullCount;
        }
        if (cStatus.isValid()) {
            ++nonNullCount;
        }
        if (dStatus.isValid()) {
            ++nonNullCount;
        }
        if (nonNullCount < this.minInputs()) {
            forceNull = true;
        }
        BStatusNumeric out = (BStatusNumeric)o;
        if (forceNull) {
            out.setValue(Double.NaN);
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setValue(this.calculate(inA, inB, inC, inD));
            out.setStatus(this.propagate(BStatus.make((int)(a | b | c | d))));
        }
    }

    protected abstract double calculate(BStatusNumeric var1, BStatusNumeric var2, BStatusNumeric var3, BStatusNumeric var4);

    public abstract int minInputs();
}

