/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.math;

import com.tridium.kitControl.math.BMath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BBinaryMath
extends BMath {
    public static final Property inA = BBinaryMath.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property inB = BBinaryMath.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Type TYPE = Sys.loadType(BBinaryMath.class);

    public BStatusNumeric getInA() {
        return (BStatusNumeric)this.get(inA);
    }

    public void setInA(BStatusNumeric v) {
        this.set(inA, (BValue)v, null);
    }

    public BStatusNumeric getInB() {
        return (BStatusNumeric)this.get(inB);
    }

    public void setInB(BStatusNumeric v) {
        this.set(inB, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric inA = this.getInA();
        BStatusNumeric inB = this.getInB();
        BStatus sa = inA.getStatus();
        BStatus sb = inB.getStatus();
        BStatusNumeric out = (BStatusNumeric)o;
        if (sa.isNull() || sb.isNull()) {
            out.setStatus(BStatus.nullStatus);
            out.setValue(Double.NaN);
        } else {
            out.setStatus(this.propagate(BStatus.make((int)(sa.getBits() | sb.getBits()))));
            if (!sa.isValid() || !sb.isValid()) {
                out.setValue(Double.NaN);
            } else {
                out.setValue(this.calculate(inA.getValue(), inB.getValue()));
            }
        }
    }

    protected abstract double calculate(double var1, double var3);
}

