/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import com.tridium.kitControl.enums.BLoopAction;
import com.tridium.kitControl.logic.BLogic;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTstat
extends BLogic {
    public static final Property cv = BTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property sp = BTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property diff = BTstat.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property action = BTstat.newProperty((int)0, (BValue)BLoopAction.direct, null);
    public static final Property nullOnInControl = BTstat.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BTstat.class);
    boolean inControl = false;

    public BStatusNumeric getCv() {
        return (BStatusNumeric)this.get(cv);
    }

    public void setCv(BStatusNumeric v) {
        this.set(cv, (BValue)v, null);
    }

    public BStatusNumeric getSp() {
        return (BStatusNumeric)this.get(sp);
    }

    public void setSp(BStatusNumeric v) {
        this.set(sp, (BValue)v, null);
    }

    public BStatusNumeric getDiff() {
        return (BStatusNumeric)this.get(diff);
    }

    public void setDiff(BStatusNumeric v) {
        this.set(diff, (BValue)v, null);
    }

    public BLoopAction getAction() {
        return (BLoopAction)this.get(action);
    }

    public void setAction(BLoopAction v) {
        this.set(action, (BValue)v, null);
    }

    public boolean getNullOnInControl() {
        return this.getBoolean(nullOnInControl);
    }

    public void setNullOnInControl(boolean v) {
        this.setBoolean(nullOnInControl, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric controlVariable = this.getCv();
        BStatusNumeric setpoint = this.getSp();
        BStatusBoolean out = (BStatusBoolean)o;
        BStatus sa = controlVariable.getStatus();
        BStatus sb = setpoint.getStatus();
        if (sa.isNull() || sb.isNull()) {
            out.setValue(false);
            out.setStatus(BStatus.nullStatus);
        } else {
            out.setStatus(this.propagate(BStatus.make((int)(sa.getBits() | sb.getBits()))));
            if (!sa.isValid() || !sb.isValid()) {
                out.setValue(false);
            } else {
                out.setValue(this.calculate());
            }
            if (this.getNullOnInactive() && !out.getValue()) {
                out.setStatusNull(true);
            } else if (this.getNullOnInControl() && this.inControl) {
                out.setStatusNull(true);
            }
        }
    }

    protected boolean calculate() {
        double currentValue;
        double halfDiff = this.getDiff().getValue() / 2.0;
        double highValue = this.getSp().getValue() + halfDiff;
        double lowValue = this.getSp().getValue() - halfDiff;
        boolean returnValue = this.getOut().getValue();
        if (this.getAction() != BLoopAction.direct) {
            boolean bl = returnValue = !returnValue;
        }
        if ((currentValue = this.getCv().getValue()) >= highValue) {
            returnValue = true;
        } else if (currentValue <= lowValue) {
            returnValue = false;
        }
        if (this.getAction() != BLoopAction.direct) {
            returnValue = !returnValue;
        }
        this.inControl = currentValue > lowValue && currentValue < highValue;
        return returnValue;
    }
}

