/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSequence
extends BComponent {
    public static final Property facets = BSequence.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BSequence.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property inMinimum = BSequence.newProperty((int)0, (double)0.0, null);
    public static final Property inMaximum = BSequence.newProperty((int)0, (double)100.0, null);
    public static final Property numberOutputs = BSequence.newProperty((int)0, (int)3, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property outA = BSequence.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BSequence.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BSequence.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BSequence.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property delay = BSequence.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property onDelayActive = BSequence.newProperty((int)3, (boolean)false, null);
    public static final Property offDelayActive = BSequence.newProperty((int)3, (boolean)false, null);
    public static final Property desiredStagesOn = BSequence.newProperty((int)3, (int)0, null);
    public static final Property currentStagesOn = BSequence.newProperty((int)3, (int)0, null);
    public static final Property nextStageOn = BSequence.newProperty((int)3, (int)0, null);
    public static final Property nextStageOff = BSequence.newProperty((int)3, (int)0, null);
    public static final Action onDelayTimerExpired = BSequence.newAction((int)20, null);
    public static final Action offDelayTimerExpired = BSequence.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BSequence.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    int numStagesOn;
    int curStagesOn;
    int nxtStageOn = 1;
    int nxtStageOff = 0;
    int numOutputs;
    int startStage = 1;
    boolean wasEqual = false;
    Clock.Ticket onTicket;
    Clock.Ticket offTicket;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public double getInMinimum() {
        return this.getDouble(inMinimum);
    }

    public void setInMinimum(double v) {
        this.setDouble(inMinimum, v, null);
    }

    public double getInMaximum() {
        return this.getDouble(inMaximum);
    }

    public void setInMaximum(double v) {
        this.setDouble(inMaximum, v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    public void setDelay(BRelTime v) {
        this.set(delay, (BValue)v, null);
    }

    public boolean getOnDelayActive() {
        return this.getBoolean(onDelayActive);
    }

    public void setOnDelayActive(boolean v) {
        this.setBoolean(onDelayActive, v, null);
    }

    public boolean getOffDelayActive() {
        return this.getBoolean(offDelayActive);
    }

    public void setOffDelayActive(boolean v) {
        this.setBoolean(offDelayActive, v, null);
    }

    public int getDesiredStagesOn() {
        return this.getInt(desiredStagesOn);
    }

    public void setDesiredStagesOn(int v) {
        this.setInt(desiredStagesOn, v, null);
    }

    public int getCurrentStagesOn() {
        return this.getInt(currentStagesOn);
    }

    public void setCurrentStagesOn(int v) {
        this.setInt(currentStagesOn, v, null);
    }

    public int getNextStageOn() {
        return this.getInt(nextStageOn);
    }

    public void setNextStageOn(int v) {
        this.setInt(nextStageOn, v, null);
    }

    public int getNextStageOff() {
        return this.getInt(nextStageOff);
    }

    public void setNextStageOff(int v) {
        this.setInt(nextStageOff, v, null);
    }

    public void onDelayTimerExpired() {
        this.invoke(onDelayTimerExpired, null, null);
    }

    public void offDelayTimerExpired() {
        this.invoke(offDelayTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initNumberOutputs();
        this.numStagesOn = 0;
        this.curStagesOn = 0;
        this.setDesiredStagesOn(0);
        this.setCurrentStagesOn(0);
        this.nxtStageOn = 1;
        this.nxtStageOff = 0;
        this.setNextStageOn(1);
        this.setNextStageOff(0);
        this.setOutputsOff();
        this.calculate();
        this.setOutputs();
    }

    public void reinitialize() {
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.setOnDelayActive(false);
        this.setOffDelayActive(false);
        this.started();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == numberOutputs) {
            this.initNumberOutputs();
        } else if (p == in) {
            this.calculate();
            this.setOutputs();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        block12: for (int i = 0; i < 10; ++i) {
            int setFlags = i >= this.numOutputs ? 6 : 10;
            switch (i) {
                case 0: {
                    this.initSlot("outA", setFlags | 1);
                    continue block12;
                }
                case 1: {
                    this.initSlot("outB", setFlags | 1);
                    continue block12;
                }
                case 2: {
                    this.initSlot("outC", setFlags | 1);
                    continue block12;
                }
                case 3: {
                    this.initSlot("outD", setFlags | 1);
                    continue block12;
                }
                case 4: {
                    this.initSlot("outE", setFlags | 1);
                    continue block12;
                }
                case 5: {
                    this.initSlot("outF", setFlags | 1);
                    continue block12;
                }
                case 6: {
                    this.initSlot("outG", setFlags | 1);
                    continue block12;
                }
                case 7: {
                    this.initSlot("outH", setFlags | 1);
                    continue block12;
                }
                case 8: {
                    this.initSlot("outI", setFlags | 1);
                    continue block12;
                }
                case 9: {
                    this.initSlot("outJ", setFlags | 1);
                }
            }
        }
    }

    void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doOnDelayTimerExpired() {
        this.setOnDelayActive(false);
        this.calculate();
        this.setOutputs();
    }

    public void doOffDelayTimerExpired() {
        this.setOffDelayActive(false);
        this.calculate();
        this.setOutputs();
    }

    public abstract void calculate();

    public abstract void setOutputs();

    public BStatusBoolean getStatusOutput(int index) {
        if (index < 1) {
            return this.getOutA();
        }
        switch (index) {
            case 1: {
                return this.getOutA();
            }
            case 2: {
                return this.getOutB();
            }
            case 3: {
                return this.getOutC();
            }
            case 4: {
                return this.getOutD();
            }
            case 5: {
                return this.getOutE();
            }
            case 6: {
                return this.getOutF();
            }
            case 7: {
                return this.getOutG();
            }
            case 8: {
                return this.getOutH();
            }
            case 9: {
                return this.getOutI();
            }
            case 10: {
                return this.getOutJ();
            }
        }
        return this.getOutJ();
    }

    public void setOutputsOff() {
        for (int i = 1; i <= this.getNumberOutputs(); ++i) {
            try {
                this.getStatusOutput(i).setValue(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isDelayProgrammed() {
        return this.getDelay().getMillis() != 0L;
    }

    public void startOnDelayTimer() {
        if (this.offTicket != null) {
            this.offTicket.cancel();
            this.setOffDelayActive(false);
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.onTicket = Clock.schedule((BComponent)this, (BRelTime)this.getDelay(), (Action)onDelayTimerExpired, null);
        this.setOnDelayActive(true);
    }

    public void startOffDelayTimer() {
        if (this.onTicket != null) {
            this.onTicket.cancel();
            this.setOnDelayActive(false);
        }
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        this.offTicket = Clock.schedule((BComponent)this, (BRelTime)this.getDelay(), (Action)offDelayTimerExpired, null);
        this.setOffDelayActive(true);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

