/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import com.tridium.kitControl.BLoopPoint;
import java.util.Map;
import javax.baja.alarm.ext.offnormal.BTwoStateAlgorithm;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLoopAlarmAlgorithm
extends BTwoStateAlgorithm {
    public static final Property errorLimit = BLoopAlarmAlgorithm.newProperty((int)0, (int)0, null);
    public static final Property deadband = BLoopAlarmAlgorithm.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BLoopAlarmAlgorithm.class);

    public double getErrorLimit() {
        return this.getDouble(errorLimit);
    }

    public void setErrorLimit(double v) {
        this.setDouble(errorLimit, v, null);
    }

    public double getDeadband() {
        return this.getDouble(deadband);
    }

    public void setDeadband(double v) {
        this.setDouble(deadband, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BLoopPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == deadband || slot == errorLimit) {
            BLoopPoint point = (BLoopPoint)this.getParentPoint();
            if (point != null) {
                return point.getInputFacets();
            }
            return BFacets.DEFAULT;
        }
        return super.getSlotFacets(slot);
    }

    protected boolean isNormal(BStatusValue out) {
        BLoopPoint loopPt = (BLoopPoint)this.getParentPoint();
        double error = Math.abs(loopPt.getSetpoint().getValue() - loopPt.getControlledVariable().getValue());
        if (this.isCurrentOffnormal()) {
            return error < this.getErrorLimit() - this.getDeadband();
        }
        return error < this.getErrorLimit();
    }

    public void writeAlarmData(BStatusValue out, Map map) {
        BLoopPoint loopPt = (BLoopPoint)this.getParentPoint();
        map.put("controlledValue", BString.make((String)loopPt.getControlledVariable().valueToString((Context)loopPt.getInputFacets())));
        map.put("status", BString.make((String)out.getStatus().toString(null)));
        map.put("setptValue", BString.make((String)loopPt.getSetpoint().valueToString((Context)loopPt.getInputFacets())));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)loopPt.getInputFacets())));
        map.put("errorLimit", BString.make((String)BDouble.toString((double)this.getErrorLimit(), (Context)loopPt.getInputFacets())));
    }
}

