/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInterstartDelayMaster
extends BComponent {
    public static final Property slaveLink = BInterstartDelayMaster.newProperty((int)3, (BValue)BOrd.NULL, null);
    public static final Property defaultDelay = BInterstartDelayMaster.newProperty((int)0, (BValue)BRelTime.DEFAULT, null);
    public static final Property activeDelay = BInterstartDelayMaster.newProperty((int)3, (boolean)false, null);
    public static final Property delayTime = BInterstartDelayMaster.newProperty((int)3, (BValue)BRelTime.DEFAULT, null);
    public static final Property delayStartTime = BInterstartDelayMaster.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property numObjectsWaiting = BInterstartDelayMaster.newProperty((int)3, (int)0, null);
    public static final Action delayTimerExpired = BInterstartDelayMaster.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BInterstartDelayMaster.class);
    long activeDelayEndTime = 0L;
    int activeDelayTime = 0;
    Vector<BComponent> waitList = new Vector();

    public BOrd getSlaveLink() {
        return (BOrd)this.get(slaveLink);
    }

    public void setSlaveLink(BOrd v) {
        this.set(slaveLink, (BValue)v, null);
    }

    public BRelTime getDefaultDelay() {
        return (BRelTime)this.get(defaultDelay);
    }

    public void setDefaultDelay(BRelTime v) {
        this.set(defaultDelay, (BValue)v, null);
    }

    public boolean getActiveDelay() {
        return this.getBoolean(activeDelay);
    }

    public void setActiveDelay(boolean v) {
        this.setBoolean(activeDelay, v, null);
    }

    public BRelTime getDelayTime() {
        return (BRelTime)this.get(delayTime);
    }

    public void setDelayTime(BRelTime v) {
        this.set(delayTime, (BValue)v, null);
    }

    public BAbsTime getDelayStartTime() {
        return (BAbsTime)this.get(delayStartTime);
    }

    public void setDelayStartTime(BAbsTime v) {
        this.set(delayStartTime, (BValue)v, null);
    }

    public int getNumObjectsWaiting() {
        return this.getInt(numObjectsWaiting);
    }

    public void setNumObjectsWaiting(int v) {
        this.setInt(numObjectsWaiting, v, null);
    }

    public void delayTimerExpired() {
        this.invoke(delayTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.setSlaveLink(this.getAbsoluteOrd());
    }

    public boolean checkInterstartDelay(BComponent output, BRelTime delayTime) {
        if (!this.getActiveDelay()) {
            long dtime = delayTime.getMillis();
            if (dtime == 0L) {
                dtime = this.getDefaultDelay().getMillis();
            }
            if (dtime == 0L) {
                return true;
            }
            this.activeDelayEndTime = Clock.ticks() + dtime;
            this.setDelayStartTime(Clock.time());
            this.setActiveDelay(true);
            this.setDelayTime(BRelTime.make((long)dtime));
            Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)dtime), (Action)delayTimerExpired, null);
            return true;
        }
        if (!this.waitList.contains(output)) {
            this.waitList.addElement(output);
            this.setNumObjectsWaiting(this.waitList.size());
        }
        return false;
    }

    public void doDelayTimerExpired() {
        System.out.println("*************** doDelayTimeExpired");
        this.setDelayStartTime(BAbsTime.DEFAULT);
        this.setActiveDelay(false);
        if (!this.waitList.isEmpty()) {
            BControlPoint next = (BControlPoint)this.waitList.elementAt(0);
            this.waitList.removeElementAt(0);
            next.execute();
        }
        this.setNumObjectsWaiting(this.waitList.size());
    }
}

