/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import com.tridium.kitControl.enums.BAlarmCountEnum;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAlarmCountToRelay
extends BComponent {
    public static final Property alarmCount = BAlarmCountToRelay.newProperty((int)1026, (int)0, null);
    public static final Property relayOut = BAlarmCountToRelay.newProperty((int)3, (BValue)new BStatusBoolean(), null);
    public static final Property timer = BAlarmCountToRelay.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property alarmCountType = BAlarmCountToRelay.newProperty((int)0, (BValue)BAlarmCountEnum.anyCount, null);
    public static final Action relayOutStop = BAlarmCountToRelay.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BAlarmCountToRelay.class);
    private Clock.Ticket relayStopTicket;
    private int totalAlarmCount = 0;

    public int getAlarmCount() {
        return this.getInt(alarmCount);
    }

    public void setAlarmCount(int v) {
        this.setInt(alarmCount, v, null);
    }

    public BStatusBoolean getRelayOut() {
        return (BStatusBoolean)this.get(relayOut);
    }

    public void setRelayOut(BStatusBoolean v) {
        this.set(relayOut, (BValue)v, null);
    }

    public BRelTime getTimer() {
        return (BRelTime)this.get(timer);
    }

    public void setTimer(BRelTime v) {
        this.set(timer, (BValue)v, null);
    }

    public BAlarmCountEnum getAlarmCountType() {
        return (BAlarmCountEnum)this.get(alarmCountType);
    }

    public void setAlarmCountType(BAlarmCountEnum v) {
        this.set(alarmCountType, (BValue)v, null);
    }

    public void relayOutStop() {
        this.invoke(relayOutStop, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.inputChange();
    }

    private int checkActive() {
        int total = 0;
        BLink[] links = this.getLinks((Slot)alarmCount);
        for (int i = 0; i < links.length; ++i) {
            BComponent alarmClass;
            BInteger alarmCount;
            if (!links[i].isActive() || (alarmCount = (BInteger)(alarmClass = links[i].getSourceComponent()).get(links[i].getSourceSlot().asProperty())).getInt() <= 0) continue;
            total += alarmCount.getInt();
        }
        return total;
    }

    protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        LinkCheck superCheck = super.doCheckLink(source, sourceSlot, targetSlot, cx);
        if (!superCheck.isValid() || this.getAlarmCountType().equals((Object)BAlarmCountEnum.anyCount)) {
            return superCheck;
        }
        if (!sourceSlot.getName().equals(this.getAlarmCountType().getTag())) {
            return LinkCheck.makeInvalid((String)"sourceSlot does not match AlarmCountType");
        }
        return LinkCheck.makeValid();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(alarmCount)) {
            this.inputChange();
        } else if (p.equals(timer)) {
            this.totalAlarmCount = 0;
            this.inputChange();
        } else if (p.equals(alarmCountType)) {
            if (!this.getAlarmCountType().equals((Object)BAlarmCountEnum.anyCount)) {
                BLink[] links = this.getLinks((Slot)alarmCount);
                for (int i = 0; i < links.length; ++i) {
                    links[i].deactivate();
                    links[i].setSourceSlotName(this.getAlarmCountType().getTag());
                    links[i].activate();
                }
            }
            this.totalAlarmCount = 0;
            this.inputChange();
        }
    }

    private void inputChange() {
        int active = this.checkActive();
        if (this.getTimer().equals((Object)BRelTime.DEFAULT)) {
            this.getRelayOut().setValue(active > 0);
        } else {
            if (active > this.totalAlarmCount) {
                this.turnOnRelay();
            } else {
                this.turnOffRelay();
            }
            this.totalAlarmCount = active;
        }
    }

    private void turnOffRelay() {
        this.getRelayOut().setValue(false);
        if (this.relayStopTicket != null) {
            this.relayStopTicket.cancel();
            this.relayStopTicket = null;
        }
    }

    private void turnOnRelay() {
        this.getRelayOut().setValue(true);
        this.relayStopTicket = Clock.schedule((BComponent)this, (BRelTime)this.getTimer(), (Action)relayOutStop, null);
    }

    public void doRelayOutStop() {
        this.getRelayOut().setValue(false);
        this.relayStopTicket = null;
    }
}

