/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.provisioningNiagara;

import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import javax.baja.agent.AgentList;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkJobStage;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.provisioningNiagara.BForEachStationStage;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNiagaraNetworkJob
extends BDeviceNetworkJob {
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkJob.class);
    private static final BOrd NIAGARA_NETWORK_ORD = BOrd.make((String)"service:niagaraDriver:NiagaraNetwork");

    public Type getType() {
        return TYPE;
    }

    public BNiagaraNetworkJob() {
        super(NIAGARA_NETWORK_ORD);
    }

    public BNiagaraNetworkJob(String stationName) {
        super(NIAGARA_NETWORK_ORD);
        this.setDevicesToProcess(BValueList.make((BValue)BString.make((String)stationName)));
    }

    public BNiagaraNetworkJob(String[] stationNames) {
        super(NIAGARA_NETWORK_ORD);
        BString[] nameObjects = new BString[stationNames.length];
        for (int i = 0; i < nameObjects.length; ++i) {
            nameObjects[i] = BString.make((String)stationNames[i]);
        }
        this.setDevicesToProcess(BValueList.make((BValue[])nameObjects));
    }

    public BatchJobOp makeOp(Context cx) {
        return new NiagaraNetworkJobOp(cx);
    }

    public void addStep(BNetworkJobStep step) {
        this.getInitialStage().addStep((BJobStep)step);
    }

    public void addStep(BDeviceJobStep step) {
        this.getForEachStationStage().addStep((BJobStep)step);
    }

    public BJobState getStationState(String stationName) {
        return this.getForEachStationStage().getDeviceState((BSimple)BString.make((String)stationName));
    }

    public BNetworkJobStage getInitialStage() {
        this.initStages();
        return (BNetworkJobStage)this.getStage("initial");
    }

    public BForEachStationStage getForEachStationStage() {
        this.initStages();
        return (BForEachStationStage)this.getStage("forEachStation");
    }

    public void setStationState(String stationName, BJobState value) {
        this.getForEachStationStage().setDeviceState((BSimple)BString.make((String)stationName), value);
    }

    protected void initStages() {
        if (this.getStage("initial") == null) {
            this.addStage((BJobStage)new BNetworkJobStage("initial"));
            this.addStage((BJobStage)new BForEachStationStage());
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList result = super.getAgents(cx);
        result.remove("batchJob:DeviceNetworkJobView");
        return result;
    }
}

