/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class OutputSettingsCommand
extends Command {
    private BStationProxy station;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public OutputSettingsCommand(BWidget owner) {
        super(owner, lex, "ProvisioningStationDirector.command.outputSettings");
    }

    public void loadStation(BStationProxy station) {
        this.station = station;
        this.checkEnabled();
    }

    public void checkEnabled() {
        this.setEnabled(this.station.getStationStatus() != BStationStatus.unknown);
    }

    public CommandArtifact doInvoke() {
        try {
            BGridPane grid = new BGridPane(2);
            BIntegerFE logBufferSizeFE = new BIntegerFE();
            logBufferSizeFE.loadValue((BObject)BInteger.make((int)this.station.getLogBufferSize()));
            BIntegerFE logBufferFileSizeFE = new BIntegerFE();
            logBufferFileSizeFE.loadValue((BObject)BInteger.make((int)this.station.getLogBufferFileSize()));
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platDaemon", (String)"ProvisioningStationDirector.command.outputSettings.logBufferSize"), (BWidget)logBufferSizeFE);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platDaemon", (String)"ProvisioningStationDirector.command.outputSettings.logBufferFileSize"), (BWidget)logBufferFileSizeFE);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("ProvisioningStationDirector.command.outputSettings.dlgTitle"), (Object)grid, (int)3)) {
                this.station.set(BStationProxy.logBufferSize, (BValue)((BInteger)logBufferSizeFE.saveValue()));
                this.station.set(BStationProxy.logBufferFileSize, (BValue)((BInteger)logBufferFileSizeFE.saveValue()));
                this.station.updateLogBufferSize();
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
        return null;
    }
}

