/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.ui.util.BInputStreamPane;
import com.tridium.provisioningNiagara.station.BStationProxy;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStationProxyOutputPane
extends BInputStreamPane {
    public static final Type TYPE = Sys.loadType(BStationProxyOutputPane.class);
    private BStationProxy station = null;
    private boolean updatesOnly = false;
    private FilePath capturePath = null;
    private Writer captureWriter = null;

    public Type getType() {
        return TYPE;
    }

    public BStationProxyOutputPane() {
        this.setBufferTime(-1);
    }

    public BStationProxyOutputPane(int rows, int cols) {
        super(rows, cols);
        this.setBufferTime(-1);
    }

    public BStationProxyOutputPane(int rows, int cols, boolean updatesOnly) {
        super(rows, cols);
        this.setBufferTime(-1);
        this.updatesOnly = updatesOnly;
    }

    protected InputStream getInputStream() {
        try {
            return this.station.getStationOutput(true, this.updatesOnly);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void loadStation(BStationProxy value) {
        BStationProxy oldStation = this.station;
        this.station = value;
        if (oldStation != this.station) {
            this.load();
        }
    }

    public void setCapturePath(FilePath value) {
        this.capturePath = value;
    }

    protected synchronized void startUpdates(BInputStreamPane.OutputWatcher value) {
        if (this.capturePath != null) {
            try {
                this.captureWriter = new BufferedWriter(new OutputStreamWriter(BFileSystem.INSTANCE.makeFile(this.capturePath).getOutputStream()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.startUpdates(value);
    }

    public void append(String text) {
        super.append(text);
        if (this.captureWriter != null) {
            try {
                this.captureWriter.write(text);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.captureWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.captureWriter = null;
            }
        }
    }

    public synchronized void stopUpdates() {
        super.stopUpdates();
        try {
            Thread.sleep(BStationSurrogate.getStreamTimeoutMillis() + 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.captureWriter != null) {
            try {
                this.captureWriter.flush();
                this.captureWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.captureWriter = null;
        }
    }

    public BStationProxy getStation() {
        return this.station;
    }
}

