/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.provisioningNiagara.station.BStationProxy;
import com.tridium.provisioningNiagara.ui.station.BStationProxyOutputPane;
import com.tridium.provisioningNiagara.ui.station.ClearOutputCommand;
import com.tridium.provisioningNiagara.ui.station.DumpThreadCommand;
import com.tridium.provisioningNiagara.ui.station.KillCommand;
import com.tridium.provisioningNiagara.ui.station.OutputDialogCommand;
import com.tridium.provisioningNiagara.ui.station.PauseOutputCommand;
import com.tridium.provisioningNiagara.ui.station.RebootCommand;
import com.tridium.provisioningNiagara.ui.station.RestartCommand;
import com.tridium.provisioningNiagara.ui.station.SaveCommand;
import com.tridium.provisioningNiagara.ui.station.StartCommand;
import com.tridium.provisioningNiagara.ui.station.StopCommand;
import com.tridium.provisioningNiagara.ui.station.StreamOutputCommand;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import javax.baja.gx.BInsets;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BProvisioningStationDirector
extends BWbComponentView {
    public static final Action markStartFieldDirty = BProvisioningStationDirector.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BProvisioningStationDirector.class);
    private BStationProxyOutputPane outputPane;
    private StartCommand startCommand;
    private StopCommand stopCommand;
    private RestartCommand restartCommand;
    private RebootCommand rebootCommand;
    private KillCommand killCommand;
    private ClearOutputCommand clearOutputCommand;
    private DumpThreadCommand dumpThreadCommand;
    private OutputDialogCommand outputDialogCommand;
    private StreamOutputCommand streamCommand;
    private PauseOutputCommand pauseOutputCommand;
    private SaveCommand saveCommand;
    private BLabel nameLabel;
    private BLabel statusLabel;
    private BCheckBox autoStartCheckBox;
    private BCheckBox autoRestartCheckBox;
    private BButtonPane buttons;
    private BWidget downContent;
    private BWidget upContent;
    private boolean startFieldDirty = false;
    public static BIcon ICON = BIcon.std((String)"computer.png");

    public void markStartFieldDirty() {
        this.invoke(markStartFieldDirty, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProvisioningStationDirector() {
        this.autoRegisterForComponentEvents = false;
        BScrollPane scroll = new BScrollPane();
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BEdgePane contentPane = new BEdgePane();
        DaemonSessionTaskHandler taskListener = new DaemonSessionTaskHandler((BWidget)this);
        this.outputPane = new BStationProxyOutputPane(1, 1);
        contentPane.setCenter((BWidget)this.outputPane);
        this.setTransferWidget((BTransferWidget)this.outputPane.getEditor());
        BGridPane rightPane = new BGridPane(1);
        rightPane.setValign(BValign.top);
        rightPane.setColumnAlign(BHalign.fill);
        rightPane.setRowGap(4.0);
        this.startCommand = new StartCommand((BWidget)this, this.outputPane);
        BButton button = new BButton((Command)this.startCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.stopCommand = new StopCommand((BWidget)this, (DaemonSessionTaskListener)taskListener);
        button = new BButton((Command)this.stopCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.restartCommand = new RestartCommand((BWidget)this, this.outputPane);
        button = new BButton((Command)this.restartCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.rebootCommand = new RebootCommand((BWidget)this);
        button = new BButton((Command)this.rebootCommand, true, false);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.killCommand = new KillCommand((BWidget)this, (DaemonSessionTaskListener)taskListener);
        button = new BButton((Command)this.killCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.dumpThreadCommand = new DumpThreadCommand((BWidget)this);
        button = new BButton((Command)this.dumpThreadCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.saveCommand = new SaveCommand((BWidget)this, (DaemonSessionTaskListener)taskListener);
        button = new BButton((Command)this.saveCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        rightPane.add(null, (BValue)new BBox(0.0, 10.0));
        this.clearOutputCommand = new ClearOutputCommand((BWidget)this, this.outputPane);
        button = new BButton((Command)this.clearOutputCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        button = new BToggleButton();
        rightPane.add(null, (BValue)button);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)button, this.outputPane);
        button.setCommand((Command)this.pauseOutputCommand, true, false);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.outputDialogCommand = new OutputDialogCommand((BWidget)this);
        button = new BButton((Command)this.outputDialogCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.streamCommand = new StreamOutputCommand((BWidget)this);
        button = new BButton((Command)this.streamCommand);
        rightPane.add(null, (BValue)button);
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        rightPane.add(null, (BValue)new BBox(0.0, 10.0));
        button.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        rightPane.computePreferredSize();
        contentPane.setRight((BWidget)new BBorderPane((BWidget)rightPane, 0.0, 0.0, 0.0, 3.0));
        scroll.setContent((BWidget)contentPane);
        BGridPane upperPane = new BGridPane(2);
        upperPane.setHalign(BHalign.left);
        this.nameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"provisioningNiagara", (String)"ProvisioningStationDirector.station.label"), (BWidget)this.nameLabel);
        this.statusLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"provisioningNiagara", (String)"ProvisioningStationDirector.status.label"), (BWidget)this.statusLabel);
        this.autoStartCheckBox = new BCheckBox(this.getLexicon().getText("ProvisioningStationDirector.autoStart.checkBox"));
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"provisioningNiagara", (String)"ProvisioningStationDirector.autoStart.label"), (BWidget)this.autoStartCheckBox);
        this.autoRestartCheckBox = new BCheckBox(this.getLexicon().getText("ProvisioningStationDirector.autoRestart.checkBox"));
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"provisioningNiagara", (String)"ProvisioningStationDirector.autoRestart.label"), (BWidget)this.autoRestartCheckBox);
        this.linkTo(null, (BComponent)this.autoStartCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)markStartFieldDirty);
        this.linkTo(null, (BComponent)this.autoStartCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)markStartFieldDirty);
        this.buttons = new BButtonPane();
        this.upContent = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)upperPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.buttons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)scroll), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        this.downContent = new BLabel(this.getLexicon().getText("ProvisioningStationDirector.proxyDown"));
        this.setContent(this.downContent);
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        try {
            BStationProxy station = (BStationProxy)value;
            this.registerForComponentEvents((BComponent)station, 1);
            this.buttons.removeAll();
            this.buttons.addWorkbenchButtons((BWidget)this);
            this.startCommand.loadStation(station);
            this.stopCommand.loadStation(station);
            this.restartCommand.loadStation(station);
            this.rebootCommand.loadStation(station);
            this.killCommand.loadStation(station);
            this.dumpThreadCommand.loadStation(station);
            this.outputDialogCommand.loadStation(station);
            this.streamCommand.loadStation(station);
            this.saveCommand.loadStation(station);
            this.nameLabel.setText(station.getStationDisplayName());
            this.statusLabel.setText(station.getStationStatus().toString());
            this.autoStartCheckBox.setSelected(station.getIsAutoStart());
            this.autoRestartCheckBox.setSelected(station.getIsAutoRestart());
            this.outputPane.loadStation(station);
            this.checkEnabledStates();
            this.checkContent();
            this.startFieldDirty = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void checkContent() {
        BStationProxy station = (BStationProxy)this.getCurrentValue();
        if (station.isDown() || station.isFault() || station.isDisabled() || station.getStationStatus() == BStationStatus.unknown) {
            this.setContent(this.downContent);
        } else {
            this.setContent(this.upContent);
        }
    }

    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        BStationProxy station = (BStationProxy)value;
        if (this.startFieldDirty) {
            station.setIsAutoStart(this.autoStartCheckBox.isSelected());
            station.setIsAutoRestart(this.autoRestartCheckBox.isSelected());
            station.updateStartSettings();
            this.startFieldDirty = false;
        }
        return station;
    }

    public void deactivated() {
        super.deactivated();
        this.outputPane.deactivated();
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (this.isModifiedStateLocked()) {
            return;
        }
        if (evt.getSourceComponent() instanceof BStationProxy && evt.getId() == 0) {
            if (evt.getSlot() == BStationProxy.isAutoStart) {
                this.lockModifiedState();
                this.autoStartCheckBox.setSelected(((BBoolean)evt.getValue()).getBoolean());
                this.unlockModifiedState();
            } else if (evt.getSlot() == BStationProxy.isAutoRestart) {
                this.lockModifiedState();
                this.autoRestartCheckBox.setSelected(((BBoolean)evt.getValue()).getBoolean());
                this.unlockModifiedState();
            } else if (evt.getSlot() == BStationProxy.status) {
                this.checkContent();
            } else if (evt.getSlot() == BStationProxy.stationStatus) {
                this.statusLabel.setText(evt.getValue().toString());
                this.checkContent();
            }
            this.checkEnabledStates();
        }
    }

    private void checkEnabledStates() {
        this.startCommand.checkEnabled();
        this.stopCommand.checkEnabled();
        this.restartCommand.checkEnabled();
        this.rebootCommand.checkEnabled();
        this.killCommand.checkEnabled();
        this.dumpThreadCommand.checkEnabled();
        this.outputDialogCommand.checkEnabled();
        this.streamCommand.checkEnabled();
        this.saveCommand.checkEnabled();
        this.clearOutputCommand.checkEnabled();
        this.pauseOutputCommand.checkEnabled();
        this.autoStartCheckBox.setEnabled(this.outputPane.getStation().getStationStatus() != BStationStatus.unknown);
        this.autoRestartCheckBox.setEnabled(this.outputPane.getStation().getStationStatus() != BStationStatus.unknown);
    }

    public void doMarkStartFieldDirty() {
        if (!this.isModifiedStateLocked()) {
            this.startFieldDirty = true;
            this.invoke(setModified, null, null);
        }
    }

    public BIcon getIcon() {
        return ICON;
    }
}

