/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.part.BPart;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BInstallBySpecStep;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableRow;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.baja.batchJob.BValueList;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class StationSoftwareStatusTable {
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final int STATUS_NO_SNAPSHOT = -1;
    private static final int STATUS_UNOPERATIONAL = -2;
    private static final int COL_STATION = 0;
    private static final int COL_DATE = 1;
    private static final int COL_VERSION = 2;
    private static final int COL_STATUS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(BWbView view, BProvisioningNiagaraNetworkExt prov, BInstallable installable, DaemonSessionTaskListener listener) throws Exception {
        BSpace space = BOrd.toSpace((BObject)prov);
        if (installable == null || installable.getPart() == null) {
            return;
        }
        BIDataTable data = (BIDataTable)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork|bql:select slotPath from niagaraDriver:NiagaraStation stop").get((BObject)prov);
        Column slotPathCol = data.getColumns().get(0);
        ArrayList<StationStatusRow> rows = new ArrayList<StationStatusRow>();
        BLabel checkingLabel = new BLabel(lex.getText("SoftwareContainerTree.checking.dlgTitle"));
        checkingLabel.setHalign(BHalign.left);
        checkingLabel.setValign(BValign.center);
        Cancel cancel = new Cancel((BWidget)view);
        BCommandDialog dlg = BCommandDialog.make((BWidget)view, (String)lex.getText("SoftwareContainerTree.checking.dlgTitle"), (boolean)false, (Object)new BEdgePane(null, (BWidget)new BBox(200.0, 0.0), null, null, (BWidget)checkingLabel), (DialogCommand[])new DialogCommand[]{cancel}, (BImage)BImage.make((String)"module://icons/x32/clock.png"));
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        try {
            TableCursor c = data.cursor();
            while (c.next()) {
                if (cancel.isCanceled) {
                    return;
                }
                BNiagaraStation ns = (BNiagaraStation)BOrd.make((String)c.cell(slotPathCol).toString()).get((BObject)space);
                ns.lease(1);
                BSoftwareStationExt ext = (BSoftwareStationExt)ns.getMixIn(BSoftwareStationExt.TYPE);
                checkingLabel.setText(lex.getText("SoftwareContainerTree.checking.dlgMessage", new Object[]{ext.getNiagaraStation().getDisplayName(null)}));
                if (!ext.getEnabled()) continue;
                StationStatusRow row = new StationStatusRow(ext, installable);
                rows.add(row);
            }
        }
        finally {
            dlg.close();
        }
        CommandBindings bindings = new CommandBindings();
        StationStatusModel model = new StationStatusModel(rows);
        bindings.setSupport((CommandBindings.Support)new CommandSupport(model));
        BCommandBoundTable table = new BCommandBoundTable((TableModel)model, new CommandBindings.TableController(bindings));
        Close close = new Close((BWidget)view);
        bindings.addCommand((Command)close, BCommandEnablePolicy.anySelection);
        SelectOutOfDateCommand selectOod = new SelectOutOfDateCommand((BWidget)view, model);
        SnapshotCommand snapshot = new SnapshotCommand((BWidget)view, model, listener);
        bindings.addCommand((Command)snapshot, BCommandEnablePolicy.anySelection);
        table.setSelection((TableSelection)new CommandBindings.TableSelection(bindings));
        table.setCellRenderer((TableCellRenderer)new StationStatusCellRenderer(model));
        BBrush bgcolor = Theme.scrollPane().getControlBackground();
        BScrollPane scrollpane = new BScrollPane((BWidget)table);
        scrollpane.setViewportBackground(bgcolor);
        scrollpane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        if (1 == BCommandDialog.open((BWidget)view, (String)installable.toString(), (Object)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBox(550.0, 0.0), (BWidget)new BBox(0.0, 250.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)scrollpane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{selectOod, snapshot, close, DialogCommand.makeCancel((BWidget)view)})) {
            int[] sel = table.getSelection().getRows();
            StringBuilder query = new StringBuilder("provisioningNiagara:NiagaraNetworkJobBuilder?");
            if (sel.length > 0) {
                BValueList stationIds = null;
                for (int aSel : sel) {
                    stationIds = stationIds == null ? BValueList.make((BValue)BString.make((String)model.getRow(aSel).getStationName())) : BValueList.add((BValueList)stationIds, (BValue)BString.make((String)model.getRow(aSel).getStationName()));
                }
                query.append("stations=");
                query.append(ViewQueryParameter.encode(stationIds));
                query.append(';');
            }
            query.append("steps=");
            query.append(ViewQueryParameter.encode((BIEncodable)new BInstallBySpecStep(BInstallableSpec.make((BInstallable)installable))));
            BOrd ord = BOrd.make((BOrd)prov.getNavOrd(), (OrdQuery)new ViewQuery(query.toString()));
            BWbShell shell = BWbShell.getWbShell((BWidget)view);
            shell.hyperlink(ord);
        }
        model.cleanup();
    }

    private static class SnapshotCommand
    extends DialogCommand
    implements Runnable {
        public StationStatusModel model;
        public DaemonSessionTaskListener listener;

        public SnapshotCommand(BWidget owner, StationStatusModel model, DaemonSessionTaskListener listener) {
            super(owner, -1, lex.getText("SoftwareContainerTree.stationStatus.snapshot"), null, null, null);
            this.model = model;
            this.listener = listener;
        }

        public CommandArtifact doInvoke() throws Exception {
            new Thread(this).start();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setEnabled(false);
            try {
                int[] rows = this.model.getSelection().getRows();
                DaemonSessionTask task = new DaemonSessionTask(lex, "SoftwareContainerTree.stationStatus.snapshot.taskTitle", "");
                this.listener.taskStarted(task);
                try {
                    for (int row : rows) {
                        task.setMessage(lex.getText("SoftwareContainerTree.stationStatus.snapshot.taskMessage", new Object[]{this.model.getRow(row).getStationDisplayName()}));
                        this.listener.taskUpdated(task);
                        this.model.getRow(row).updateSnapshot();
                    }
                    this.model.updateTable();
                }
                finally {
                    this.listener.taskFinished(task);
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    private static class SelectOutOfDateCommand
    extends DialogCommand {
        public StationStatusModel model;

        public SelectOutOfDateCommand(BWidget owner, StationStatusModel model) {
            super(owner, -1, lex.getText("SoftwareContainerTree.stationStatus.selectOod"), null, null, null);
            this.model = model;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.model.getSelection().deselectAll();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                if (this.model.getStatusAt(i) != 3 && this.model.getStatusAt(i) != 4) continue;
                this.model.getSelection().select(i);
            }
            return null;
        }
    }

    private static class StationStatusModel
    extends TableModel
    implements SortableTableUtil.Model {
        private int sortColumn = 3;
        private boolean sortAscending = true;
        private boolean needsSort = false;
        private List<StationStatusRow> rows;

        public StationStatusModel(List<StationStatusRow> rows) {
            this.rows = rows;
            for (StationStatusRow row : rows) {
                row.setModel(this);
            }
            this.sortValues((Comparator<SortableTableUtil.SortableRow>)new SortableTableUtil.OriginalOrderComparator((SortableTableUtil.Model)this));
        }

        public void cleanup() {
            for (StationStatusRow row : this.rows) {
                row.cleanup();
            }
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("SoftwareContainerTree.stationStatus.station");
                }
                case 1: {
                    return lex.getText("SoftwareContainerTree.stationStatus.date");
                }
                case 2: {
                    return lex.getText("SoftwareContainerTree.stationStatus.version");
                }
                case 3: {
                    return lex.getText("SoftwareContainerTree.stationStatus.status");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getRow(row).getStationDisplayName();
                }
                case 1: {
                    return this.getRow(row).getExtension().getLastUpdate();
                }
                case 2: {
                    return this.getRow(row).getCurrentVersion();
                }
                case 3: {
                    return this.getRow(row).getComment();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getStatusAt(int row) {
            return this.getRow(row).getStatus();
        }

        public SortableTableUtil.SortableRow getSortableRow(int row) {
            return this.getRow(row);
        }

        public StationStatusRow getRow(int row) {
            return this.rows.get(row);
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (!this.needsSort && col == this.sortColumn && ascending == this.sortAscending) {
                return;
            }
            this.sortColumn = col;
            this.sortAscending = ascending;
            this.sortValues(null);
        }

        protected void sortValues(Comparator<SortableTableUtil.SortableRow> override) {
            this.needsSort = false;
            this.rows = new ArrayList<StationStatusRow>(this.rows);
            this.rows.sort((Comparator<StationStatusRow>)new SortableTableUtil.RowComparator((SortableTableUtil.Model)this, override));
            if (this.getTable() != null) {
                this.getTable().getSelection().deselectAll();
                this.updateTable(true);
            }
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }
    }

    private static class StationStatusCellRenderer
    extends TableCellRenderer {
        private StationStatusModel model;

        public StationStatusCellRenderer(StationStatusModel model) {
            this.model = model;
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            int status = this.model.getStatusAt(cell.row);
            if (cell.column == 3) {
                switch (status) {
                    case -1: 
                    case 6: {
                        return BColor.blue.toBrush();
                    }
                    case -2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        return BColor.red.toBrush();
                    }
                }
            }
            return super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            int status = this.model.getStatusAt(cell.row);
            if (cell.column == 3) {
                switch (status) {
                    case -2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        return BColor.red.toBrush();
                    }
                }
            }
            return super.getSelectionForeground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String s = this.getCellText(cell);
            return Theme.table().getCellFont().width(s) + 12.0;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            this.paintCellBackground(g, cell);
            double x = 2.0;
            String s = this.getCellText(cell);
            BFont font = Theme.table().getCellFont();
            switch (this.model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    x = cell.width - 2.0 - font.width(s);
                    break;
                }
                case 1: {
                    x = (cell.width - font.width(s)) / 2.0;
                }
            }
            g.setFont(font);
            g.drawString(s, x, font.getAscent() + 2.0);
        }
    }

    private static class StationStatusRow
    extends Subscriber
    implements SortableTableUtil.SortableRow {
        private BSoftwareStationExt softwareExt;
        private BInstallable installable;
        private TableModel model = null;
        private BDaemonPlatform snapshot = null;

        public StationStatusRow(BSoftwareStationExt softwareExt, BInstallable installable) {
            this.softwareExt = softwareExt;
            this.installable = installable;
            this.subscribe((BComponent)softwareExt, Integer.MAX_VALUE);
            if (!softwareExt.getLastUpdate().isNull()) {
                this.snapshot = softwareExt.getPlatformSnapshot();
            }
        }

        public void cleanup() {
            this.unsubscribeAll();
        }

        public void event(BComponentEvent event) {
            if (this.model != null) {
                this.model.updateTable();
            }
        }

        public String getStationName() {
            return this.getStation().getStationName();
        }

        public String getStationDisplayName() {
            return this.getStation().getDisplayName(null);
        }

        public BNiagaraStation getStation() {
            return this.softwareExt.getNiagaraStation();
        }

        public BSoftwareStationExt getExtension() {
            return this.softwareExt;
        }

        public String getCurrentVersion() {
            BPart currentPart = this.getCurrentPart();
            return currentPart == null ? lex.getText("SoftwareContainerTree.stationStatus.none") : currentPart.getVersion().toString();
        }

        public String getComment() {
            int status = this.getStatus();
            if (status == -2) {
                return lex.getText("SoftwareContainerTree.stationStatus.unoperational", new Object[]{this.getExtension().getStatus()});
            }
            if (status == -1) {
                return lex.getText("SoftwareContainerTree.stationStatus.unknown");
            }
            return SoftwareTableRow.statusToComment(status);
        }

        public Object getRowId() {
            return this.getStationName();
        }

        public int compareToRowForColumn(SortableTableUtil.SortableRow sRow, int columnId) {
            StationStatusRow row = (StationStatusRow)sRow;
            switch (columnId) {
                case 0: {
                    return TextUtil.toLowerCase((String)this.getStationDisplayName()).compareTo(TextUtil.toLowerCase((String)row.getStationDisplayName()));
                }
                case 3: {
                    return this.compareComment(row);
                }
                case 1: {
                    return this.getExtension().getLastUpdate().compareTo((Object)row.getExtension().getLastUpdate());
                }
                case 2: {
                    if (this.getCurrentPart() == null) {
                        if (row.getCurrentPart() == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (row.getCurrentPart() == null) {
                        return 1;
                    }
                    return this.getCurrentPart().getVersion().compareTo((Object)row.getCurrentPart().getVersion());
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getStatus() {
            if (this.getExtension().isUnoperational()) {
                return -2;
            }
            if (this.getExtension().getLastUpdate().isNull()) {
                return -1;
            }
            return SoftwareTableRow.getStatus(this.installable, this.getCurrentPart());
        }

        public void updateSnapshot() throws Exception {
            this.softwareExt.invokeSync(BSoftwareStationExt.takeSnapshotWithNotify, null, null);
            this.snapshot = this.getExtension().getPlatformSnapshot();
            if (this.model != null) {
                this.model.updateTable();
            }
        }

        public BPart getCurrentPart() {
            return this.snapshot == null ? null : this.snapshot.getPart(this.installable.getPart());
        }

        public int compareComment(StationStatusRow row) {
            int statusRank2;
            int statusRank1 = SoftwareTableRow.getStatusRank(this.getStatus());
            if (statusRank1 < (statusRank2 = SoftwareTableRow.getStatusRank(row.getStatus()))) {
                return -1;
            }
            if (statusRank1 > statusRank2) {
                return 1;
            }
            return TextUtil.toLowerCase((String)this.getComment()).compareTo(TextUtil.toLowerCase((String)row.getComment()));
        }

        public void setModel(TableModel value) {
            this.model = value;
        }
    }

    private static class Cancel
    extends DialogCommand {
        public boolean isCanceled = false;

        public Cancel(BWidget owner) {
            super(owner, 2, UiLexicon.bajaui().getText("dialog.cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            this.isCanceled = true;
            return null;
        }
    }

    private static class Close
    extends DialogCommand {
        public Close(BWidget owner) {
            super(owner, 1, lex.getText("SoftwareContainerTree.stationStatus.buildJob"), null, null, null);
        }
    }

    private static class CommandSupport
    implements CommandBindings.Support {
        private StationStatusModel model;

        public CommandSupport(StationStatusModel model) {
            this.model = model;
        }

        public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
            if (bindingBasedState && (command instanceof SnapshotCommand || command instanceof Close)) {
                for (int r : this.model.getSelection().getRows()) {
                    if (this.model.getRow(r).getStatus() != -2) continue;
                    command.setEnabled(false);
                    return;
                }
            }
            command.setEnabled(bindingBasedState);
        }
    }
}

