/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.SortableTableUtil;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.software.ProvisioningRegistry;
import com.tridium.provisioningNiagara.ui.software.BStationSoftwareFilter;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableRow;
import java.security.AccessController;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class SoftwareTableModel
extends TableModel {
    private long elapsed = 0L;
    public static final Version VERSION_4 = new Version("4.0");
    public static final int NAME_COL = 0;
    public static final int CURRENT_VER_COL = 1;
    public static final int AVAIL_VER_COL = 2;
    public static final int COMMENT_COL = 3;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_LATER = 1;
    public static final int STATUS_SAME = 2;
    public static final int STATUS_EARLIER = 3;
    public static final int STATUS_DIFFERENT = 4;
    public static final int STATUS_EQUIVALENT = 5;
    public static final int STATUS_NOT_INSTALLED = 6;
    public static final int STATUS_BAD_INSTALLABLE = 7;
    public static final int STATUS_BAD_TARGET = 8;
    public static final int STATUS_BOTH_BAD = 9;
    public static final int STATUS_NO_DETAILS = 10;
    public static final int STATUS_NO_LOCAL = 11;
    public static final int STATUS_EARLIER_COMMISSION = 12;
    public static final int STATUS_NOT_INSTALLED_COMMISSION = 13;
    private static int[] cols = new int[]{0, 1, 2, 3};
    private int sortColumn = 3;
    private boolean sortAscending = true;
    private boolean needsSort = true;
    protected InstallScenario scenario;
    protected InstallScenario oodScenario;
    private Map<PartSpec, SoftwareTableRow> rowsByPartSpec;
    protected ArrayList<SoftwareTableRow> rows;
    private BSoftwareStationExt stationExt;
    private BStationSoftwareFilter filter = null;
    private DaemonSessionTaskListener taskListener;
    private CertificateChainValidator certValidator;
    private Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final Comparator<SoftwareTableRow> COMMENT_COLUMN_COMPARATOR = (row1, row2) -> row1.compareComment((SoftwareTableRow)row2);
    private static final BImage SECURITY_HIGH = BImage.make((String)"module://icons/x16/security-high.png");
    private static final BImage SECURITY_MEDIUM = BImage.make((String)"module://icons/x16/security-medium.png");
    private static final BImage SECURITY_LOW = BImage.make((String)"module://icons/x16/security-low.png");
    private static final BImage UNKNOWN = BImage.make((String)"module://icons/x16/questionMark.png");

    public SoftwareTableModel() {
        this.rowsByPartSpec = new TreeMap<PartSpec, SoftwareTableRow>();
        this.rows = new ArrayList();
    }

    public BPartInstallStatus getInstallStatusAt(int row) {
        return this.getRow(row).getInstallStatus();
    }

    public BImage getCellIcon(int row, int col) {
        SoftwareTableRow instRow = this.getRow(row);
        int signingStatus = 0;
        if (col == 1) {
            signingStatus = instRow.getCurrentSigningStatus();
        } else if (col == 2) {
            signingStatus = instRow.getInstallableSigningStatus();
        }
        switch (signingStatus) {
            case 4: {
                return SECURITY_HIGH;
            }
            case 3: {
                return SECURITY_MEDIUM;
            }
            case 2: {
                return SECURITY_LOW;
            }
            case 1: {
                return UNKNOWN;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (cols[col]) {
            case 0: {
                return this.lex.getText("StationSoftwareView.column.partName");
            }
            case 1: {
                return this.lex.getText("StationSoftwareView.column.currentVersion");
            }
            case 2: {
                return this.lex.getText("StationSoftwareView.column.availableVersion");
            }
            case 3: {
                return "";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BPart getCurrentPartFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        return row == null ? null : row.getCurrentPart();
    }

    public int indexOf(PartSpec spec) {
        SoftwareTableRow row = this.getRow(spec);
        if (row == null) {
            return -1;
        }
        return this.rows.indexOf(row);
    }

    public BPart getCurrentPartAt(int row) {
        return this.getRow(row).getCurrentPart();
    }

    public BVersion getCurrentVersionAt(int row) {
        return this.getRow(row).getCurrentVersion();
    }

    public BVersion getCurrentVersionFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        return row == null ? null : row.getCurrentVersion();
    }

    public List<BDependency> getForwardDependenciesAt(int row) {
        return this.getRow(row).getForwardDeps();
    }

    public List<BDependency> getForwardDependenciesFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        return row == null ? new ArrayList() : row.getForwardDeps();
    }

    public BInstallable getInstallableAt(int row) {
        return this.getRow(row).getInstallable();
    }

    public BInstallable getInstallableFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        return row == null ? null : row.getInstallable();
    }

    public BPart getInstallablePartAt(int row) {
        return this.getRow(row).getInstallablePart();
    }

    public BPart getInstallablePartFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        return row == null ? null : row.getInstallablePart();
    }

    public BVersion getInstallableVersionAt(int row) {
        return this.getRow(row).getHighestInstallableVersion();
    }

    public BVersion getInstallableVersionFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        return row == null ? null : row.getInstallableVersion();
    }

    public String getNameAt(int row) {
        return this.getRow(row).getPartName();
    }

    public List<SoftwareTableRow> getReverseDependenciesAt(int row) {
        Map<SoftwareTableRow, BDependency> reverseDeps = this.getRow(row).getReverseDeps();
        return new ArrayList<SoftwareTableRow>(reverseDeps.keySet());
    }

    public List<BPart> getDependentPartsFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        if (row == null) {
            return new ArrayList<BPart>();
        }
        return row.getDependentParts();
    }

    public List<BPart> getDependentPartsAt(int row) {
        return this.getRow(row).getDependentParts();
    }

    public SortableTableUtil.SortableRow getSortableRow(int row) {
        return this.getRow(row);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public BImage getRowIcon(int row) {
        return this.getCellIcon(row, 0);
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getStatusAt(int row) {
        return this.getRow(row).getStatus();
    }

    public int getStatusFor(PartSpec partSpec) {
        SoftwareTableRow row = this.getRow(partSpec);
        if (row == null) {
            return 0;
        }
        return row.getStatus();
    }

    public String getTypeAt(int row) {
        return this.getRow(row).getType();
    }

    public DaemonSessionTaskListener getTaskListener() {
        return this.taskListener;
    }

    public InstallScenario getScenario() {
        return this.scenario;
    }

    public void setScenario(InstallScenario value) {
        if (!value.canCommit()) {
            throw new IllegalArgumentException("Install scenario has unmet dependencies");
        }
        this.scenario = value;
        this.rebuild(false);
    }

    public Object getValueAt(int row, int col) {
        switch (cols[col]) {
            case 0: {
                return this.getRow(row).getPartName();
            }
            case 1: {
                return SoftwareTableModel.nvl(this.getRow(row).getCurrentVersion(), "-");
            }
            case 2: {
                return SoftwareTableModel.nvl(this.getRow(row).getHighestInstallableVersion(), "-");
            }
            case 3: {
                return this.getRow(row).getComment();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public BSoftwareStationExt getStationExt() {
        return this.stationExt;
    }

    public BDaemonPlatform getTargetPlatform() {
        return this.stationExt.getPlatformSnapshot();
    }

    public ProvisioningRegistry getInstallableRegistry() {
        BProvisioningNiagaraNetworkExt prov = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)this.stationExt);
        return prov.getInstallableRegistry();
    }

    public void init(BSoftwareStationExt stationExt, DaemonSessionTaskListener taskListener, boolean sort) throws AuthenticationException {
        try {
            BVector trustStoreSnapshot = stationExt.getPlatformTrustStoreSnapshot();
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            SlotCursor c = trustStoreSnapshot.getProperties();
            while (c.next()) {
                BValue value = c.get();
                if (!(value instanceof BX509Certificate)) continue;
                trustAnchors.add(new TrustAnchor(((BX509Certificate)value).getX509Certificate(), null));
            }
            this.certValidator = new CertificateChainValidator(trustAnchors);
            CoreCryptoManager mgr = AccessController.doPrivileged(() -> CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider()));
            ICoreTrustStore trustStore = mgr.getSystemTrustStore();
            this.certValidator.addTrustAnchors(trustStore);
            this.taskListener = taskListener;
            this.stationExt = stationExt;
            ProvisioningRegistry prov = this.getInstallableRegistry();
            BDaemonPlatform platformSnapshot = stationExt.getPlatformSnapshot();
            this.scenario = new InstallScenario(platformSnapshot, null, null, null, null, null, null, null, new SolutionParameters(taskListener, true, "default"), (InstallableRegistry)prov, this.certValidator);
            this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)prov).solve();
            this.rebuild(sort);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    public boolean isModule(int row) {
        return this.getRow(row).isModule();
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void rebuild() throws AuthenticationException {
        this.rebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean sort) throws AuthenticationException {
        this.rowsByPartSpec = new TreeMap<PartSpec, SoftwareTableRow>();
        BDaemonPlatform platform = this.stationExt.getPlatformSnapshot();
        DaemonSessionTask sessionTask = new DaemonSessionTask(this.lex, "StationSoftwareView.rebuilding", "StationSoftwareView.rebuilding");
        try {
            if (this.taskListener != null) {
                this.taskListener.taskStarted(sessionTask);
            }
            BDaemonSessionView.log.fine("model rebuild: fetched platform " + this.getElapsed());
            platform.getModuleList().init(this.taskListener);
            SlotCursor c = platform.getModuleList().getModules().getProperties();
            while (c.next()) {
                this.addCurrentPart((BPart)((BModuleInstallable)c.get()).getModulePart());
            }
            BDaemonSessionView.log.fine("model rebuild: added remote modules " + this.getElapsed());
            BProvisioningNiagaraNetworkExt prov = (BProvisioningNiagaraNetworkExt)BOrd.make((String)"service:provisioningNiagara:ProvisioningNiagaraNetworkExt").get((BObject)this.stationExt);
            ProvisioningRegistry registry = prov.getInstallableRegistry();
            try {
                BInstallable[] toInstall = this.scenario.getToInstall();
                HashSet<String> installableNames = new HashSet<String>();
                for (BInstallable aToInstall : toInstall) {
                    if (!(aToInstall instanceof BModuleInstallable)) continue;
                    this.addInstallable(aToInstall);
                    installableNames.add(aToInstall.getInstallableName());
                }
                HashMap rejected = new HashMap();
                IterableCursor<BInstallable> c2 = registry.getInstallables(false, this.taskListener, null, "*.dist");
                while (c2.next()) {
                    BInstallable inst = (BInstallable)c2.get();
                    if (!(inst instanceof BModuleInstallable) || inst.getUnmetPlatformDependencies(platform).size() != 0 || !InstallScenario.listModule((InstallScenario)this.scenario, (BModuleInstallable)((BModuleInstallable)inst), rejected)) continue;
                    if (installableNames.contains(inst.getInstallableName())) {
                        this.getRow(inst.getPartSpec()).setLatestAvailableInstallable(inst);
                        continue;
                    }
                    this.addInstallable(inst);
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            BDaemonSessionView.log.fine("model rebuild: added local modules " + this.getElapsed());
            for (PartSpec spec : this.rowsByPartSpec.keySet()) {
                SoftwareTableRow row = this.rowsByPartSpec.get(spec);
                TreeMap<PartSpec, BDependency> resultMap = new TreeMap<PartSpec, BDependency>();
                HashSet<PartSpec> checked = new HashSet<PartSpec>();
                this.checkDependencies(spec, resultMap, checked, null);
                row.setForwardDeps(new ArrayList<BDependency>(resultMap.values()));
            }
            this.updateValues(sort);
        }
        finally {
            if (this.taskListener != null) {
                this.taskListener.taskFinished(sessionTask);
            }
        }
    }

    public void reload() throws Exception {
        this.getTable().getSelection().deselectAll();
        if (this.scenario != null) {
            this.scenario.getTargetPlatform().getModuleList().reload(this.taskListener);
            this.scenario.getTargetPlatform().getDaemonSession().reloadHostProperties();
        }
        this.rebuild();
    }

    public long getSizeDeltaOnCommit() {
        long result = 0L;
        for (int i = 0; i < this.getRowCount(); ++i) {
            result += this.getRow(i).getSizeDeltaOnCommit();
        }
        return result;
    }

    public void resetScenario() {
        try {
            this.scenario = new InstallScenario(this.scenario.getTargetPlatform(), this.taskListener, null, null, null, (InstallableRegistry)this.getInstallableRegistry(), this.certValidator);
            this.updateValues(true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void sortByColumn(int col, boolean ascending) {
        if (!this.needsSort && col == this.sortColumn && ascending == this.sortAscending) {
            return;
        }
        this.sortColumn = col;
        this.sortAscending = ascending;
        this.updateValues(true);
    }

    public void setFilter(BStationSoftwareFilter value) {
        this.filter = value;
        if (this.filter != null) {
            this.updateValues(true);
        }
    }

    public BStationSoftwareFilter getFilter() {
        return this.filter;
    }

    private void addCurrentPart(BPart part) {
        if (part == null || part.isNull()) {
            return;
        }
        SoftwareTableRow row = this.rowsByPartSpec.get(part.getPartSpec());
        if (row == null) {
            row = this.makeRow();
            this.rowsByPartSpec.put(part.getPartSpec(), row);
        }
        row.setCurrentPart(part);
        row.updateRow();
    }

    protected SoftwareTableRow makeRow() {
        return new SoftwareTableRow(this);
    }

    private void checkDependencies(PartSpec spec, Map<PartSpec, BDependency> map, Set<PartSpec> checked, BDependency dep) {
        BPart part;
        if (checked.contains(spec)) {
            return;
        }
        checked.add(spec);
        SoftwareTableRow row = this.rowsByPartSpec.get(spec);
        if (row == null) {
            return;
        }
        if (dep == null) {
            part = row.getInstallablePart() == null ? row.getCurrentPart() : row.getInstallablePart();
        } else {
            part = row.getCurrentPart();
            if (part == null || !part.meets(dep)) {
                part = row.getHighestVersionedPart();
            }
            if (part == null) {
                part = row.getInstallablePart();
            }
        }
        for (BDependency depend : part.getDependencyArray()) {
            BDependency oldDep = map.get(depend.getPartSpec());
            if (oldDep == null) {
                map.put(depend.getPartSpec(), depend);
                this.checkDependencies(depend.getPartSpec(), map, checked, depend);
            } else if (depend.supersedes(oldDep)) {
                map.put(depend.getPartSpec(), depend);
            }
            SoftwareTableRow depRow = this.rowsByPartSpec.get(depend.getPartSpec());
            if (depRow == null) continue;
            depRow.addReverseDep(row, depend);
        }
    }

    private void addInstallable(BInstallable installable) {
        BInstallable old;
        if (installable == null) {
            return;
        }
        SoftwareTableRow row = this.rowsByPartSpec.get(installable.getPart().getPartSpec());
        if (row == null) {
            row = this.makeRow();
            this.rowsByPartSpec.put(installable.getPart().getPartSpec(), row);
        }
        if (this.isUpgrade(installable, old = row.getInstallable())) {
            row.setInstallable(installable);
            row.updateRow();
        }
    }

    private boolean isUpgrade(BInstallable i1, BInstallable i2) {
        if (i1 == null) {
            return false;
        }
        if (i2 == null) {
            return true;
        }
        switch (i2.getVersion().checkVersionRequirement(i1.getVersion())) {
            case 2: {
                if (i2 instanceof BModuleInstallable) {
                    BModulePart m1 = (BModulePart)i1.getPart();
                    BModulePart m2 = (BModulePart)i2.getPart();
                    if (m1.getBuildAbsTime() != null && m2.getBuildAbsTime() != null) {
                        int dateComp = m1.getBuildAbsTime().compareTo((Object)m2.getBuildAbsTime());
                        if (dateComp > 0) {
                            return true;
                        }
                        if (dateComp < 0) {
                            return false;
                        }
                    }
                }
                return false;
            }
            case 8: 
            case 16: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected SoftwareTableRow getRow(int row) {
        return this.rows.get(row);
    }

    protected SoftwareTableRow getRow(PartSpec spec) {
        return this.rowsByPartSpec.get(spec);
    }

    private static String nvl(Object objectIn, String forNull) {
        return objectIn == null ? forNull : objectIn.toString();
    }

    protected void updateValues(boolean resort) {
        OriginalOrderComparator originalOrder = new OriginalOrderComparator(this.rows);
        this.needsSort = false;
        this.rows = new ArrayList<SoftwareTableRow>(this.rowsByPartSpec.values());
        if (resort) {
            this.rows.sort(new SoftwareTableRowComparator());
        } else {
            this.rows.sort(originalOrder);
        }
        if (this.filter != null && this.filter.getIsEnabled()) {
            ArrayList newList = new ArrayList();
            this.rows.forEach(row -> {
                if (this.filter.accept(row)) {
                    newList.add(row);
                }
            });
            this.rows = newList;
        }
        this.getTable().getSelection().deselectAll();
        this.updateTable(true);
    }

    public void updateTable(boolean resizeColumns) {
        this.needsSort = true;
        for (SoftwareTableRow row : this.rows) {
            row.updateRow();
        }
        super.updateTable(resizeColumns);
    }

    private String getElapsed() {
        long prior = this.elapsed;
        this.elapsed = Clock.ticks();
        return prior == 0L ? "" : this.elapsed - prior + " ms";
    }

    public ModuleVerificationMode getModuleVerificationMode() {
        return this.scenario.getVerificationMode();
    }

    public CertificateChainValidator getCertValidator() {
        return this.certValidator;
    }

    private class SoftwareTableRowComparator
    implements Comparator<SoftwareTableRow> {
        private List<Comparator<SoftwareTableRow>> comparators;

        public SoftwareTableRowComparator() {
            int i;
            int[] sortColumns = new int[4];
            sortColumns[0] = SoftwareTableModel.this.sortColumn;
            int next = 1;
            for (i = 0; i < sortColumns.length; ++i) {
                if (i == SoftwareTableModel.this.sortColumn) continue;
                sortColumns[next++] = i;
            }
            this.comparators = new ArrayList<Comparator<SoftwareTableRow>>();
            for (i = 0; i < 4; ++i) {
                this.comparators.add(new SoftwareColumnComparator(sortColumns[i], SoftwareTableModel.this.sortAscending));
            }
        }

        @Override
        public int compare(SoftwareTableRow o1, SoftwareTableRow o2) {
            int result = 0;
            for (Comparator<SoftwareTableRow> comparator : this.comparators) {
                result = comparator.compare(o1, o2);
            }
            return result;
        }
    }

    protected class OriginalOrderComparator
    implements Comparator<SoftwareTableRow> {
        Map<String, Integer> sequenceMapByPartName = new HashMap<String, Integer>();

        public OriginalOrderComparator(List<SoftwareTableRow> pRows) {
            if (pRows != null) {
                for (int i = 0; i < pRows.size(); ++i) {
                    this.sequenceMapByPartName.put(pRows.get(i).getInstallableName(), i);
                }
            }
        }

        @Override
        public int compare(SoftwareTableRow r1, SoftwareTableRow r2) {
            Integer s1 = this.sequenceMapByPartName.get(r1.getInstallableName());
            Integer s2 = this.sequenceMapByPartName.get(r2.getInstallableName());
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    private static class SoftwareColumnComparator
    implements Comparator<SoftwareTableRow> {
        private int comparatorSortColumn;
        private boolean comparatorAscending;

        public SoftwareColumnComparator(int comparatorSortColumn, boolean comparatorAscending) {
            this.comparatorSortColumn = comparatorSortColumn;
            this.comparatorAscending = comparatorAscending;
        }

        @Override
        public int compare(SoftwareTableRow row1, SoftwareTableRow row2) {
            int sortDirection = this.comparatorAscending ? 1 : -1;
            switch (this.comparatorSortColumn) {
                case 3: {
                    return sortDirection * COMMENT_COLUMN_COMPARATOR.compare(row1, row2);
                }
                case 0: {
                    if (row1.getInstallableName() == null) {
                        if (row2.getInstallableName() == null) {
                            return 0;
                        }
                        return sortDirection;
                    }
                    if (row2.getInstallableName() == null) {
                        return sortDirection * -1;
                    }
                    return sortDirection * TextUtil.toLowerCase((String)row1.getInstallableName()).compareTo(TextUtil.toLowerCase((String)row2.getInstallableName()));
                }
                case 1: {
                    if (row1.getCurrentPart() == null) {
                        if (row2.getCurrentPart() == null) {
                            return 0;
                        }
                        return -1 * sortDirection;
                    }
                    if (row2.getCurrentPart() == null) {
                        return sortDirection;
                    }
                    return sortDirection * row1.getCurrentPart().getVersion().compareTo((Object)row2.getCurrentPart().getVersion());
                }
                case 2: {
                    if (row1.getInstallable() == null) {
                        if (row2.getInstallable() == null) {
                            return 0;
                        }
                        return -1 * sortDirection;
                    }
                    if (row2.getInstallable() == null) {
                        return sortDirection;
                    }
                    return sortDirection * row1.getInstallable().getVersion().compareTo((Object)row2.getInstallable().getVersion());
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

