/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.software.InstallCommand;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class InstallVersionCommand
extends AsyncCommand {
    public static Lexicon LEXICON = Lexicon.make((String)"provisioningNiagara");
    protected SoftwareTableModel tableModel;
    protected BInstallable installable;

    public InstallVersionCommand(SoftwareTableModel tableModel, BInstallable installable) {
        super((BWidget)tableModel.getTable(), LEXICON.getText("StationSoftwareView.status.install", new Object[]{installable.getVersion()}), null, null, null);
        this.tableModel = tableModel;
        this.installable = installable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        try {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                boolean raiseDialogs = true;
                if (shell != null) {
                    shell.enterBusy();
                }
                TreeMap<PartSpec, BInstallable> initialInstallablesByPartSpec = new TreeMap<PartSpec, BInstallable>();
                for (BInstallable anInst : this.tableModel.getScenario().getToInstall()) {
                    initialInstallablesByPartSpec.put(anInst.getPart().getPartSpec(), anInst);
                }
                initialInstallablesByPartSpec.put(this.installable.getPart().getPartSpec(), this.installable);
                BInstallable[] inst = new BInstallable[initialInstallablesByPartSpec.size()];
                initialInstallablesByPartSpec.values().toArray(inst);
                SolutionParameters parms = this.tableModel.getScenario().getSolutionParameters().newCopy();
                parms.latestOnly = false;
                InstallScenario solution = InstallScenario.solve((BDaemonPlatform)this.tableModel.getScenario().getTargetPlatform(), (String[])this.tableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])inst, (SolutionParameters)parms, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)this.tableModel.getCertValidator());
                Map failed = solution.getSignatureFailures();
                if (!failed.isEmpty()) {
                    if (raiseDialogs) {
                        BDialog.error((BWidget)this.getOwner(), (String)LEXICON.getText("InstallCommand.signingError.title"), (Object)com.tridium.platDaemon.ui.softwaremanager.InstallCommand.makeSigningErrorDialog((Map)failed, (ModuleVerificationMode)this.tableModel.getModuleVerificationMode()));
                    }
                } else if (solution.getExcludedInstallables().length > 0) {
                    if (raiseDialogs) {
                        BDialog.error((BWidget)this.getOwner(), (String)LEXICON.getText("InstallCommand.excluded.title"), (Object)LEXICON.getText("InstallCommand.excluded.message"));
                    }
                } else if (solution.getUnmeetableDependencies().length > 0) {
                    boolean anyUnsolvable = false;
                    for (UnmeetableDependency unmeetableDependency : solution.getUnmeetableDependencies()) {
                        if (!unmeetableDependency.isUnsolvable) continue;
                        anyUnsolvable = true;
                    }
                    if (anyUnsolvable) {
                        if (raiseDialogs) {
                            BDialog.error((BWidget)this.getOwner(), (String)LEXICON.getText("InstallCommand.mustCommission.title"), (Object)LEXICON.getText("InstallCommand.mustCommission.message"));
                        } else {
                            solution.getSolutionParameters().latestOnly = true;
                            this.tableModel.setScenario(solution);
                        }
                    } else if (raiseDialogs) {
                        BDialog.error((BWidget)this.getOwner(), (String)LEXICON.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(solution));
                    }
                } else if (raiseDialogs) {
                    boolean signatureWarningConfirmed = false;
                    boolean alsoInstallConfirmed = false;
                    BWidget widget = com.tridium.platDaemon.ui.softwaremanager.InstallCommand.makeSigningWarningDialog((InstallScenario)solution, (InstallScenario)this.tableModel.getScenario(), (CertificateChainValidator)this.tableModel.getCertValidator());
                    boolean bl = signatureWarningConfirmed = widget == null || 1 == BDialog.open((BWidget)this.getOwner(), (String)LEXICON.getText("InstallCommand.signingWarning.title"), (Object)widget, (int)3, (BImage)BDialog.WARNING_ICON, (String)null);
                    if (signatureWarningConfirmed) {
                        widget = InstallCommand.makeAlsoInstallDialog(initialInstallablesByPartSpec, solution);
                        boolean bl2 = alsoInstallConfirmed = widget == null || 1 == BDialog.confirm((BWidget)this.getOwner(), (String)LEXICON.getText("InstallCommand.alsoInstall.title"), (Object)widget, (int)3);
                    }
                    if (signatureWarningConfirmed && alsoInstallConfirmed) {
                        solution.getSolutionParameters().latestOnly = true;
                        this.tableModel.setScenario(solution);
                    }
                } else {
                    solution.getSolutionParameters().latestOnly = true;
                    this.tableModel.setScenario(solution);
                }
            }
            finally {
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
    }
}

