/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.DependencyMap;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.ui.software.SoftwareTableModel;
import com.tridium.ui.theme.Theme;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class CancelInstallCommand
extends AsyncCommand {
    private SoftwareTableModel tableModel;
    private static Lexicon lex = Lexicon.make((String)"provisioningNiagara");

    public static CancelInstallCommand makeCancelInstall(BWidget owner, SoftwareTableModel tableModel) {
        return new CancelInstallCommand(owner, tableModel, "StationSoftwareView.command.cancelInstallSelected");
    }

    public static CancelInstallCommand makeCancelReinstall(BWidget owner, SoftwareTableModel tableModel) {
        return new CancelInstallCommand(owner, tableModel, "StationSoftwareView.command.cancelReinstallSelected");
    }

    public static CancelInstallCommand makeCancelUpgrade(BWidget owner, SoftwareTableModel tableModel) {
        return new CancelInstallCommand(owner, tableModel, "StationSoftwareView.command.cancelUpgradeSelected");
    }

    public static CancelInstallCommand makeCancelDowngrade(BWidget owner, SoftwareTableModel tableModel) {
        return new CancelInstallCommand(owner, tableModel, "StationSoftwareView.command.cancelDowngradeSelected");
    }

    protected CancelInstallCommand(BWidget owner, SoftwareTableModel tableModel, String lexKey) {
        super(owner, lex, lexKey);
        this.tableModel = tableModel;
    }

    public static void cancelInstall(BWidget owner, SoftwareTableModel tableModel, int[] rows) {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        try {
            if (shell != null) {
                shell.enterBusy();
            }
            BInstallable[] instPre = tableModel.getScenario().getToInstall();
            DependencyMap deps = new DependencyMap();
            TreeMap<PartSpec, BInstallable> instByPartSpec = new TreeMap<PartSpec, BInstallable>();
            for (BInstallable anInstPre : instPre) {
                BDependency[] instDeps;
                instByPartSpec.put(anInstPre.getPartSpec(), anInstPre);
                for (BDependency instDep : instDeps = anInstPre.getAllDependencies()) {
                    deps.addDependency(anInstPre.getPartSpec(), instDep);
                }
            }
            TreeSet<PartSpec> allCancels = new TreeSet<PartSpec>();
            TreeSet<PartSpec> newCancels = new TreeSet<PartSpec>();
            for (int row : rows) {
                allCancels.add(tableModel.getInstallableAt(row).getPartSpec());
            }
            for (int row : rows) {
                BPart part = tableModel.getInstallableAt(row).getPart();
                if (part == null) continue;
                CancelInstallCommand.cascadeDepCancels(deps, part, tableModel.getScenario().getTargetPlatform(), allCancels, newCancels, instByPartSpec);
            }
            if (newCancels.size() == 0 || 1 == BDialog.confirm((BWidget)owner, (String)lex.getText("CancelInstallCommand.alsoCancel.title"), (Object)CancelInstallCommand.makeAlsoCancelDetailsPane(newCancels, instByPartSpec), (int)3)) {
                BInstallable[] instPost = new BInstallable[instPre.length - allCancels.size()];
                int ixPost = 0;
                for (BInstallable anInstPre : instPre) {
                    if (allCancels.contains(anInstPre.getPartSpec())) continue;
                    instPost[ixPost++] = anInstPre;
                }
                tableModel.setScenario(InstallScenario.solve((BDaemonPlatform)tableModel.getScenario().getTargetPlatform(), null, (String[])tableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])instPost, null, (InstallableRegistry)tableModel.getInstallableRegistry(), (CertificateChainValidator)tableModel.getCertValidator()));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    public void doInvokeAsync() {
        try {
            CancelInstallCommand.cancelInstall(this.getOwner(), this.tableModel, this.tableModel.getTable().getSelection().getRows());
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
    }

    private static void cascadeDepCancels(DependencyMap deps, BPart part, BDaemonPlatform platform, Set<PartSpec> allCancels, Set<PartSpec> newCancels, Map<PartSpec, BInstallable> instByPartSpec) {
        if (part == null) {
            return;
        }
        Map partDeps = deps.getDependenciesOn(part);
        if (partDeps == null) {
            return;
        }
        partDeps.keySet().stream().filter(instSpec -> !allCancels.contains(instSpec)).forEach(instSpec -> {
            BDependency dep = (BDependency)partDeps.get(instSpec);
            if (!platform.meets(dep)) {
                allCancels.add((PartSpec)instSpec);
                newCancels.add((PartSpec)instSpec);
                BPart instPart = ((BInstallable)instByPartSpec.get(instSpec)).getPart();
                CancelInstallCommand.cascadeDepCancels(deps, instPart, platform, allCancels, newCancels, instByPartSpec);
            }
        });
    }

    private static BWidget makeAlsoCancelDetailsPane(Set<PartSpec> alsoCancelSpecs, Map<PartSpec, BInstallable> instByPartSpec) {
        BIndentPane pane = new BIndentPane();
        pane.add(LexiconText.make((String)"provisioningNiagara", (String)"CancelInstallCommand.alsoCancel.heading"));
        pane.indent();
        for (PartSpec alsoCancelSpec : alsoCancelSpecs) {
            pane.add(instByPartSpec.get(alsoCancelSpec).getInstallableFileName());
        }
        pane.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)pane, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        cpane.setFixedSize(275.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)cpane);
    }
}

