/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.software;

import com.tridium.provisioningNiagara.software.BExportApplicationTemplateConfigJobStep;
import com.tridium.workbench.shell.BPasswordField;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BExportApplicationTemplateConfigDialog
extends BDialog {
    public static final Action okButtonPressed = BExportApplicationTemplateConfigDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BExportApplicationTemplateConfigDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BExportApplicationTemplateConfigDialog.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private BButton okButton;
    private BButton cancelButton;
    private BPasswordField configPassword;
    private BPasswordField confirmPassword;
    private BCheckBox alwatsEncryptCheckBox;
    private BExportApplicationTemplateConfigJobStep result;

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BExportApplicationTemplateConfigDialog(BWidget owner) {
        super(owner, lex.getText("ExportApplicationTemplateConfigDialog.title"), true);
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BExportApplicationTemplateConfigJobStep show(BWidget owner) {
        BExportApplicationTemplateConfigDialog dialog = new BExportApplicationTemplateConfigDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(null, lex.getText("ExportApplicationTemplateConfigDialog.title"), lex.get("ExportApplicationTemplateConfigDialog.description"));
    }

    private BWidget buildContent() {
        this.configPassword = new BPasswordField();
        this.confirmPassword = new BPasswordField();
        this.alwatsEncryptCheckBox = new BCheckBox("");
        this.alwatsEncryptCheckBox.setSelected(false);
        BGridPane editorPane = new BGridPane(2);
        editorPane.add(null, (BValue)new BLabel(lex.getText("ExportApplicationTemplateConfigDialog.enter")));
        editorPane.add(null, (BValue)this.configPassword);
        editorPane.add(null, (BValue)new BLabel(lex.getText("ExportApplicationTemplateConfigDialog.confirm")));
        editorPane.add(null, (BValue)this.confirmPassword);
        editorPane.add(null, (BValue)new BLabel(lex.get("ExportApplicationTemplateConfigDialog.alwaysEncrypt")));
        editorPane.add(null, (BValue)this.alwatsEncryptCheckBox);
        BGridPane content = new BGridPane(1);
        content.add(null, (BValue)editorPane);
        return new BBorderPane((BWidget)content, 7.0, 7.0, 0.0, 7.0);
    }

    private BWidget buildButtonPane() {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        boolean isEmpty = this.configPassword.getPassword().validate("");
        boolean match = this.configPassword.getPassword().validate(this.confirmPassword.getPassword());
        boolean alwaysEncryptSelected = this.alwatsEncryptCheckBox.getSelected();
        boolean isStrong = false;
        if (!isEmpty) {
            try {
                AtomicReference messageRef = new AtomicReference();
                isStrong = BPasswordStrength.DEFAULT.isPasswordValid(this.configPassword.getPassword().getValue().toCharArray(), messageRef::set);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!match) {
            BDialog.error((BWidget)this, (Object)lex.getText("ExportApplicationTemplateConfigDialog.passwordMismatch"));
            return;
        }
        if (isEmpty && alwaysEncryptSelected) {
            BDialog.error((BWidget)this, (Object)lex.getText("ExportApplicationTemplateConfigDialog.passwordRequired"));
            return;
        }
        if (!(isEmpty && !alwaysEncryptSelected || isStrong)) {
            BDialog.error((BWidget)this, (Object)lex.getText("ExportApplicationTemplateConfigDialog.passwordWeak"));
            return;
        }
        this.result = new BExportApplicationTemplateConfigJobStep(this.configPassword.getPassword(), this.alwatsEncryptCheckBox.getSelected());
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public BExportApplicationTemplateConfigJobStep getResult() {
        return this.result;
    }
}

