/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.program;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.provisioningNiagara.program.BInstallCertificateJobStep;
import com.tridium.provisioningNiagara.program.BInstallCertificatePolicyEnum;
import com.tridium.provisioningNiagara.ui.program.BInstallCertTable;
import com.tridium.ui.util.LabelUtil;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="selectionModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BInstallCertificateStepDialog
extends BDialog {
    public static final Action okButtonPressed = BInstallCertificateStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BInstallCertificateStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action selectionModified = BInstallCertificateStepDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BInstallCertificateStepDialog.class);
    public static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private BInstallCertTable table;
    private BButton okButton;
    private BButton cancelButton;
    private ICoreCryptoManager ccm;
    private BInstallCertificateJobStep result;
    private BRadioButton installUnique;
    private BRadioButton replace;
    private BRadioButton dontInstall;

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void selectionModified(BWidgetEvent parameter) {
        this.invoke(selectionModified, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInstallCertificateStepDialog(BWidget owner, ICoreCryptoManager ccm) throws Exception {
        super(owner, lex.getText("InstallCertificateStepDialog.title"), true);
        this.ccm = ccm;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BInstallCertificateJobStep show(BWidget owner, ICoreCryptoManager ccm) throws Exception {
        BInstallCertificateStepDialog dialog = new BInstallCertificateStepDialog(owner, ccm);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() throws Exception {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() {
        try {
            return new BWizardHeader(null, lex.getText("InstallCertificateStepDialog.title"), lex.get("InstallCertificateStepDialog.description"));
        }
        catch (Exception e) {
            System.out.println("build header");
            e.printStackTrace();
            throw e;
        }
    }

    private BWidget buildContent() throws Exception {
        this.table = new BInstallCertTable(this.ccm, this.ccm.getUserTrustStore());
        this.table.load();
        this.table.setMultipleSelection(false);
        BGridPane usagegrid = new BGridPane(3);
        ToggleCommandGroup group = new ToggleCommandGroup();
        this.installUnique = new BRadioButton(group, lex.getText("InstallCertificateStepDialog.installUnique"), true);
        this.replace = new BRadioButton(group, lex.getText("InstallCertificateStepDialog.replace"), false);
        this.dontInstall = new BRadioButton(group, lex.getText("InstallCertificateStepDialog.dontInstall"), false);
        usagegrid.add(null, (BValue)this.installUnique);
        usagegrid.add(null, (BValue)this.replace);
        usagegrid.add(null, (BValue)this.dontInstall);
        BFlowPane header = new BFlowPane(BHalign.left);
        header.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"InstallCertificateStepDialog.label.certificates"), (boolean)true));
        BEdgePane layoutPane = new BEdgePane((BWidget)new BBorderPane((BWidget)header, 6.0, 0.0, 0.0, 4.0), null, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT), BInsets.make((double)0.0, (double)4.0, (double)0.0, (double)4.0)));
        return new BEdgePane((BWidget)layoutPane, (BWidget)usagegrid, null, null, (BWidget)new BLabel(lex.getText("InstallCertificateStepDialog.ifAliasExists")));
    }

    private BWidget buildButtonPane() throws Exception {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton.setEnabled(this.table.getSelection().getRows().length > 0);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.linkTo("linkC", (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selectionModified);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        int policy = this.installUnique.getSelected() ? 0 : (this.replace.getSelected() ? 1 : (this.dontInstall.getSelected() ? 2 : 0));
        this.result = new BInstallCertificateJobStep(this.table.getSelectedAlias(), BInstallCertificatePolicyEnum.make(policy));
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    public void doSelectionModified(BWidgetEvent event) throws Exception {
        this.okButton.setEnabled(this.table.getSelection().getRows().length > 0);
    }

    public BInstallCertificateJobStep getResult() {
        return this.result;
    }
}

