/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.provisioningNiagara.license.BSupervisorLicenses;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BSupervisorLicenseTree
extends BTree {
    public static final Action handleSelectionModified = BSupervisorLicenseTree.newAction((int)0, null);
    public static final Topic valueUpdated = BSupervisorLicenseTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BSupervisorLicenseTree.class);
    private static final BIcon HOST_ICON = BIcon.std((String)"host.png");
    private static final BIcon LICENSE_ICON = BIcon.std((String)"file.png");
    private static final IFileFilter LAR_FILTER = new ExtFileFilter("TODO", "lar");
    private static final IFilePathFilter LAR_PATH_FILTER = new ExtPathFilter("lar");
    private static final IFileFilter LICENSE_FILTER = new ExtFileFilter("TODO", "license,lar");
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private Command importFile = new ImportFile();
    private Command exportFile = new ExportFile();
    private Command delete = new Delete();
    private SyncOnline syncOnline = new SyncOnline();

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public void fireValueUpdated(BValue event) {
        this.fire(valueUpdated, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSupervisorLicenseTree() {
        this.setModel(new Model());
        this.setMultipleSelection(true);
        this.linkTo(null, (BComponent)this, (Slot)BTree.selectionModified, (Slot)handleSelectionModified);
    }

    public String getDetailsText() throws Exception {
        TreeNode[] selected = this.getSelection().getNodes();
        if (selected.length == 1 && selected[0] instanceof LicenseNode) {
            return ((LicenseNode)selected[0]).getContents();
        }
        return "";
    }

    public void importLicenseArchive(BLicenseArchiveFile file, Context cx) throws Exception {
        this.getSupervisorLicenses().importLicenseFile((BIFile)file);
        this.reload();
        BDialog.message((BWidget)this, (Object)LEX.getText("SupervisorLicenseTree.importFile.success"));
    }

    public void load(BSupervisorLicenses value, Context cx) throws Exception {
        ((Model)this.getModel()).load(value, cx);
    }

    public void reload() throws Exception {
        ((Model)this.getModel()).reload();
    }

    public Command[] getCommands() {
        return new Command[]{this.importFile, this.exportFile, this.delete, this.syncOnline};
    }

    public BSupervisorLicenses getSupervisorLicenses() {
        return ((Model)this.getModel()).getSupervisorLicenses();
    }

    public int dragOver(TransferContext cx) {
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            for (BObject value : mark.getValues()) {
                if (!(value instanceof BLicenseFile) && !(value instanceof BLicenseArchiveFile)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            boolean anyImported = false;
            for (BObject value : mark.getValues()) {
                if (!(value instanceof BLicenseFile) && !(value instanceof BLicenseArchiveFile)) continue;
                this.getSupervisorLicenses().importLicenseFile((BIFile)value);
                anyImported = true;
            }
            if (anyImported) {
                this.reload();
                BDialog.message((BWidget)this, (Object)LEX.getText("SupervisorLicenseTree.importFile.success"));
            }
        }
        return null;
    }

    public void doHandleSelectionModified() {
        TreeNode[] selected = this.getSelection().getNodes();
        this.delete.setEnabled(selected.length > 0);
        this.fireValueUpdated(null);
    }

    private String[] getSelectedHostIds() {
        HashSet<String> hostIdSet = new HashSet<String>();
        for (TreeNode node : this.getSelection().getNodes()) {
            if (node instanceof HostNode) {
                hostIdSet.add(((HostNode)node).getHostId());
                continue;
            }
            hostIdSet.add(((LicenseNode)node).getHostId());
        }
        String[] result = new String[hostIdSet.size()];
        hostIdSet.toArray(result);
        return result;
    }

    private class SyncOnline
    extends AsyncCommand {
        public boolean canceled;

        public SyncOnline() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.syncOnline.label"), null, null, LEX.getText("SupervisorLicenseTree.syncOnline.description"));
            this.canceled = false;
        }

        public void doInvokeAsync() {
            AccessController.doPrivileged(() -> {
                this.doInvokeAsyncPrivileged();
                return null;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsyncPrivileged() {
            block30: {
                try {
                    VendorCertificate[] wbCerts;
                    TreeNode[] selected = BSupervisorLicenseTree.this.getSelection().getNodes();
                    int updatedLicenses = 0;
                    int updatedCerts = 0;
                    ArrayList<VendorCertificate> certUpdates = new ArrayList<VendorCertificate>();
                    HashSet<String> updatedCertVendors = new HashSet<String>();
                    BCertificateSummary[] certSummaries = BSupervisorLicenseTree.this.getSupervisorLicenses().getCertificateSummaries();
                    if (PortalLicenseUtil.requestLicensesOnline()) {
                        for (VendorCertificate portalCert : PortalLicenseUtil.getPortalUpdates((BCertificateSummary[])certSummaries)) {
                            certUpdates.add(portalCert);
                            CertificateDatabase.LOCAL_INSTANCE.add(portalCert);
                            updatedCertVendors.add(portalCert.getVendor());
                        }
                    }
                    for (VendorCertificate wbCert : wbCerts = PortalLicenseUtil.getUpdatedCertificates((BCertificateSummary[])certSummaries, (CertificateDatabase)CertificateDatabase.LOCAL_INSTANCE)) {
                        if (updatedCertVendors.contains(wbCert.getVendor())) continue;
                        certUpdates.add(wbCert);
                    }
                    if (selected.length == 0) {
                        if (4 != BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.syncAll.confirmTitle"), (Object)LEX.getText("SupervisorLicenseTree.syncAll.confirmMessage"))) {
                            return;
                        }
                        this.canceled = false;
                        BLabel progressLabel = new BLabel(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{"0"}));
                        progressLabel.setHalign(BHalign.left);
                        BDialog dialog = new BDialog(this.getOwner(), LEX.getText("SupervisorLicenseTree.syncAll.workingTitle"), false, (BWidget)new BEdgePane((BWidget)new BBox(300.0, 0.0), (BWidget)new BBorderPane((BWidget)new BButtonPane(new Command[]{new CancelSync()}), 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)progressLabel, 10.0, 10.0, 10.0, 10.0)));
                        dialog.setBoundsCenteredOnOwner();
                        dialog.open();
                        try {
                            ArrayList<VendorLicense> pending = new ArrayList<VendorLicense>();
                            Iterator<VendorLicense> licenses = BSupervisorLicenseTree.this.getSupervisorLicenses().licenseIterator();
                            while (licenses.hasNext()) {
                                VendorLicense[] wbLicenses;
                                if (this.canceled) {
                                    pending.clear();
                                    break;
                                }
                                pending.add(licenses.next());
                                if (pending.size() < 100) continue;
                                VendorLicense[] summaries = BEnvLicenseSummary.make((VendorLicense[])pending.toArray(new VendorLicense[pending.size()]));
                                pending.clear();
                                if (PortalLicenseUtil.requestLicensesOnline()) {
                                    for (VendorLicense update : PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])summaries)) {
                                        LicenseDatabase.LOCAL_INSTANCE.add(update);
                                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(update)) continue;
                                        progressLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++updatedLicenses)}));
                                    }
                                }
                                VendorLicense[] vendorLicenseArray = wbLicenses = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])summaries, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
                                int n = vendorLicenseArray.length;
                                for (int update = 0; update < n; ++update) {
                                    VendorLicense wbLicense = vendorLicenseArray[update];
                                    if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(wbLicense)) continue;
                                    progressLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++updatedLicenses)}));
                                }
                            }
                            if (pending.size() > 0) {
                                VendorLicense[] wbLicenses;
                                BEnvLicenseSummary[] summaries = BEnvLicenseSummary.make((VendorLicense[])pending.toArray(new VendorLicense[pending.size()]));
                                pending.clear();
                                if (PortalLicenseUtil.requestLicensesOnline()) {
                                    for (VendorLicense update : PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])summaries)) {
                                        LicenseDatabase.LOCAL_INSTANCE.add(update);
                                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(update)) continue;
                                        progressLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++updatedLicenses)}));
                                    }
                                }
                                for (VendorLicense wbLicense : wbLicenses = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])summaries, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE)) {
                                    if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(wbLicense)) continue;
                                    progressLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.working", new Object[]{String.valueOf(++updatedLicenses)}));
                                }
                            }
                            for (VendorCertificate certUpdate : certUpdates) {
                                if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(certUpdate)) continue;
                                progressLabel.setText(LEX.getText("SupervisorLicenseTree.syncAll.cert.working", new Object[]{String.valueOf(++updatedCerts)}));
                            }
                        }
                        finally {
                            dialog.close();
                        }
                        if (updatedLicenses > 0 || updatedCerts > 0) {
                            BSupervisorLicenseTree.this.reload();
                        }
                        BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("SupervisorLicenseTree.syncOnline.completeTitle"), (Object)new BEdgePane((BWidget)new BBox(300.0, 1.0), null, null, null, (BWidget)new BLabel(LEX.getText("SupervisorLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(updatedLicenses), String.valueOf(updatedCerts)}), BHalign.left)));
                        break block30;
                    }
                    ArrayList<BEnvLicenseSummary> pending = new ArrayList<BEnvLicenseSummary>();
                    for (TreeNode aSelected : selected) {
                        if (aSelected instanceof HostNode) {
                            HostNode hostNode = (HostNode)aSelected;
                            for (LicenseNode kid : hostNode.getChildren()) {
                                pending.add(BEnvLicenseSummary.make((VendorLicense)kid.getVendorLicense()));
                            }
                            continue;
                        }
                        LicenseNode licenseNode = (LicenseNode)aSelected;
                        pending.add(BEnvLicenseSummary.make((VendorLicense)licenseNode.getVendorLicense()));
                    }
                    BEnvLicenseSummary[] summaries = pending.toArray(new BEnvLicenseSummary[pending.size()]);
                    if (PortalLicenseUtil.requestLicensesOnline()) {
                        for (VendorLicense update : PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])summaries)) {
                            LicenseDatabase.LOCAL_INSTANCE.add(update);
                            if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(update)) continue;
                            ++updatedLicenses;
                        }
                    }
                    VendorLicense[] wbLicenses = PortalLicenseUtil.getUpdatedLicenses((BEnvLicenseSummary[])summaries, (LicenseDatabase)LicenseDatabase.LOCAL_INSTANCE);
                    for (VendorLicense wbLicense : wbLicenses) {
                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(wbLicense)) continue;
                        ++updatedLicenses;
                    }
                    for (VendorCertificate certUpdate : certUpdates) {
                        if (!BSupervisorLicenseTree.this.getSupervisorLicenses().add(certUpdate)) continue;
                        ++updatedCerts;
                    }
                    if (updatedLicenses > 0 || updatedCerts > 0) {
                        BSupervisorLicenseTree.this.reload();
                    }
                    BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("SupervisorLicenseTree.syncOnline.completeTitle"), (Object)LEX.getText("SupervisorLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(updatedLicenses), String.valueOf(updatedCerts)}));
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
        }
    }

    private class CancelSync
    extends Command {
        public CancelSync() {
            super((BWidget)BSupervisorLicenseTree.this, UiLexicon.bajaui().getText("cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            ((BSupervisorLicenseTree)BSupervisorLicenseTree.this).syncOnline.canceled = true;
            return null;
        }
    }

    private class Delete
    extends Command {
        public Delete() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.delete.label"), null, null, LEX.getText("SupervisorLicenseTree.delete.description"));
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] selected = BSupervisorLicenseTree.this.getSelection().getNodes();
            if (selected.length > 0 && 4 == BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.delete.confirmTitle"), (Object)LEX.getText("SupervisorLicenseTree.delete.confirmMessage"))) {
                for (TreeNode aSelected : selected) {
                    if (aSelected instanceof HostNode) {
                        for (int ixChild = 0; ixChild < aSelected.getChildCount(); ++ixChild) {
                            BSupervisorLicenseTree.this.getSupervisorLicenses().remove(((LicenseNode)aSelected.getChild(ixChild)).getVendorLicense());
                        }
                        continue;
                    }
                    BSupervisorLicenseTree.this.getSupervisorLicenses().remove(((LicenseNode)aSelected).getVendorLicense());
                }
                BSupervisorLicenseTree.this.getSelection().deselectAll();
                BSupervisorLicenseTree.this.reload();
            }
            return null;
        }
    }

    private class ExportFile
    extends Command {
        public ExportFile() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.exportFile.label"), null, null, LEX.getText("SupervisorLicenseTree.exportFile.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] selected = BSupervisorLicenseTree.this.getSelection().getNodes();
            if (selected.length == 0 && 8 == BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.exportFile.confirmTitle"), (Object)LEX.getText("SupervisorLicenseTree.exportFile.confirmMessage"))) {
                return null;
            }
            BDirectory initialDir = FavoriteDirectory.loadByPath((String)TYPE.toString(), (String)"larDir", null);
            FilePath path = BFileChooserDialog.chooseFilePath((BWidget)BSupervisorLicenseTree.this, null, (String)LEX.getText("SupervisorLicenseTree.exportFile.title"), (String)LEX.getText("SupervisorLicenseTree.exportFile.message"), (BIFile)initialDir, (IFileFilter)LAR_FILTER, (IFilePathFilter)LAR_PATH_FILTER, null, (String)"licenses.lar");
            if (path == null) {
                return null;
            }
            BIFile dest = BFileSystem.INSTANCE.findFile(path);
            if (dest == null) {
                dest = BFileSystem.INSTANCE.makeFile(path);
            } else if (8 == BDialog.confirm((BWidget)BSupervisorLicenseTree.this, (String)LEX.getText("SupervisorLicenseTree.exportFile.replaceTitle"), (Object)LEX.getText("SupervisorLicenseTree.exportFile.replaceMessage", new Object[]{path.getName()}))) {
                return null;
            }
            FavoriteDirectory.savePath((String)TYPE.toString(), (String)"larDir", (BDirectory)((BDirectory)dest.getNavParent()));
            OutputStream out = dest.getOutputStream();
            try {
                if (selected.length == 0) {
                    BSupervisorLicenseTree.this.getSupervisorLicenses().exportLicenses(out);
                } else {
                    BSupervisorLicenseTree.this.getSupervisorLicenses().exportLicenses(BSupervisorLicenseTree.this.getSelectedHostIds(), out);
                }
                BDialog.message((BWidget)BSupervisorLicenseTree.this, (Object)LEX.getText("SupervisorLicenseTree.exportFile.success"));
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }

    private class ImportFile
    extends Command {
        public ImportFile() {
            super((BWidget)BSupervisorLicenseTree.this, LEX.getText("SupervisorLicenseTree.importFile.label"), null, null, LEX.getText("SupervisorLicenseTree.importFile.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BIFile file = BFileChooserDialog.chooseFile((BWidget)BSupervisorLicenseTree.this, null, (String)LEX.getText("SupervisorLicenseTree.importFile.title"), (String)LEX.getText("SupervisorLicenseTree.importFile.message"), (BIFile)FavoriteDirectory.loadByPath((String)TYPE.toString(), (String)"larDir", null), (IFileFilter)LICENSE_FILTER, (IFileFilter)LICENSE_FILTER);
            if (file == null) {
                return null;
            }
            BSupervisorLicenseTree.this.getSupervisorLicenses().importLicenseFile(file);
            BSupervisorLicenseTree.this.reload();
            BDialog.message((BWidget)BSupervisorLicenseTree.this, (Object)LEX.getText("SupervisorLicenseTree.importFile.success"));
            return null;
        }
    }

    private class LicenseNode
    extends TreeNode {
        private VendorLicense vendorLicense;
        private Context cx;

        public LicenseNode(HostNode parent, VendorLicense vendorLicense, Context cx) {
            super((TreeNode)parent);
            this.update(vendorLicense);
            this.cx = cx;
        }

        public String getText() {
            return LicenseInfo.getSummaryText((VendorLicense)this.vendorLicense, (Context)this.cx);
        }

        public boolean update(VendorLicense value) {
            if (this.vendorLicense == null || !value.getSignature().equals(this.vendorLicense.getSignature())) {
                this.vendorLicense = value;
                return true;
            }
            return false;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)LICENSE_ICON);
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public VendorLicense getVendorLicense() {
            return this.vendorLicense;
        }

        public String getHostId() {
            return this.getVendorLicense().getHostId();
        }

        public String getContents() throws Exception {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            this.vendorLicense.save((OutputStream)bytesOut);
            return bytesOut.toString();
        }
    }

    private class HostNode
    extends TreeNode {
        private String hostId;
        private LicenseNode[] children;
        private Context cx;

        public HostNode(TreeModel model, String hostId, Context cx) {
            super(model);
            this.children = null;
            this.hostId = hostId;
            this.cx = cx;
        }

        public String getHostId() {
            return this.hostId;
        }

        public String getText() {
            return this.getHostId();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)HOST_ICON);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeNode getChild(int index) {
            return this.getChildren()[index];
        }

        public synchronized boolean update() throws Exception {
            if (this.children == null) {
                return false;
            }
            TreeMap<String, LicenseNode> childrenByText = new TreeMap<String, LicenseNode>();
            TreeSet<String> textToRemove = new TreeSet<String>();
            boolean anyUpdates = false;
            boolean rebuildArray = false;
            for (LicenseNode licenseNode : this.children) {
                textToRemove.add(licenseNode.getText());
                childrenByText.put(licenseNode.getText(), licenseNode);
            }
            for (LicenseNode licenseNode : this.getSupervisorLicenses().getLicenses(this.hostId)) {
                String text = LicenseInfo.getSummaryText((VendorLicense)licenseNode, (Context)this.cx);
                LicenseNode node = (LicenseNode)((Object)childrenByText.get(text));
                if (node == null) {
                    childrenByText.put(text, new LicenseNode(this, (VendorLicense)licenseNode, this.cx));
                    anyUpdates = true;
                    rebuildArray = true;
                    continue;
                }
                anyUpdates = node.update((VendorLicense)licenseNode) || anyUpdates;
                textToRemove.remove(node.getText());
            }
            for (String text : textToRemove) {
                childrenByText.remove(text);
                rebuildArray = true;
                anyUpdates = true;
            }
            if (rebuildArray) {
                this.children = new LicenseNode[childrenByText.size()];
                childrenByText.values().toArray(this.children);
            }
            return anyUpdates;
        }

        public LicenseNode[] getChildren() {
            try {
                if (this.children == null) {
                    VendorLicense[] licenses = this.getSupervisorLicenses().getLicenses(this.hostId);
                    this.children = new LicenseNode[licenses.length];
                    for (int i = 0; i < licenses.length; ++i) {
                        this.children[i] = new LicenseNode(this, licenses[i], this.cx);
                    }
                }
                return this.children;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public BSupervisorLicenses getSupervisorLicenses() {
            return ((Model)this.getModel()).getSupervisorLicenses();
        }
    }

    private class Model
    extends TreeModel {
        private HostNode[] hostNodes = new HostNode[0];
        private Context cx;
        private BSupervisorLicenses supervisorLicenses = null;

        private Model() {
        }

        public synchronized void load(BSupervisorLicenses value, Context cx) throws Exception {
            this.supervisorLicenses = value;
            this.cx = cx;
            String[] hostIds = this.supervisorLicenses.getLicensedHostIds();
            TreeMap<Object, HostNode> hostNodesByHostId = new TreeMap<Object, HostNode>();
            boolean anyUpdates = false;
            boolean rebuildArray = false;
            TreeSet<String> hostIdsToRemove = new TreeSet<String>();
            for (HostNode hostNode : this.hostNodes) {
                hostNodesByHostId.put(hostNode.getHostId(), hostNode);
                hostIdsToRemove.add(hostNode.getHostId());
            }
            for (HostNode hostNode : hostIds) {
                HostNode node = (HostNode)((Object)hostNodesByHostId.get((Object)hostNode));
                if (node == null) {
                    hostNodesByHostId.put((Object)hostNode, new HostNode(this, (String)((Object)hostNode), cx));
                    rebuildArray = true;
                    continue;
                }
                hostIdsToRemove.remove((Object)hostNode);
                anyUpdates = node.update() || anyUpdates;
            }
            for (String id : hostIdsToRemove) {
                hostNodesByHostId.remove(id);
                rebuildArray = true;
            }
            if (rebuildArray) {
                anyUpdates = true;
                this.hostNodes = new HostNode[hostNodesByHostId.size()];
                hostNodesByHostId.values().toArray(this.hostNodes);
            }
            if (anyUpdates) {
                this.updateTree();
                BSupervisorLicenseTree.this.fireValueUpdated(null);
            }
        }

        public synchronized void reload() throws Exception {
            this.load(this.supervisorLicenses, this.cx);
        }

        public int getRootCount() {
            return this.hostNodes.length;
        }

        public TreeNode getRoot(int index) {
            return this.hostNodes[index];
        }

        public BSupervisorLicenses getSupervisorLicenses() {
            return this.supervisorLicenses;
        }
    }
}

