/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.component;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.provisioningNiagara.BNiagaraNetworkBatchAgent;
import com.tridium.provisioningNiagara.component.BSetPropertyJobStep;
import com.tridium.provisioningNiagara.ui.component.BSetPropertyStepDialog;
import com.tridium.provisioningNiagara.ui.component.BSetPropertyStepEditor;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.List;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BSetPropertyByStationEditor
extends BWbEditor {
    public static final Type TYPE = Sys.loadType(BSetPropertyByStationEditor.class);
    private final BSetPropertyStepEditor parentEditor;
    private BGridPane gridPane;
    private List<String> fieldEditorEntryNames;
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");
    private static final int MULTI_TARGET_EDITOR_WIDTH_BUFFER = 50;
    private static final int MULTI_TARGET_EDITOR_MAX_WIDTH = 600;
    private static final int MULTI_TARGET_EDITOR_HEIGHT = 200;

    public Type getType() {
        return TYPE;
    }

    public BSetPropertyByStationEditor() {
        this(null);
    }

    public BSetPropertyByStationEditor(BSetPropertyStepEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BValue propertyValue = (BValue)value;
        this.fieldEditorEntryNames = new ArrayList<String>();
        this.gridPane = new BGridPane(2);
        this.gridPane.setRowGap(10.0);
        this.gridPane.setColumnGap(10.0);
        this.gridPane.setColorRows(true);
        BSetPropertyStepDialog dialog = (BSetPropertyStepDialog)this.parentEditor.parentDialog;
        BNiagaraNetwork network = dialog.getNetworkExt().getNetwork();
        network.lease(2);
        BDevice[] devices = BNiagaraNetworkBatchAgent.INSTANCE.listBatchDevices((BDeviceNetwork)network);
        if (devices.length == 0) {
            BLabel label = new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), LEX.getText("SetPropertyByStationEditor.noStations"));
            this.setContent((BWidget)label);
            return;
        }
        for (BDevice device : devices) {
            String deviceName = device.getDisplayName(cx);
            this.gridPane.add(null, (BValue)new BLabel(deviceName));
            BWbFieldEditor valueEditor = BWbFieldEditor.makeFor((BObject)propertyValue, (Context)cx);
            valueEditor.loadValue((BObject)propertyValue);
            this.gridPane.add(deviceName, (BValue)valueEditor);
            this.fieldEditorEntryNames.add(deviceName);
        }
        this.gridPane.computePreferredSize();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.gridPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scrollPane);
        cpane.setMaxWidth(600.0);
        cpane.setFixedSize(this.gridPane.getPreferredWidth() + 50.0, 200.0);
        BEdgePane byStationPane = new BEdgePane();
        byStationPane.setTop((BWidget)new BLabel(LEX.getText("SetPropertyByStationEditor.instruction")));
        byStationPane.setCenter((BWidget)cpane);
        this.setContent((BWidget)byStationPane);
    }

    public void loadByStationValues(BSetPropertyJobStep step, Context cx) {
        Property[] byStationProperties = step.getTargetValueList().getDynamicPropertiesArray();
        if (byStationProperties == null || byStationProperties.length > 0) {
            return;
        }
        for (Property p : byStationProperties) {
            String deviceName = p.getName();
            BValue value = step.getTargetValueList().get(deviceName);
            BWbFieldEditor valueEditor = BWbFieldEditor.makeFor((BObject)value, (Context)cx);
            valueEditor.loadValue((BObject)value);
            this.gridPane.add(null, (BValue)new BLabel(deviceName));
            this.gridPane.add(deviceName, (BValue)valueEditor);
        }
    }

    BGridPane getGridPane() {
        return this.gridPane;
    }

    List<String> getFieldEditorEntryNames() {
        return this.fieldEditorEntryNames;
    }
}

