/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.certificate;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platcrypto.ui.BCertificateSelectFE;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BSelfSignedDialog;
import com.tridium.provisioningNiagara.certificate.BSignCertJobStep;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.security.AccessController;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.gx.BInsets;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="dropDownModified")})
public class BSignCertDialog
extends BDialog {
    public static final Action okButtonPressed = BSignCertDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BSignCertDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action dropDownModified = BSignCertDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSignCertDialog.class);
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final Logger LOG = Logger.getLogger("provisioningNiagara");
    private ICoreCryptoManager coreCryptoManager;
    private BTextField serverCertAlias;
    private BCertificateSelectFE certificateSelectFE;
    private BPasswordFE caPasswordEditor;
    private BAbsTimeFE notBeforeFE;
    private BAbsTimeFE notAfterFE;
    private BAbsTime notBefore = BAbsTime.now();
    private BAbsTime notAfter = BAbsTime.now().add(BRelTime.makeDays((int)365));
    private BButton okButton;
    private BSignCertJobStep result;
    private static final String GENERATE_NEW = lex.getText("SignCertDialog.generateNew");
    private static final BInsets INSETS = BInsets.make((double)7.0);

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void dropDownModified() {
        this.invoke(dropDownModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSignCertDialog(BWidget owner) throws Exception {
        super(owner, lex.getText("SignCertDialog.title"), true);
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static BSignCertJobStep show(BWidget owner) throws Exception {
        BSignCertDialog dialog = new BSignCertDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() throws Exception {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildBody());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(null, lex.getText("SignCertDialog.title"), lex.get("SignCertDialog.description"));
    }

    private BWidget buildBody() throws Exception {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        this.serverCertAlias = new BTextField("");
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            throw new BajaException("Widget is not mounted in a shell or the shell isn't an instanceof BWbShell");
        }
        BOrd ord = shell.getActiveOrd();
        BComponent component = (BComponent)ord.get();
        BISession session = component.getSession();
        if (session == null) {
            throw new BajaException("Unable to retrieve session");
        }
        if (!(session instanceof BFoxSession)) {
            throw new BajaException("Fox session not available");
        }
        this.coreCryptoManager = new ChannelCryptoManager(component);
        this.certificateSelectFE = new BCertificateSelectFE(this.coreCryptoManager, BCertificateSelectFE.KeyStoreType.USER_KEYSTORE, KeyPurpose.CA_CERT, BString.make((String)GENERATE_NEW));
        this.certificateSelectFE.doLoadValue(null, null);
        this.linkTo("lk0", (BComponent)this.certificateSelectFE, (Slot)BCertificateSelectFE.setModified, (Slot)dropDownModified);
        this.caPasswordEditor = new BPasswordFE();
        this.caPasswordEditor.setEnabled(false);
        this.notBeforeFE = new BAbsTimeFE(this.notBefore);
        this.notBeforeFE.setEnabled(false);
        this.notAfterFE = new BAbsTimeFE(this.notAfter);
        this.notAfterFE.setEnabled(false);
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.setRowGap(5.0);
        contentGrid.setColumnGap(5.0);
        contentGrid.setColumnAlign(BHalign.left);
        contentGrid.setStretchColumn(1);
        contentGrid.add(null, (BValue)new BLabel(lex.getText("SignCertDialog.serverAlias")));
        contentGrid.add(null, (BValue)this.serverCertAlias);
        contentGrid.add(null, (BValue)new BLabel(lex.getText("SignCertDialog.caAlias")));
        contentGrid.add(null, (BValue)this.certificateSelectFE);
        contentGrid.add(null, (BValue)new BLabel(lex.getText("SignCertDialog.caPasswordEditor")));
        contentGrid.add(null, (BValue)this.caPasswordEditor);
        contentGrid.add(null, (BValue)new BLabel(lex.getText("SignCertDialog.notBefore")));
        contentGrid.add(null, (BValue)this.notBeforeFE);
        contentGrid.add(null, (BValue)new BLabel(lex.getText("SignCertDialog.notAfter")));
        contentGrid.add(null, (BValue)this.notAfterFE);
        contentPane.add(null, (BValue)contentGrid);
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildButtonPane() {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        BButton cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton.setEnabled(true);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)cancelButton);
        return new BBorderPane((BWidget)buttonPane, INSETS);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        BPassword caPassword;
        String alias;
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (this.serverCertAlias.getText().isEmpty()) {
                            BDialog.error((BWidget)this, (Object)lex.getText("SignCertDialog.missingValues"));
                            return;
                        }
                        if (!this.certificateSelectFE.getText().equals(GENERATE_NEW)) break block6;
                        BSelfSignedDialog dialog = new BSelfSignedDialog((BWidget)this, this.coreCryptoManager.getKeyStore());
                        dialog.configureForCAOnly();
                        dialog.setBoundsCenteredOnOwner();
                        dialog.setResizable(false);
                        dialog.setTitle(lex.getText("SignCertDialog.caTitle"));
                        dialog.open();
                        alias = dialog.getAlias();
                        caPassword = dialog.getPassword();
                        BCertsTable.CertGenRequest caCertRequest = dialog.getResult(this.coreCryptoManager);
                        if (caCertRequest == null) {
                            return;
                        }
                        this.checkCertGenerationProgress(caCertRequest);
                        break block7;
                    }
                    alias = this.certificateSelectFE.getText();
                    caPassword = (BPassword)this.caPasswordEditor.saveValue();
                    if (caPassword == null) break block8;
                    if (!AccessController.doPrivileged(() -> ((BPassword)caPassword).getValue()).trim().isEmpty()) break block9;
                }
                BDialog.error((BWidget)this, (Object)lex.getText("SignCertDialog.noPassword"));
                return;
            }
            this.notBefore = (BAbsTime)this.notBeforeFE.saveValue();
            this.notAfter = (BAbsTime)this.notAfterFE.saveValue();
            if (this.notAfter.getMillis() < this.notBefore.getMillis()) {
                BDialog.error((BWidget)this, (Object)lex.getText("SignCertDialog.dateError"));
                return;
            }
        }
        this.result = new BSignCertJobStep(this.serverCertAlias.getText(), alias, caPassword, this.notBefore, this.notAfter);
        this.close();
    }

    private void checkCertGenerationProgress(BCertsTable.CertGenRequest caCertRequest) {
        if (caCertRequest == null) {
            BDialog.error((BWidget)this, (String)lex.getText("SignCertDialog.caGenerationError.title"), (Object)lex.getText("GenerateCertJobStep.failed"));
            return;
        }
        Optional success = BProgressDialog.openIndeterminate((BWidget)this, (String)"Generating CA Cert", dlg -> {
            int status;
            try {
                status = this.coreCryptoManager.getCertGenerationStatus(caCertRequest.getRequestId());
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)lex.getText("SignCertDialog.caGenerationError.title"), (Object)lex.getText("SignCertDialog.caGenerationError.message"));
                return false;
            }
            while (status != 2 && status != -1) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    status = this.coreCryptoManager.getCertGenerationStatus(caCertRequest.getRequestId());
                }
                catch (Exception e) {
                    LOG.warning("Unable to get certificate generation status - " + e.getMessage());
                    break;
                }
            }
            return status == 2;
        });
        if (!success.isPresent() || !((Boolean)success.get()).booleanValue()) {
            BDialog.error((BWidget)this, (String)lex.getText("CertWizard.status.ca.generationError.title"), (Object)lex.getText("CertWizard.status.ca.generationError.message"));
        }
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.close();
    }

    public void doDropDownModified() {
        boolean generate = this.certificateSelectFE.getText().equals(lex.getText("SignCertDialog.generateNew"));
        this.caPasswordEditor.setEnabled(!generate);
        this.notBeforeFE.setEnabled(!generate);
        this.notAfterFE.setEnabled(!generate);
    }

    private BSignCertJobStep getResult() {
        return this.result;
    }
}

