/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.backup;

import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.driver.BDeviceStepDetailsView;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.backup.BBackupStepDetails;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.util.Objects;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class BBackupStepDetailsView
extends BDeviceStepDetailsView {
    public static final Type TYPE = Sys.loadType(BBackupStepDetailsView.class);

    public Type getType() {
        return TYPE;
    }

    public void loadDetails(BWidget owner, BObject base, BJobStepDetails details, BGridPane upperPane, BButtonPane buttons, JobTable.LogModel logModel) throws Exception {
        super.loadDetails(owner, base, details, upperPane, buttons, logModel);
        BLabel backupFileLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"provisioningNiagara", (String)"BackupStepDetailsView.backupFile"), (BWidget)backupFileLabel);
        backupFileLabel.setText(this.getFilePath(((BBackupStepDetails)details).getBackupFileOrd()));
        buttons.add((Command)new RestoreCommand(owner, base, (BBackupStepDetails)details));
    }

    private String getFilePath(BOrd ord) {
        OrdQuery[] q = ord.parse();
        return q[q.length - 1].getBody();
    }

    private class RestoreCommand
    extends Command {
        private BBackupStepDetails details;
        private BObject base;
        private BPassword passphrase;
        int MAX_PASSPHRASE_RETRY;

        public RestoreCommand(BWidget owner, BObject base, BBackupStepDetails details) {
            super(owner, BBackupStepDetailsView.this.getLexicon(), "BackupStepDetailsView.restoreCommand");
            this.passphrase = null;
            this.MAX_PASSPHRASE_RETRY = 3;
            this.details = details;
            this.base = base;
            this.setEnabled(details.getState() == BJobState.success);
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)BBackupStepDetailsView.this.getLexicon().getText("BackupStepDetailsView.restoreCommand.confirmTitle"), (Object)BBackupStepDetailsView.this.getLexicon().getText("BackupStepDetailsView.restoreCommand.confirmMessage", new Object[]{this.details.getDeviceId(), BBackupStepDetailsView.this.getFilePath(this.details.getBackupFileOrd())}))) {
                    boolean promptForPassPhrase;
                    OrdQuery[] ordQueries = this.details.getBackupFileOrd().parse();
                    if (!(ordQueries[ordQueries.length - 1] instanceof FilePath)) {
                        BDialog.message((BWidget)this.getOwner(), (String)BBackupStepDetailsView.this.getLexicon().getText("RestoreBackupCommand.ordFailure.dlgTitle"), (Object)BBackupStepDetailsView.this.getLexicon().getText("RestoreBackupCommand.ordFailure.dlgMessage"));
                        return null;
                    }
                    FilePath path = (FilePath)ordQueries[ordQueries.length - 1];
                    BFoxSession foxSession = (BFoxSession)BOrd.toSession((BObject)this.base);
                    BNiagaraProvisioningChannel channel = (BNiagaraProvisioningChannel)foxSession.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
                    boolean bl = promptForPassPhrase = !channel.validateDistPassphraseToPlatform(this.details.getDeviceId().toString(), path);
                    if (promptForPassPhrase) {
                        for (int currentTry = 0; currentTry < this.MAX_PASSPHRASE_RETRY; ++currentTry) {
                            boolean isValid;
                            BGridPane gridPane = new BGridPane(2);
                            gridPane.setValign(BValign.top);
                            gridPane.setHalign(BHalign.left);
                            BPasswordFE passwordFE = new BPasswordFE();
                            LabelUtil.addLabelWidgetPair((BPane)gridPane, (String)BBackupStepDetailsView.this.getLexicon().getText("BackupStepDetailsView.passphrase.prompt"), (BWidget)passwordFE);
                            BDialog.open((BWidget)this.getOwner(), (String)BBackupStepDetailsView.this.getLexicon().getText("BackupStepDetailsView.passphrase.title"), (Object)new BEdgePane((BWidget)new BBorderPane((BWidget)new BLabel(BBackupStepDetailsView.this.getLexicon().getText("BackupStepDetailsView.passphrase.desc"), BHalign.left), 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)gridPane), (int)3, (BImage)BDialog.QUESTION_ICON);
                            BPassword value = (BPassword)passwordFE.saveValue();
                            if (!Objects.nonNull(value) || !(isValid = channel.validatePassphraseToDist(path, value))) continue;
                            this.passphrase = value;
                            break;
                        }
                        if (this.passphrase == null || this.passphrase.isDefault()) {
                            CommandUtil.error((Command)this, (Throwable)new Throwable(BBackupStepDetailsView.this.getLexicon().getText("BackupStepDetailsView.passphrase.failed", new Object[]{BBackupStepDetailsView.this.getFilePath(this.details.getBackupFileOrd())})));
                            return null;
                        }
                    }
                    Context cx = Context.NULL;
                    BWbShell.getWbShell((BWidget)this.getOwner()).hyperlink(this.details.startRestoreJob(this.base, this.passphrase, cx));
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

