/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui;

import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;

@NiagaraType
public class BTogglePane
extends BBorderPane {
    public static final Type TYPE = Sys.loadType(BTogglePane.class);
    private final BRadioButton controlButton;
    private final BGridPane outerPane;
    private static final String ENABLED_PROPERTY = "previouslyEnabled";

    public Type getType() {
        return TYPE;
    }

    public BTogglePane(String label) {
        this(label, null);
    }

    public BTogglePane(String label, BWidget content) {
        this.controlButton = new BRadioButton(label);
        this.outerPane = new BGridPane(1);
        this.outerPane.setHalign(BHalign.left);
        this.outerPane.setColumnAlign(BHalign.fill);
        this.outerPane.add(null, (BValue)this.controlButton);
        if (content != null) {
            this.outerPane.add(null, (BValue)content);
            this.controlButton.setCommand((Command)new EnablePaneCommand((BWidget)this, content), false, false);
        } else {
            this.controlButton.setCommand((Command)new ToggleCommand((BWidget)this, null), false, false);
        }
        this.setBorder(BBorder.solid);
        this.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
        this.setContent((BWidget)this.outerPane);
    }

    public void setSelected(boolean selected) {
        ((ToggleCommand)this.controlButton.getCommand()).setSelected(selected);
    }

    public boolean getSelected() {
        return ((ToggleCommand)this.controlButton.getCommand()).isSelected();
    }

    public void setCommandGroup(ToggleCommandGroup<ToggleCommand> commandGroup) {
        commandGroup.add((ToggleCommand)this.controlButton.getCommand());
        this.setSelected(false);
    }

    private static class EnablePaneCommand
    extends ToggleCommand {
        private final BWidget controlledPane;

        private EnablePaneCommand(BWidget owner, BWidget controlledPane) {
            super(owner, "");
            this.controlledPane = controlledPane;
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            EnablePaneCommand.setChildrenEnabled(this.controlledPane, selected);
        }

        private static void setChildrenEnabled(BWidget parent, boolean enabled) {
            BWidget[] children;
            for (BWidget child : children = parent.getChildWidgets()) {
                BWidget[] grandChildren;
                if (enabled) {
                    Property enabledProperty = child.getProperty(BTogglePane.ENABLED_PROPERTY);
                    if (enabledProperty != null) {
                        child.remove(BTogglePane.ENABLED_PROPERTY);
                        child.setEnabled(true);
                    }
                } else if (child.getEnabled()) {
                    child.add(BTogglePane.ENABLED_PROPERTY, (BValue)BBoolean.make((boolean)true), 6);
                    child.setEnabled(false);
                }
                for (BWidget grandChild : grandChildren = child.getChildWidgets()) {
                    EnablePaneCommand.setChildrenEnabled(grandChild, enabled);
                }
            }
        }
    }
}

