/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.time;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.npsdk.BNtpPlatformServiceNpsdk;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.qnx.BNtpPlatformServiceQnx;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.time.BNtpSettings;
import com.tridium.provisioningNiagara.time.BTimeStepEnum;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BObject;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="date", type="baja:Date", defaultValue="BDate.NULL"), @NiagaraProperty(name="time", type="baja:Time", defaultValue="BTime.DEFAULT"), @NiagaraProperty(name="dateTime", type="baja:AbsTime", defaultValue="BAbsTime.NULL"), @NiagaraProperty(name="timeZone", type="baja:TimeZone", defaultValue="BTimeZone.NULL"), @NiagaraProperty(name="ntpSettings", type="provisioningNiagara:NtpSettings", defaultValue="BNtpSettings.NULL"), @NiagaraProperty(name="timeSetMethod", type="provisioningNiagara:TimeStepEnum", defaultValue="BTimeStepEnum.DEFAULT")})
public class BSetTimeJobStep
extends BDeviceJobStep {
    public static final Property date = BSetTimeJobStep.newProperty((int)0, (BValue)BDate.NULL, null);
    public static final Property time = BSetTimeJobStep.newProperty((int)0, (BValue)BTime.DEFAULT, null);
    public static final Property dateTime = BSetTimeJobStep.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property timeZone = BSetTimeJobStep.newProperty((int)0, (BValue)BTimeZone.NULL, null);
    public static final Property ntpSettings = BSetTimeJobStep.newProperty((int)0, (BValue)BNtpSettings.NULL, null);
    public static final Property timeSetMethod = BSetTimeJobStep.newProperty((int)0, (BValue)BTimeStepEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BSetTimeJobStep.class);
    private static final Version HOST_MODE_VERSION = new Version("4.9");
    protected static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    public BDate getDate() {
        return (BDate)this.get(date);
    }

    public void setDate(BDate v) {
        this.set(date, (BValue)v, null);
    }

    public BTime getTime() {
        return (BTime)this.get(time);
    }

    public void setTime(BTime v) {
        this.set(time, (BValue)v, null);
    }

    public BAbsTime getDateTime() {
        return (BAbsTime)this.get(dateTime);
    }

    public void setDateTime(BAbsTime v) {
        this.set(dateTime, (BValue)v, null);
    }

    public BTimeZone getTimeZone() {
        return (BTimeZone)this.get(timeZone);
    }

    public void setTimeZone(BTimeZone v) {
        this.set(timeZone, (BValue)v, null);
    }

    public BNtpSettings getNtpSettings() {
        return (BNtpSettings)this.get(ntpSettings);
    }

    public void setNtpSettings(BNtpSettings v) {
        this.set(ntpSettings, (BValue)v, null);
    }

    public BTimeStepEnum getTimeSetMethod() {
        return (BTimeStepEnum)this.get(timeSetMethod);
    }

    public void setTimeSetMethod(BTimeStepEnum v) {
        this.set(timeSetMethod, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSetTimeJobStep() {
        this.setTimeSetMethod(BTimeStepEnum.supervisor);
    }

    public BSetTimeJobStep(BNtpSettings settings) {
        this.setTimeSetMethod(BTimeStepEnum.ntp);
        this.setNtpSettings(settings);
    }

    public BSetTimeJobStep(BAbsTime dateTime, BTimeZone timeZone) {
        this.setTimeSetMethod(BTimeStepEnum.selected);
        this.setDateTime(dateTime);
        this.setTimeZone(timeZone);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        if (!util.getDaemonSession().getHostProperties().hasFullAccess()) {
            throw new BajaException(LEX.getText("SetTimeJobStep.readOnly"));
        }
        switch (this.getTimeSetMethod().getOrdinal()) {
            case 1: {
                if (this.getDateTime() != BAbsTime.NULL) {
                    util.sendDaemonMessage((DaemonMessage)new UpdateTimeMessage(BAbsTime.make((BAbsTime)this.getDateTime(), (BTimeZone)this.getTimeZone()), null, this.getTimeZone(), false));
                    break;
                }
                util.sendDaemonMessage((DaemonMessage)new UpdateTimeMessage(BAbsTime.make((BDate)this.getDate(), (BTime)this.getTime(), (BTimeZone)this.getTimeZone()), null, this.getTimeZone(), false));
                break;
            }
            case 2: {
                BNtpPlatformServiceQnx npsdkService;
                BSystemPlatformService systemPlatformService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)util.getEngagedFoxSession());
                systemPlatformService.lease(Integer.MAX_VALUE);
                Version remoteNiagaraVersion = systemPlatformService.getNiagaraVersion().equals("") ? new Version("3.0") : new Version(systemPlatformService.getNiagaraVersion());
                BNtpPlatformService platformService = (BNtpPlatformService)BOrd.make((String)"service:platform:NtpPlatformService").get((BObject)util.getEngagedFoxSession());
                platformService.lease(Integer.MAX_VALUE);
                if ((platformService instanceof BNtpPlatformServiceNpsdk || platformService instanceof BNtpPlatformServiceQnx) && remoteNiagaraVersion.compareTo(HOST_MODE_VERSION) < 0) {
                    details.message("provisioningNiagara", "SetTimeJobStep.hostMode.notSupported", new String[]{systemPlatformService.getHost().toString(), remoteNiagaraVersion.toString(), HOST_MODE_VERSION.toString()});
                }
                if (platformService instanceof BNtpPlatformServiceQnx) {
                    npsdkService = (BNtpPlatformServiceQnx)platformService;
                    npsdkService.setEnabled(this.getNtpSettings().getNtpEnabled());
                    npsdkService.setHostMode(this.getNtpSettings().getHostMode());
                    npsdkService.setNtp(this.getNtpSettings().getSyncLocal());
                    npsdkService.setLocalBackup(this.getNtpSettings().getLocalAsBackup());
                    npsdkService.setStatistics(this.getNtpSettings().getNtpStats());
                    npsdkService.setSyncAtBoot(this.getNtpSettings().getSyncAtBoot());
                } else if (platformService instanceof BNtpPlatformServiceNpsdk) {
                    npsdkService = (BNtpPlatformServiceNpsdk)platformService;
                    npsdkService.setEnabled(this.getNtpSettings().getNtpEnabled());
                    npsdkService.setHostMode(this.getNtpSettings().getHostMode());
                    npsdkService.setNtp(this.getNtpSettings().getSyncLocal());
                    npsdkService.setLocalBackup(this.getNtpSettings().getLocalAsBackup());
                    npsdkService.setStatistics(this.getNtpSettings().getNtpStats());
                } else {
                    throw new BajaException(LEX.getText("SetTimeJobStep.ntpReadOnly.notSupported"));
                }
                BNtpServerVector serverVector = platformService.getTimeServers();
                serverVector.lease();
                serverVector.removeAll();
                String[] serverStrings = this.getNtpSettings().getServers().split(";");
                serverVector.sync(serverStrings);
                platformService.savePlatformServiceProperties();
                util.disengageFoxSession();
                break;
            }
            case 0: {
                BAbsTime timeToSet = BAbsTime.now();
                util.sendDaemonMessage((DaemonMessage)new UpdateTimeMessage(timeToSet, null, timeToSet.getTimeZone(), false));
                break;
            }
        }
        details.success();
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

