/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import com.tridium.provisioningNiagara.software.BInstallCombinedBySpecStep;
import com.tridium.provisioningNiagara.software.BSoftwareStationExt;
import com.tridium.provisioningNiagara.template.ProvisionTemplateManager;
import com.tridium.template.BTemplateChannel;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateService;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.application.BApplicationInstallSpecs;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.TemplateManager;
import com.tridium.template.job.BInstallApplicationTemplateJob;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.BulkDeployWorkbook;
import com.tridium.template.ui.file.BWbDeployableNtplFile;
import com.tridium.util.JobProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.fox.BFoxProxySession;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.util.BFormat;
import javax.baja.util.Version;

public class ProvisioningBulkDeployUtil
extends BulkDeployUtil {
    protected Level PROVISION_LOG_LEVEL = Level.FINE;
    private static final int MISSING_DEPENDENCIES_NONE = 0;
    private static final int MISSING_DEPENDENCIES_SUCCESS = 1;
    private static final int MISSING_DEPENDENCIES_FAILURE = 2;
    private static final int TEMPLATE_SERVICE_START_RETRY_COUNT = 10;
    private static final int TEMPLATE_SERVICE_START_RETRY_WAIT_MS = 1000;

    protected List<BulkDeployUtil.DeployedWorksheet> loadExcelFileWorksheets(BIFile excelFile, String excelPassword, BDeviceStepDetails details) throws IOException {
        try (BulkDeployWorkbook wb = BulkDeployWorkbook.load((File)BFileSystem.INSTANCE.pathToLocalFile(excelFile.getFilePath()), (String)excelPassword);){
            if (wb.isEncrypted() && wb.wrongPassword()) {
                details.message("template", "bulkDeploy.excelImport.invalidPassword.warning", new String[]{excelFile.getFileName()});
                List<BulkDeployUtil.DeployedWorksheet> list = null;
                return list;
            }
            if (!wb.isEncrypted() && excelPassword != null && !excelPassword.isEmpty()) {
                details.message("template", "bulkDeploy.excelImport.expectedEncryption.warning", new String[]{excelFile.getFileName()});
                List<BulkDeployUtil.DeployedWorksheet> list = null;
                return list;
            }
            if (wb.hasPrivateData() && (wb.usesOldExcelFormat() || !wb.isEncrypted())) {
                details.message("template", "bulkDeploy.excelImport.insecureFormat.warning", new String[]{excelFile.getFileName()});
            }
            List list = this.loadDeployedWorksheets(wb);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BStation installApplicationToStation(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, BDeviceStepDetails details, ProvisioningConnectionUtil util, DeviceNetworkJobOp opIn) {
        BStation station = null;
        Subscriber subscriber = Subscriber.make(event -> {});
        try {
            BFoxSession session = util.getEngagedFoxSession();
            BComponent stationRoot = this.resolveRemoteDeployComponent(deployedRoot.getParentComponentSlotPath(), BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"station:|slot:/"), details);
            station = (BStation)stationRoot;
            String stationName = station.getStationDisplayName(null);
            String fileName = deployedWorksheet.templateFile;
            details.message("template", "installApplication.copyingFile", new String[]{fileName, stationName});
            BWbDeployableNtplFile sourceTemplateFile = this.resolveDeployableNtplFile(deployedWorksheet, details);
            TemplateManager.TemplateInfo templateInfo = this.getTemplateFile(deployedWorksheet, details);
            int dependencyResult = this.installMissingDependencies((BNtplFile)sourceTemplateFile, templateInfo, stationRoot, details, util, opIn);
            switch (dependencyResult) {
                case 0: {
                    break;
                }
                case 1: {
                    stationRoot = this.resolveRemoteDeployComponent(deployedRoot.getParentComponentSlotPath(), BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"station:|slot:/"), details);
                    station = (BStation)stationRoot;
                    break;
                }
                case 2: {
                    BStation bStation = null;
                    return bStation;
                }
            }
            BIFile applicationTemplateFile = ApplicationTemplateUtil.copyApplicationTemplateToStation((BNtplFile)sourceTemplateFile, (BStation)station);
            details.message("template", "installApplication.finishedCopyingFile", new String[]{applicationTemplateFile.getFileName()});
            details.message("template", "installApplication.startingApplicationTemplateInstallationJob");
            BTemplateService templateService = this.resolveTemplateService(util.getEngagedFoxSession());
            Version remoteVersion = (Version)templateService.fw(404, (Object)"template", null, null, null);
            boolean stationSupportsOptionals = remoteVersion.compareTo(new Version("4.9")) >= 0;
            BOrd installApplicationTemplateJobOrd = null;
            BOrd applicationTemplateFileOrd = applicationTemplateFile.getOrdInSession();
            if (stationSupportsOptionals) {
                BApplicationInstallSpecs installSpecs = BApplicationInstallSpecs.make((boolean)false, (boolean)true, (BOrd)applicationTemplateFileOrd, (BOrdList)this.getSelectedOptionalsFromWorkbook(sourceTemplateFile, deployedWorksheet, deployedRoot));
                installApplicationTemplateJobOrd = templateService.installApplication(installSpecs);
            } else {
                installApplicationTemplateJobOrd = templateService.checkAndInstallApplicationTemplate(applicationTemplateFileOrd);
            }
            DetailsMessage detailsMessage = new DetailsMessage(details);
            JobProgressMonitor jobMonitor = new JobProgressMonitor(installApplicationTemplateJobOrd, (BComponent)station, JobProgressMonitor.makeJobLogItemMessageConsumer(detailsMessage::message, (Context)session.getSessionContext()));
            BInstallApplicationTemplateJob job = (BInstallApplicationTemplateJob)jobMonitor.waitAndReadLog();
            if (BJobState.success.equals((Object)job.getJobState())) {
                details.message("template", "installApplication.applicationTemplateInstalled");
            } else {
                details.failed("template", "installApplication.applicationTemplateFailedToInstall");
                details.complete(BJobState.failed);
            }
        }
        catch (Exception error) {
            details.failed("template", "bulkDeploy.excelImport.bulkDeployError", new String[]{deployedWorksheet.templateFile, station.getStationName()}, (Throwable)error);
            details.complete(BJobState.failed);
        }
        finally {
            subscriber.unsubscribeAll();
        }
        return station;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeApplicationInStation(BNtplFile sourceTemplateFile, BDeviceStepDetails details, ProvisioningConnectionUtil util, DeviceNetworkJobOp opIn) {
        BStation station = null;
        Subscriber subscriber = Subscriber.make(event -> {});
        try {
            BFoxSession session = util.getEngagedFoxSession();
            BComponent stationRoot = this.resolveRemoteDeployComponent("station", BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"station:|slot:/"), details);
            station = (BStation)stationRoot;
            station.lease(2);
            String stationName = station.getStationDisplayName(null);
            TemplateManager.TemplateInfo templateInfo = this.getTemplateInfo(sourceTemplateFile, details);
            boolean match = false;
            BTemplateConfig targetConfig = BTemplateConfig.getConfigForApplication((BStation)station);
            if (targetConfig != null && templateInfo != null) {
                targetConfig.lease();
                match = Objects.equals(targetConfig.getUID(), templateInfo.getUid());
            }
            if (!match) {
                details.message("template", "upgradeApplication.noMatch");
                return;
            }
            details.message("template", "installApplication.copyingFile", new String[]{sourceTemplateFile.getFileName(), stationName});
            int dependencyResult = this.installMissingDependencies(sourceTemplateFile, templateInfo, stationRoot, details, util, opIn);
            switch (dependencyResult) {
                case 0: {
                    break;
                }
                case 1: {
                    stationRoot = this.resolveRemoteDeployComponent("station", BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"station:|slot:/"), details);
                    station = (BStation)stationRoot;
                    break;
                }
                case 2: {
                    return;
                }
            }
            BIFile applicationTemplateFile = ApplicationTemplateUtil.copyApplicationTemplateToStation((BNtplFile)sourceTemplateFile, (BStation)station);
            details.message("template", "installApplication.finishedCopyingFile", new String[]{applicationTemplateFile.getFileName()});
            details.message("template", "installApplication.startingApplicationTemplateInstallationJob");
            BTemplateService templateService = this.resolveTemplateService(util.getEngagedFoxSession());
            BApplicationInstallSpecs installSpecs = BApplicationInstallSpecs.make((boolean)true, (boolean)false, (BOrd)applicationTemplateFile.getOrdInSession(), (BOrdList)BOrdList.DEFAULT);
            BOrd upgradeApplicationTemplateJobOrd = templateService.installApplication(installSpecs);
            DetailsMessage detailsMessage = new DetailsMessage(details);
            JobProgressMonitor jobMonitor = new JobProgressMonitor(upgradeApplicationTemplateJobOrd, (BComponent)station, JobProgressMonitor.makeJobLogItemMessageConsumer(detailsMessage::message, (Context)session.getSessionContext()));
            BInstallApplicationTemplateJob job = (BInstallApplicationTemplateJob)jobMonitor.waitAndReadLog();
            if (BJobState.success.equals((Object)job.getJobState())) {
                details.message("template", "upgradeApplication.applicationTemplateUpgraded");
            } else {
                details.failed("template", "upgradeApplication.applicationTemplateFailedToUpgrade");
                details.complete(BJobState.failed);
            }
        }
        catch (Exception error) {
            details.failed("template", "bulkDeploy.upgradeApplication.bulkDeployError", new String[]{sourceTemplateFile.getFileName(), station.getStationName()}, (Throwable)error);
            details.complete(BJobState.failed);
        }
        finally {
            subscriber.unsubscribeAll();
        }
    }

    private BTemplateService resolveTemplateService(BFoxSession session) {
        BOrd templateServiceOrd = BOrd.make((BOrd)session.getAbsoluteOrd(), (String)"service:template:TemplateService");
        OrdTarget templateTarget = templateServiceOrd.resolve();
        return (BTemplateService)templateTarget.get();
    }

    public BComponent installTemplateToStation(BulkDeployUtil.DeployedWorksheet deployedWorksheet, BulkDeployUtil.DeployedRoot deployedRoot, BDeviceStepDetails details, ProvisioningConnectionUtil util, DeviceNetworkJobOp opIn, Map<String, BFormat> componentDisplayNames) {
        BFoxSession session = this.getEngagedSession(util, details, deployedWorksheet.templateFile);
        if (session == null) {
            return null;
        }
        BComponent rootComponent = this.resolveRemoteDeployComponent(deployedRoot, (BFoxProxySession)session, details);
        rootComponent.lease(2);
        BINavNode templateObject = rootComponent.getNavChild(deployedRoot.getDeployName());
        if (templateObject != null) {
            details.message("provisioningNiagara", "DeployTemplateStep.skipTemplateComponentDetails", new String[]{deployedRoot.getParentComponentSlotPath(), deployedRoot.getDeployName(), deployedWorksheet.title});
            return null;
        }
        log.log(this.PROVISION_LOG_LEVEL, "Root component ord: " + rootComponent.getAbsoluteOrd());
        TemplateManager.TemplateInfo templateInfo = this.getTemplateFile(deployedWorksheet, details);
        BNtplFile ntplFile = templateInfo.getNtplFile();
        if (ntplFile == null) {
            details.failed("template", "bulkDeploy.excelImport.templateFileCopyError", new String[]{deployedWorksheet.title});
            details.complete(BJobState.failed);
            return null;
        }
        BWbDeployableNtplFile deployableNtplFile = (BWbDeployableNtplFile)ntplFile;
        int dependencyResult = this.installMissingDependencies((BNtplFile)deployableNtplFile, templateInfo, rootComponent, details, util, opIn);
        switch (dependencyResult) {
            case 0: {
                break;
            }
            case 1: {
                rootComponent = this.resolveRemoteDeployComponent(deployedRoot, (BFoxProxySession)session, details);
                rootComponent.lease(2);
                break;
            }
            case 2: {
                return null;
            }
        }
        boolean templateCopied = this.copyTemplateToNetworkStation(templateInfo, rootComponent, details);
        if (!templateCopied) {
            details.failed("provisioningNiagara", "DeployTemplateStep.copyTemplateFileError", new String[]{templateInfo.getNtplFile().getFileName()});
            details.cancel();
            return null;
        }
        details.message("provisioningNiagara", "DeployTemplateStep.installTemplateComponentDetails", new String[]{deployedWorksheet.title});
        BComponent deployedTemplateComponent = this.installTemplateToStation(deployedWorksheet, deployedRoot, rootComponent, ntplFile, componentDisplayNames);
        if (deployedTemplateComponent == null) {
            details.failed("template", "bulkDeploy.excelImport.templateNotResolvedError", new String[]{deployedRoot.getParentComponentSlotPath(), deployedWorksheet.title});
            details.complete(BJobState.failed);
            return null;
        }
        if (deployedRoot.getDisplayName() != null && !deployedRoot.getDisplayName().isEmpty()) {
            rootComponent.setDisplayName(rootComponent.getProperty(deployedRoot.getDeployName()), BFormat.make((String)deployedRoot.getDisplayName()), Context.NULL);
        }
        ProvisioningBulkDeployUtil.setComponentPosition((BComponent)deployedTemplateComponent, (String)deployedRoot.getPosition());
        return deployedTemplateComponent;
    }

    private BFoxSession getEngagedSession(ProvisioningConnectionUtil util, BDeviceStepDetails details, String templateFileName) {
        try {
            return util.getEngagedFoxSession();
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "DeployTemplateStep.sessionFailed", new String[]{templateFileName}, (Throwable)e);
            return null;
        }
    }

    private int installMissingDependencies(BNtplFile templateFile, TemplateManager.TemplateInfo templateInfo, BComponent rootComponent, BDeviceStepDetails details, ProvisioningConnectionUtil util, DeviceNetworkJobOp opIn) {
        List missingDependencies = templateFile.checkRemoteModuleDependencies(rootComponent);
        Map missingElements = (Map)missingDependencies.get(0);
        if (missingElements == null || missingElements.keySet().size() == 0) {
            return 0;
        }
        StringBuilder modules = new StringBuilder();
        boolean isFirst = true;
        for (String key : missingElements.keySet()) {
            if (!isFirst) {
                modules.append(':');
            }
            modules.append(key);
            isFirst = false;
        }
        LocalInstallableRegistry sw = LocalInstallableRegistry.getInstance();
        BInstallCombinedBySpecStep missingModulesStep = null;
        try {
            NiagaraNetworkJobOp op = (NiagaraNetworkJobOp)opIn;
            BNiagaraStation station = (BNiagaraStation)details.getDevice();
            BPlatformConnection platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            BDaemonSession daemonSession = platformConn.getDaemonSession();
            BAbstractSoftwareStep.Listener listener = new BAbstractSoftwareStep.Listener(details);
            BSoftwareStationExt softwareExt = (BSoftwareStationExt)station.getMixIn(BSoftwareStationExt.TYPE);
            BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)daemonSession, (DaemonSessionTaskListener)listener, (boolean)false);
            ArrayList<BInstallableSpec> specs = new ArrayList<BInstallableSpec>();
            ArrayList<BModuleInstallable> moduleInstallables = new ArrayList<BModuleInstallable>();
            for (String moduleName : missingElements.keySet()) {
                BDependency moduleDependency = new BDependency(moduleName, (BVersion)missingElements.get(moduleName), BModulePart.TYPE.getTypeSpec());
                log.log(Level.FINE, " Missing dependency: " + moduleDependency.toString(null));
                BIFile installableFile = sw.findInstallableFile(moduleDependency, (DaemonSessionTaskListener)listener);
                if (installableFile == null) {
                    details.failed("provisioningNiagara", "DeployTemplateStep.dependencyMissingError", new String[]{modules.toString(), templateInfo.getName()});
                    details.complete(BJobState.failed);
                    return 2;
                }
                IterableCursor c = sw.getInstallables(true, null, installableFile.getFileName());
                while (c.next()) {
                    BModuleInstallable moduleCandidate = (BModuleInstallable)c.get();
                    specs.add(BInstallableSpec.make((BInstallable)moduleCandidate));
                    moduleInstallables.add(moduleCandidate);
                }
            }
            details.getJob().checkCanceled();
            missingModulesStep = new BInstallCombinedBySpecStep(specs);
            missingModulesStep.add("ExcludeFromProgress", (BValue)BBoolean.TRUE);
            BForEachDeviceStage stage = (BForEachDeviceStage)details.getJob().getStage(details.getStageName());
            stage.addStep((BJobStep)missingModulesStep);
            platform.loadPreferredVerificationMode();
            InstallScenario scenario = new InstallScenario((BDaemonPlatform)platform, (DaemonSessionTaskListener)listener, new String[0], new BDependency[0], new BInstallable[0], (InstallableRegistry)sw, CertificateChainValidator.make((ICoreCryptoManager)BPlatCryptoManager.make((BDaemonPlatform)platform)));
            scenario = missingModulesStep.updateInstallScenario(details, listener, scenario, op);
            Set profiles = platform.getEnabledRuntimeProfiles();
            if (!profiles.containsAll(scenario.getNewEnabledRuntimeProfiles())) {
                return this.missingDepenenciesFailure(details, "unsupportedProfile", new String[]{templateInfo.getName(), platform.getEnabledRuntimeProfileNames()}, missingModulesStep, stage, null, false);
            }
            missingModulesStep.commitScenario(details, scenario, (BDaemonPlatform)platform, util.getPlatformConnection(), softwareExt, op);
            platform.getModuleList().init((DaemonSessionTaskListener)listener);
        }
        catch (JobCancelException jce) {
            return this.missingDepenenciesFailure(details, "jobCanceled", new String[]{modules.toString(), templateInfo.getName()}, missingModulesStep, (BForEachDeviceStage)details.getJob().getStage(details.getStageName()), jce, true);
        }
        catch (Exception e) {
            return this.missingDepenenciesFailure(details, "dependencyInstallError", new String[]{modules.toString(), templateInfo.getName()}, missingModulesStep, (BForEachDeviceStage)details.getJob().getStage(details.getStageName()), e, false);
        }
        details.message("provisioningNiagara", "DeployTemplateStep.templateServiceCheck");
        try {
            BFoxSession session = util.getEngagedFoxSession();
            boolean isServiceRunning = false;
            for (int i = 0; i < 10; ++i) {
                try {
                    BTemplateService templateService = this.resolveTemplateService(session);
                    templateService.lease();
                    if (templateService.isOperational()) {
                        isServiceRunning = true;
                        break;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    Thread.sleep(1000L);
                }
            }
            if (!isServiceRunning) {
                return this.missingDepenenciesFailure(details, "templateServiceFailed", new String[]{templateInfo.getName()}, null, null, null, false);
            }
        }
        catch (ServiceNotFoundException e) {
            details.failed("provisioningNiagara", "DeployTemplateStep.templateServiceFailed", new String[]{templateInfo.getName()}, (Throwable)e);
            details.complete(BJobState.failed);
            return this.missingDepenenciesFailure(details, "templateServiceFailed", new String[]{templateInfo.getName()}, null, null, e, false);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "DeployTemplateStep.sessionFailed", new String[]{templateInfo.getName()}, (Throwable)e);
            details.complete(BJobState.failed);
            return this.missingDepenenciesFailure(details, "sessionFailed", new String[]{templateInfo.getName()}, null, null, e, false);
        }
        return 1;
    }

    private int missingDepenenciesFailure(BDeviceStepDetails details, String lexiconKeySegment, String[] lexiconArgs, BInstallCombinedBySpecStep missingModulesStep, BForEachDeviceStage stage, Throwable exception, boolean isCanceled) {
        if (exception == null) {
            details.failed("provisioningNiagara", "DeployTemplateStep." + lexiconKeySegment, lexiconArgs);
        } else {
            details.failed("provisioningNiagara", "DeployTemplateStep." + lexiconKeySegment, lexiconArgs, exception);
        }
        if (missingModulesStep != null && stage != null) {
            stage.getSteps().remove((BComplex)missingModulesStep);
        }
        if (isCanceled) {
            details.cancel();
        } else {
            details.complete(BJobState.failed);
        }
        return 2;
    }

    protected void upgradeTemplateInstance(TemplateManager.TemplateInfo templateInfo, String deployedSlotPath, ProvisioningConnectionUtil util, DeviceNetworkJobOp opIn, BDeviceStepDetails details) {
        BFoxSession session = this.getEngagedSession(util, details, templateInfo.getName());
        if (session == null) {
            return;
        }
        BOrd sessionOrd = session.getAbsoluteOrd();
        BOrd deployedRootOrd = BOrd.make((BOrd)sessionOrd, (String)("station:|" + deployedSlotPath));
        BComponent deployedRootComponent = this.resolveRemoteDeployComponent(deployedSlotPath, deployedRootOrd, details);
        if (deployedRootComponent == null) {
            return;
        }
        deployedRootComponent.lease(2);
        BNtplFile ntplFile = templateInfo.getNtplFile();
        if (ntplFile == null) {
            details.failed("template", "bulkDeploy.excelImport.templateFileCopyError", new String[]{templateInfo.getName()});
            details.complete(BJobState.failed);
            return;
        }
        BWbDeployableNtplFile deployableNtplFile = (BWbDeployableNtplFile)ntplFile;
        int dependencyResult = this.installMissingDependencies((BNtplFile)deployableNtplFile, templateInfo, deployedRootComponent, details, util, opIn);
        switch (dependencyResult) {
            case 0: {
                break;
            }
            case 1: {
                deployedRootComponent = this.resolveRemoteDeployComponent(deployedSlotPath, deployedRootOrd, details);
                deployedRootComponent.lease(2);
                break;
            }
            case 2: {
                return;
            }
        }
        this.copyTemplateToNetworkStation(templateInfo, deployedRootComponent, details);
        BTemplateChannel templateChannel = (BTemplateChannel)session.getConnection().getChannels().get("template", BTemplateChannel.TYPE);
        try {
            String[] jobProgress;
            for (String message : jobProgress = templateChannel.upgradeTemplate(deployedSlotPath)) {
                details.message(message);
                if (!message.contains("Job complete")) continue;
                details.success();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Provisioning template upgrade exception", e);
        }
    }

    protected BComponent resolveRemoteDeployComponent(BulkDeployUtil.DeployedRoot deployedRoot, BFoxProxySession session, BDeviceStepDetails details) {
        BOrd sessionOrd = session.getAbsoluteOrd();
        BOrd deployRootOrd = BOrd.make((BOrd)sessionOrd, (String)("station:|slot:/" + deployedRoot.getParentComponentSlotPath()));
        log.log(IMPORT_LOG_LEVEL, "deployRootOrd = " + deployRootOrd);
        try {
            BObject bObject = deployRootOrd.get();
        }
        catch (UnresolvedException e) {
            BComponent stationRoot = BOrd.make((BOrd)sessionOrd, (String)"station:|slot:/").get().asComponent();
            SlotPath deployRootSlotPath = new SlotPath("slot", deployedRoot.getParentComponentSlotPath());
            String[] slotPathElements = deployRootSlotPath.getNames();
            BComponent nextComponent = stationRoot;
            for (String element : slotPathElements) {
                if ((nextComponent = this.getNextChild(nextComponent, element)) != null) continue;
                details.failed("template", "bulkDeploy.excelImport.rootTargetError", new String[]{deployedRoot.getParentComponentSlotPath()});
                details.complete(BJobState.failed);
                return null;
            }
        }
        return this.resolveRemoteDeployComponent(deployedRoot.getParentComponentSlotPath(), deployRootOrd, details);
    }

    protected BComponent resolveRemoteDeployComponent(String componentName, BOrd componentOrd, BDeviceStepDetails details) {
        BComponent deployRootComponent = componentOrd.get().asComponent();
        log.log(IMPORT_LOG_LEVEL, "deployRootComponent = " + deployRootComponent.getAbsoluteOrd());
        if (deployRootComponent == null) {
            details.failed("template", "bulkDeploy.excelImport.rootTargetError", new String[]{componentName});
            details.complete(BJobState.failed);
            return null;
        }
        details.message("provisioningNiagara", "DeployTemplateStep.resolveRemoteComponentDetails", new String[]{deployRootComponent.getAbsoluteOrd().toString()});
        if (!deployRootComponent.isMounted()) {
            details.failed("template", "bulkDeploy.excelImport.notMountedError", new String[]{componentName});
            details.complete(BJobState.failed);
            return null;
        }
        return deployRootComponent;
    }

    private BWbDeployableNtplFile resolveDeployableNtplFile(BulkDeployUtil.DeployedWorksheet worksheet, BDeviceStepDetails details) {
        ProvisionTemplateManager tmInstance = new ProvisionTemplateManager();
        log.log(IMPORT_LOG_LEVEL, "Locate template file for UID" + worksheet.uid + " and vendor " + worksheet.vendor);
        TemplateManager.TemplateInfo deployTemplateInfo = tmInstance.getTemplate(worksheet.uid, worksheet.vendor);
        if (deployTemplateInfo == null) {
            details.failed("template", "bulkDeploy.excelImport.templateFileNotFound", new String[]{worksheet.title});
            details.complete(BJobState.failed);
            return null;
        }
        BNtplFile ntplFile = deployTemplateInfo.getNtplFile();
        BWbDeployableNtplFile deployableNtplFile = ntplFile instanceof BWbDeployableNtplFile ? (BWbDeployableNtplFile)ntplFile : BWbDeployableNtplFile.make((BNtplFile)ntplFile);
        return deployableNtplFile;
    }

    protected TemplateManager.TemplateInfo getTemplateFile(BulkDeployUtil.DeployedWorksheet worksheet, BDeviceStepDetails details) {
        ProvisionTemplateManager tmInstance = new ProvisionTemplateManager();
        log.log(IMPORT_LOG_LEVEL, "Locate template file for UID" + worksheet.uid + " and vendor " + worksheet.vendor);
        TemplateManager.TemplateInfo deployTemplateInfo = tmInstance.getTemplate(worksheet.uid, worksheet.vendor);
        if (deployTemplateInfo == null) {
            details.failed("template", "bulkDeploy.excelImport.templateFileNotFound", new String[]{worksheet.title});
            details.complete(BJobState.failed);
            return null;
        }
        return deployTemplateInfo;
    }

    private TemplateManager.TemplateInfo getTemplateInfo(BNtplFile templateFile, BDeviceStepDetails details) {
        ProvisionTemplateManager tmInstance = new ProvisionTemplateManager();
        TemplateManager.TemplateInfo deployTemplateInfo = tmInstance.getTemplate(templateFile);
        if (deployTemplateInfo == null) {
            details.failed("template", "bulkDeploy.templateLoad.templateFileNotFound", new String[]{templateFile.getFileName()});
            details.complete(BJobState.failed);
            return null;
        }
        return deployTemplateInfo;
    }

    private boolean copyTemplateToNetworkStation(TemplateManager.TemplateInfo deployTemplateInfo, BComponent deployRootComponent, BDeviceStepDetails details) {
        BNtplFile ntplFile = deployTemplateInfo.getNtplFile();
        BWbDeployableNtplFile deployableNtplFile = ntplFile instanceof BWbDeployableNtplFile ? (BWbDeployableNtplFile)ntplFile : BWbDeployableNtplFile.make((BNtplFile)ntplFile);
        details.message("provisioningNiagara", "DeployTemplateStep.copyTemplateFileDetails", new String[]{deployableNtplFile.getFileName()});
        return this.updateNtplFile(deployableNtplFile, deployRootComponent);
    }

    class DetailsMessage {
        BDeviceStepDetails details;

        public DetailsMessage(BDeviceStepDetails details) {
            this.details = details;
        }

        void message(String message) {
            this.details.message(message.replaceAll("%", "%%"));
        }
    }
}

