/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.template.ProvisioningBulkDeployUtil;
import com.tridium.template.file.BNtplFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="applicationFileOrd", type="BOrd", defaultValue="BOrd.DEFAULT")
public class BUpgradeApplicationStep
extends BDeviceJobStep {
    public static final Property applicationFileOrd = BUpgradeApplicationStep.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BUpgradeApplicationStep.class);
    private Level PROVISION_LOG_LEVEL = Level.FINE;
    public static final Logger log = Logger.getLogger("provisioningNiagara");

    public BOrd getApplicationFileOrd() {
        return (BOrd)this.get(applicationFileOrd);
    }

    public void setApplicationFileOrd(BOrd v) {
        this.set(applicationFileOrd, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BUpgradeApplicationStep() {
    }

    public BUpgradeApplicationStep(BIFile srcFile) {
        this.setApplicationFileOrd(srcFile.getOrdInSession());
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp opIn) throws Exception {
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        BNiagaraStation station = (BNiagaraStation)device;
        this.checkCanceled((BDevice)station);
        if (this.getApplicationFileOrd() == null || this.getApplicationFileOrd() == BOrd.DEFAULT) {
            details.failed("provisioningNiagara", "UpgradeApplicationStep.templateOrdNull");
            details.complete(BJobState.failed);
            return;
        }
        log.log(this.PROVISION_LOG_LEVEL, "Locate application template file at " + this.getApplicationFileOrd().encodeToString());
        BObject templateObject = this.getApplicationFileOrd().resolve().get();
        if (templateObject == null) {
            details.failed("provisioningNiagara", "UpgradeApplicationStep.templateOrdError", new String[]{this.getApplicationFileOrd().encodeToString()});
            details.complete(BJobState.failed);
            return;
        }
        if (!(templateObject instanceof BNtplFile)) {
            details.failed("provisioningNiagara", "UpgradeApplicationStep.templateFileError", new String[]{this.getApplicationFileOrd().encodeToString()});
            details.complete(BJobState.failed);
            return;
        }
        BNtplFile templateFile = (BNtplFile)templateObject;
        log.log(this.PROVISION_LOG_LEVEL, "Application template file version " + templateFile.getVersion() + " and vendor " + templateFile.getVendor());
        ProvisioningBulkDeployUtil bulkDeploy = new ProvisioningBulkDeployUtil();
        bulkDeploy.upgradeApplicationInStation(templateFile, details, util, opIn);
        details.success();
    }
}

