/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.template;

import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.template.ProvisioningBulkDeployUtil;
import com.tridium.template.ui.BulkDeployUtil;
import java.security.AccessController;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="excelFileOrd", type="BOrd", defaultValue="BOrd.DEFAULT"), @NiagaraProperty(name="isPasswordProtected", type="boolean", defaultValue="false"), @NiagaraProperty(name="encodingPassword", type="BPassword", defaultValue="BPassword.DEFAULT")})
public abstract class BAbstractDeployStep
extends BDeviceJobStep {
    public static final Property excelFileOrd = BAbstractDeployStep.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property isPasswordProtected = BAbstractDeployStep.newProperty((int)0, (boolean)false, null);
    public static final Property encodingPassword = BAbstractDeployStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAbstractDeployStep.class);
    Level LOG_LEVEL = Level.FINE;
    protected static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final BIcon icon = BIcon.std((String)"files/ntpl.png");
    protected static final Logger log = Logger.getLogger("provisioningNiagara");

    public BOrd getExcelFileOrd() {
        return (BOrd)this.get(excelFileOrd);
    }

    public void setExcelFileOrd(BOrd v) {
        this.set(excelFileOrd, (BValue)v, null);
    }

    public boolean getIsPasswordProtected() {
        return this.getBoolean(isPasswordProtected);
    }

    public void setIsPasswordProtected(boolean v) {
        this.setBoolean(isPasswordProtected, v, null);
    }

    public BPassword getEncodingPassword() {
        return (BPassword)this.get(encodingPassword);
    }

    public void setEncodingPassword(BPassword v) {
        this.set(encodingPassword, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp opIn) throws Exception {
        OrdQuery[] ordQueries;
        FilePath cachePath;
        BNiagaraStation station = (BNiagaraStation)device;
        this.checkCanceled((BDevice)station);
        BIFile excelFile = (BIFile)this.getExcelFileOrd().resolve().get();
        if (excelFile == null || !excelFile.getExtension().equalsIgnoreCase("xlsx") && !excelFile.getExtension().equalsIgnoreCase("xls")) {
            details.failed("provisioningNiagara", "DeployTemplateStep.excelFileError", new String[]{excelFile.getFileName()});
            details.complete(BJobState.failed);
            return;
        }
        BFileSpace templateSpace = excelFile.getFileSpace();
        if (templateSpace == null) {
            details.failed("provisioningNiagara", "DeployTemplateStep.fileSpaceError", new String[]{excelFile.getFileName()});
            details.complete(BJobState.failed);
            return;
        }
        FilePath templatePath = excelFile.getFilePath();
        FilePath parentPath = templatePath.getParent();
        if (parentPath.compareTo(cachePath = (FilePath)(ordQueries = BOrd.make((String)"file:^templateCache").parse())[ordQueries.length - 1]) != 0) {
            details.failed("provisioningNiagara", "DeployTemplateStep.excelFilePathError", new String[]{parentPath.toString(), cachePath.toString()});
            details.complete(BJobState.failed);
            return;
        }
        log.log(this.LOG_LEVEL, "Excel file path: " + templatePath.toString());
        ProvisioningBulkDeployUtil bulkDeploy = new ProvisioningBulkDeployUtil();
        List<BulkDeployUtil.DeployedWorksheet> deployedWorksheets = bulkDeploy.loadExcelFileWorksheets(excelFile, this.getSpreadsheetPassword(details), details);
        if (deployedWorksheets == null || deployedWorksheets.isEmpty()) {
            details.failed("template", "bulkDeploy.excelImport.importFileError", new String[]{excelFile.getFileName()});
            details.complete(BJobState.failed);
            return;
        }
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        int installAttempts = 0;
        int installSuccesses = 0;
        try {
            HashMap<BComponent, BNameMap> displayNames = new HashMap<BComponent, BNameMap>();
            for (BulkDeployUtil.DeployedWorksheet deployedWorksheet : deployedWorksheets) {
                for (BulkDeployUtil.DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                    if (!this.isDeviceTargetValid(deployedRoot, station)) {
                        details.message("provisioningNiagara", "DeployTemplateStep.deviceTargetMatchFailDetails", new String[]{deployedRoot.getDeviceTarget(), deployedWorksheet.title});
                        continue;
                    }
                    String installInitMessage = lex.getText("DeployTemplateStep.installTemplateFileDetails", new Object[]{deployedWorksheet.templateType, deployedWorksheet.title, deployedWorksheet.version, deployedRoot.getDeployName(), deployedRoot.getParentComponentSlotPath()});
                    log.log(this.LOG_LEVEL, installInitMessage);
                    details.message(installInitMessage);
                    ++installAttempts;
                    if (!this.installTemplate(deployedWorksheet, deployedRoot, bulkDeploy, details, util, opIn, displayNames)) continue;
                    ++installSuccesses;
                }
            }
            if (!displayNames.isEmpty()) {
                displayNames.forEach((key, value) -> {
                    log.log(Level.INFO, String.format("Component: %s, Display name: %s", key, value.encodeToString()));
                    bulkDeploy.updateTemplateDisplayNames((BComponent)key, (BNameMap)value);
                });
            }
            for (BulkDeployUtil.DeployedWorksheet deployedWorksheet : deployedWorksheets) {
                for (BulkDeployUtil.DeployedRoot deployedRoot : deployedWorksheet.deployedRoots) {
                    if (!this.isDeviceTargetValid(deployedRoot, station)) continue;
                    if (deployedRoot.getDeployedTemplate() == null && details.getState() == BJobState.failed) {
                        return;
                    }
                    if (deployedRoot.getDeployedTemplate() == null) continue;
                    details.message("provisioningNiagara", "DeployTemplateStep.configuringTemplateComponentDetails", new String[]{deployedRoot.getDeployName(), deployedWorksheet.title});
                    bulkDeploy.applyConfigurations(deployedWorksheet, deployedRoot);
                }
            }
        }
        finally {
            util.disengageFoxSession();
        }
        if (installAttempts > 0 && installSuccesses == 0) {
            details.failed((Throwable)new LocalizableRuntimeException("provisioningNiagara", "DeployTemplateStep.allDeploysFailed"));
        } else {
            details.success();
        }
    }

    protected abstract boolean installTemplate(BulkDeployUtil.DeployedWorksheet var1, BulkDeployUtil.DeployedRoot var2, ProvisioningBulkDeployUtil var3, BDeviceStepDetails var4, ProvisioningConnectionUtil var5, DeviceNetworkJobOp var6, HashMap<BComponent, BNameMap> var7);

    private boolean isDeviceTargetValid(BulkDeployUtil.DeployedRoot deployedRoot, BNiagaraStation station) {
        String stationName = station.getStationName();
        log.log(this.LOG_LEVEL, "Station name: " + stationName);
        if (deployedRoot.getDeviceTarget() == null || deployedRoot.getDeviceTarget().isEmpty()) {
            return true;
        }
        log.log(this.LOG_LEVEL, "Unique device: " + deployedRoot.getDeviceTarget());
        if (deployedRoot.getDeviceTarget().contentEquals(stationName)) {
            return true;
        }
        String deployDeviceTarget = "";
        try {
            BOrd addressOrd = station.getAddress();
            OrdQuery[] addressQuery = addressOrd.parse();
            deployDeviceTarget = addressQuery[0].getBody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.log(this.LOG_LEVEL, "Host name: " + deployDeviceTarget);
        return deployedRoot.getDeviceTarget().contentEquals(deployDeviceTarget);
    }

    protected String getSpreadsheetPassword(BDeviceStepDetails details) {
        if (this.getIsPasswordProtected()) {
            try {
                return AccessController.doPrivileged(() -> ((BPassword)this.getEncodingPassword()).getValue());
            }
            catch (SecurityException e) {
                details.message("template", "bulkDeploy.excelImport.encryptionPassword.warning", new String[]{this.getExcelFileOrd().encodeToString()});
                return null;
            }
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString(Context cx) {
        return lex.getText("DeployTemplateFactory.display", new Object[]{this.getExcelFileOrd().toString()});
    }
}

