/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.station;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.ProvisioningNiagaraManagerImpl;
import com.tridium.provisioningNiagara.station.BStationProxy;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.PlatformDaemon;
import javax.baja.provisioningNiagara.station.ProvisioningStationManager;
import javax.baja.sys.Context;

public class ProvisioningStationManagerImpl
implements ProvisioningStationManager {
    private BNiagaraStation station;
    private BStationProxy proxy;

    public ProvisioningStationManagerImpl(ProvisioningNiagaraManagerImpl parent, BNiagaraStation station) {
        this.station = station;
        station.lease(1);
        this.proxy = (BStationProxy)station.getMixIn(BStationProxy.TYPE);
    }

    @Override
    public void poll(ICancelHint cancelHint, Context cx) throws Exception {
        this.proxy.lease(Integer.MAX_VALUE);
        this.proxy.invokeSync(BStationProxy.pollWithNotify, cancelHint, cx);
    }

    @Override
    public BStationStatus getStationStatus() {
        this.proxy.lease(1);
        return this.proxy.getStationStatus();
    }

    @Override
    public boolean canStart() {
        BStationStatus status = this.getStationStatus();
        if (status == BStationStatus.running || status == BStationStatus.starting) {
            return false;
        }
        return this.canRestart() || status != BStationStatus.halted && status != BStationStatus.failed;
    }

    @Override
    public boolean canRestart() {
        this.proxy.lease(1);
        return this.proxy.getIsRestartEnabled();
    }

    @Override
    public boolean canReboot() {
        this.proxy.lease(1);
        return this.proxy.getIsRebootEnabled();
    }

    @Override
    public void saveStation(IPlatformOperationListener listener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener opListener = new PlatformOperationListener(listener);
        this.proxy.saveStation((ICancelHint)opListener, (DaemonSessionTaskListener)opListener);
    }

    @Override
    public void saveStationAsync() {
        this.proxy.lease(1);
        this.proxy.saveStation();
    }

    @Override
    public void stopStation(IPlatformOperationListener listener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener opListener = new PlatformOperationListener(listener);
        this.proxy.stopStation((ICancelHint)opListener, (DaemonSessionTaskListener)opListener);
    }

    @Override
    public void stopStationAsync() {
        this.proxy.lease(1);
        this.proxy.stopStation();
    }

    @Override
    public void startStation(IPlatformOperationListener listener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener opListener = new PlatformOperationListener(listener);
        this.proxy.startStation((ICancelHint)opListener, (DaemonSessionTaskListener)opListener);
    }

    @Override
    public void startStationAsync() {
        this.proxy.lease();
        this.proxy.startStation();
    }

    @Override
    public void killStation(IPlatformOperationListener listener) throws Exception {
        this.proxy.lease(1);
        PlatformOperationListener opListener = new PlatformOperationListener(listener);
        this.proxy.killStation((ICancelHint)opListener, (DaemonSessionTaskListener)opListener);
    }

    @Override
    public void killStationAsync() {
        this.proxy.lease(1);
        this.proxy.killStation();
    }

    public void restartStation() throws Exception {
        this.proxy.lease(1);
        this.proxy.restartStation();
    }

    @Override
    public void restartStationAsync() {
        this.proxy.lease(1);
        this.proxy.restartStation();
    }

    @Override
    public void rebootHost() throws Exception {
        this.proxy.lease(1);
        this.proxy.rebootHost();
    }

    @Override
    public PlatformDaemon getPlatformDaemon() throws Exception {
        this.station.lease(1);
        BPlatformConnection conn = (BPlatformConnection)this.station.getMixIn(BPlatformConnection.TYPE);
        return conn.getPlatformDaemon();
    }
}

