/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.provisioningNiagara.BNiagaraProvisioningChannel;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.software.BInstallableSummary;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="loaded", defaultValue="false", type="boolean", flags=7)})
public class BSoftwareContainer
extends BComponent
implements LocalInstallableRegistry.RegistryListener {
    public static final Property loaded = BSoftwareContainer.newProperty((int)7, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BSoftwareContainer.class);
    private static final BIcon icon = BIcon.make((String)"module://provisioningNiagara/icons/software.png");
    public static final String DIST_DIR = "!cleanDist";

    public boolean getLoaded() {
        return this.getBoolean(loaded);
    }

    public void setLoaded(boolean v) {
        this.setBoolean(loaded, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public synchronized void installableRegistered(BInstallable inst) {
        try {
            BInstallableSummary summary = this.getInstallableSummary(inst.getInstallableName());
            if (summary == null) {
                this.add(SlotPath.escape((String)inst.getInstallableName()), (BValue)new BInstallableSummary(inst), 3);
            } else {
                summary.addInstallable(inst);
            }
        }
        catch (RuntimeException re) {
            Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "Installable registration failed for " + inst.getLocalInstallableFile(), re);
        }
    }

    public BProvisioningNiagaraNetworkExt getNetworkExt() {
        return (BProvisioningNiagaraNetworkExt)this.getParent();
    }

    public BInstallableSummary getInstallableSummary(String installableName) {
        return (BInstallableSummary)this.get(SlotPath.escape((String)installableName));
    }

    public BInstallableSpec getInstallableSpec(String installableName, BVersion version) {
        BInstallableSummary summary = this.getInstallableSummary(installableName);
        return summary == null ? null : summary.getInstallableSpec(version);
    }

    public BInstallable getInstallable(BIFile file) throws Exception {
        if (file == null) {
            return null;
        }
        if (file.getStore() instanceof BLocalFileStore) {
            return BInstallable.make((BIFile)file);
        }
        if (file.getFileSpace().getSession().equals(this.getSession())) {
            BFoxSession session = (BFoxSession)this.getSession();
            BNiagaraProvisioningChannel channel = (BNiagaraProvisioningChannel)session.getConnection().getChannels().get("niagaraProv", BNiagaraProvisioningChannel.TYPE);
            return channel.getInstallableByPath(file.getFilePath());
        }
        return null;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BProvisioningNiagaraNetworkExt.TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BInstallableSummary.TYPE);
    }

    public void serviceStarted() {
        new Import().start();
    }

    public BINavNode[] getNavChildren() {
        List<BINavNode> result = Arrays.asList(super.getNavChildren());
        result.sort(Comparator.comparing(BINavNode::getNavName));
        return result.toArray(new BINavNode[result.size()]);
    }

    public static boolean isCleanDistFile(BInstallable installable) {
        if (!(installable instanceof BDistribution)) {
            return false;
        }
        if (!installable.getIsStandalone()) {
            return false;
        }
        String distName = installable.getInstallableName();
        return distName != null && (distName.endsWith("clean") || distName.endsWith("clean.dist"));
    }

    public BIcon getIcon() {
        return icon;
    }

    private class Import
    extends Thread {
        private Import() {
        }

        @Override
        public void run() {
            try {
                BSoftwareContainer.this.removeAll();
                try (IterableCursor c = LocalInstallableRegistry.getInstance().getInstallables(false, null);){
                    while (c.next()) {
                        BSoftwareContainer.this.installableRegistered((BInstallable)c.get());
                    }
                    BSoftwareContainer.this.setLoaded(true);
                    LocalInstallableRegistry.getInstance().addListener((LocalInstallableRegistry.RegistryListener)BSoftwareContainer.this);
                }
            }
            catch (Exception e) {
                Logger.getLogger("provisioningNiagara").log(Level.SEVERE, "Software registry scan failed", e);
            }
        }
    }
}

