/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.station.BStationProxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.naming.BHost;
import javax.baja.platform.ICancelHint;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BRebootJobStep
extends BDeviceJobStep
implements ICancelHint {
    public static final Type TYPE = Sys.loadType(BRebootJobStep.class);
    private static final BIcon icon = BIcon.make((String)"module://provisioningNiagara/icons/software.png");

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        block13: {
            BNiagaraStation station = (BNiagaraStation)device;
            BPlatformConnection platformConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            if (platformConn.isUnoperational()) {
                details.failed("provisioningNiagara", "AbstractSoftwareStep.platformConnUnoperational", new String[]{station.getDisplayName(null), BFormat.getEncodedPattern((BIEncodable)platformConn.getStatus())});
                details.complete(BJobState.failed);
                return;
            }
            BDaemonSession platformSession = platformConn.getDaemonSession();
            BHost host = platformSession.getHost();
            String sessionTimestamp = platformSession.getHostProperties().getSessionTimestamp();
            platformConn.setStatus(BStatus.makeDisabled((BStatus)platformConn.getStatus(), (boolean)true));
            Logger daemonSessionLog = Logger.getLogger("platform.daemonSession");
            Level previousLevel = daemonSessionLog.getLevel();
            try {
                details.start("provisioningNiagara", "AbstractSoftwareStep.rebooting", host.toString((Context)op));
                if (!platformSession.sendRebootRequest()) {
                    details.endFailed("provisioningNiagara", "RebootJobStep.requestFailed", new String[]{station.getDisplayName(null)});
                    details.complete(BJobState.failed);
                    return;
                }
                daemonSessionLog.setLevel(Level.SEVERE);
                details.endSuccess();
                details.start("provisioningNiagara", "AbstractSoftwareStep.reconnect", host.toString((Context)op));
                ICancelHint hint = BStationProxy.rebootCancelHint((ICancelHint)details, (RuntimeException)new LocalizableRuntimeException("provisioningNiagara", "ProvisioningJob.stationRebootTimeout", new Object[]{station.getDisplayName(null)}));
                if (platformSession.reconnect(sessionTimestamp, hint)) {
                    details.endSuccess();
                    break block13;
                }
                throw new ICancelHint.CanceledException();
            }
            finally {
                try {
                    daemonSessionLog.setLevel(previousLevel);
                }
                catch (Exception exception) {}
                platformConn.setStatus(BStatus.makeDisabled((BStatus)platformConn.getStatus(), (boolean)false));
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString(Context cx) {
        return this.getLexicon().getText("RebootJobStep.displayName");
    }
}

