/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BInstallableSpec;
import com.tridium.provisioningNiagara.software.BInstallableNavNode;
import com.tridium.provisioningNiagara.software.BSoftwareContainer;
import java.util.ArrayList;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BInstallableSummary
extends BComponent {
    public static final Property installableName = BInstallableSummary.newProperty((int)7, (String)"", null);
    public static final Property installableType = BInstallableSummary.newProperty((int)7, (BValue)BTypeSpec.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BInstallableSummary.class);

    public String getInstallableName() {
        return this.getString(installableName);
    }

    public void setInstallableName(String v) {
        this.setString(installableName, v, null);
    }

    public BTypeSpec getInstallableType() {
        return (BTypeSpec)this.get(installableType);
    }

    public void setInstallableType(BTypeSpec v) {
        this.set(installableType, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInstallableSummary() {
    }

    public BInstallableSummary(BInstallable inst) {
        this.setInstallableName(inst.getInstallableName());
        this.setInstallableType(inst.getType().getTypeSpec());
        this.addInstallable(inst);
    }

    public void addInstallable(BInstallable inst) {
        if (!inst.getInstallableName().equals(this.getInstallableName())) {
            throw new IllegalArgumentException("Illegal name " + inst.getInstallableName() + " != " + this.getInstallableName());
        }
        if (!inst.getType().getTypeSpec().equals((Object)this.getInstallableType())) {
            throw new IllegalArgumentException("Illegal type " + inst.getType().getTypeSpec() + " != " + this.getInstallableType());
        }
        String versionSlot = SlotPath.escape((String)inst.getVersion().getVendorVersionString());
        BInstallableSpec spec = (BInstallableSpec)this.get(versionSlot);
        if (spec == null) {
            this.add(versionSlot, (BValue)BInstallableSpec.make((BInstallable)inst));
        }
    }

    public BVersion[] getVersions() {
        ArrayList<BVersion> result = new ArrayList<BVersion>();
        SlotCursor c = this.getProperties();
        while (c.next(BInstallableSpec.class)) {
            BInstallableSpec spec = (BInstallableSpec)c.get();
            result.add(spec.getVersion());
        }
        return result.toArray(new BVersion[result.size()]);
    }

    public BInstallableSpec getInstallableSpec(BVersion version) {
        return (BInstallableSpec)this.get(SlotPath.escape((String)version.getVendorVersionString()));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BSoftwareContainer.TYPE);
    }

    public BIcon getIcon() {
        this.lease();
        return this.getInstallableType().getTypeInfo().getIcon(null);
    }

    public String toString(Context cx) {
        this.lease();
        return this.getInstallableName() + " (" + this.getInstallableType().getTypeInfo().getDisplayName(cx) + ")";
    }

    public BINavNode[] getNavChildren() {
        ArrayList<BInstallableNavNode> result = new ArrayList<BInstallableNavNode>();
        SlotCursor c = this.getProperties();
        while (c.next(BInstallableSpec.class)) {
            result.add(new BInstallableNavNode((BInstallableSpec)c.get()));
        }
        result.sort((n1, n2) -> n1.getInstallableSpec().getVersion().compareTo((Object)n2.getInstallableSpec().getVersion()));
        return result.toArray(new BINavNode[result.size()]);
    }
}

