/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.software;

import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.provisioningNiagara.NiagaraNetworkJobOp;
import com.tridium.provisioningNiagara.software.BAbstractSoftwareStep;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="distPassphrase", type="BPassword", defaultValue="BPassword.DEFAULT", flags=5), @NiagaraProperty(name="installableFilePath", type="String", defaultValue="", flags=1)})
public class BInstallDistWithPassPhraseStep
extends BAbstractSoftwareStep {
    public static final Property distPassphrase = BInstallDistWithPassPhraseStep.newProperty((int)5, (BValue)BPassword.DEFAULT, null);
    public static final Property installableFilePath = BInstallDistWithPassPhraseStep.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BInstallDistWithPassPhraseStep.class);
    public static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    public BPassword getDistPassphrase() {
        return (BPassword)this.get(distPassphrase);
    }

    public void setDistPassphrase(BPassword v) {
        this.set(distPassphrase, (BValue)v, null);
    }

    public String getInstallableFilePath() {
        return this.getString(installableFilePath);
    }

    public void setInstallableFilePath(String v) {
        this.setString(installableFilePath, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BInstallDistWithPassPhraseStep() {
    }

    public BInstallDistWithPassPhraseStep(BOrd installableOrd) {
        FilePath path;
        OrdQuery[] ordQueries = installableOrd.parse();
        if (ordQueries[ordQueries.length - 1] instanceof FilePath) {
            path = (FilePath)ordQueries[ordQueries.length - 1];
            if (!path.isStationHomeAbsolute() && !path.isProtectedStationHomeAbsolute()) {
                throw new IllegalArgumentException("installableOrd must end with a station-home-absolute or protected-station-home-absolute FilePath");
            }
        } else {
            throw new IllegalArgumentException("installableOrd must end with a station-home-absolute or protected-station-home-absolute FilePath");
        }
        this.setInstallableFilePath(path.getBody());
    }

    @Override
    public InstallScenario updateInstallScenario(BDeviceStepDetails details, DaemonSessionTaskListener listener, InstallScenario scenario, NiagaraNetworkJobOp op) throws Exception {
        ArrayList<BInstallable> toInstall = new ArrayList<BInstallable>(Arrays.asList(scenario.getToInstall()));
        BIFile installableFile = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.findFile(new FilePath(this.getInstallableFilePath())));
        if (installableFile == null) {
            details.failed("provisioningNiagara", "InstallStep.installableNotFound", this.getInstallableFilePath());
            details.complete(BJobState.failed);
            return scenario;
        }
        AccessController.doPrivileged(() -> {
            toInstall.add(BInstallable.make((BIFile)installableFile));
            return null;
        });
        return new InstallScenario(scenario.getTargetPlatform(), listener, scenario.getModulesToUninstall(), scenario.getUnmetDependencies(), toInstall.toArray(new BInstallable[toInstall.size()]), (InstallableRegistry)LocalInstallableRegistry.getInstance(), scenario.getCertValidator());
    }

    @Override
    protected BAbstractSoftwareStep.EncodingTestInfo resolveEncodingInfo(BDeviceStepDetails details, InstallScenario scenario, BDaemonSession session) throws Exception {
        BAbstractSoftwareStep.EncodingTestInfo encodingTestInfo = new BAbstractSoftwareStep.EncodingTestInfo();
        encodingTestInfo.isEncodingCheckOK = true;
        PBEEncodingInfo encodingInfo = null;
        for (BInstallable aToInstall : scenario.getToInstall()) {
            BDistribution dist;
            PBEEncodingInfo distEncodingInfo;
            if (session.getHostProperties().isNiagara4() && aToInstall instanceof BDistribution && (distEncodingInfo = (dist = (BDistribution)aToInstall).getManifest().getPBEEncodingInfo()) != null) {
                if (encodingInfo == null) {
                    encodingInfo = distEncodingInfo;
                    details.message("provisioningNiagara", "AbstractSoftwareStep.verifySystemPassPhrase", aToInstall.toString(null));
                    if (this.getDistPassphrase() == null || this.getDistPassphrase() == BPassword.DEFAULT) {
                        if (!session.validateSystemPassPhrase((PBEValidator)distEncodingInfo)) {
                            details.failed("provisioningNiagara", "AbstractSoftwareStep.systemPassPhraseMismatch", new String[]{aToInstall.toString(null), details.getDeviceDisplayName()});
                            details.complete(BJobState.failed);
                            encodingTestInfo.isEncodingCheckOK = false;
                            break;
                        }
                    } else {
                        if (!distEncodingInfo.test(AccessController.doPrivileged(() -> ((BPassword)this.getDistPassphrase()).getSecretChars()))) {
                            details.failed("provisioningNiagara", "AbstractSoftwareStep.providedSystemPassPhraseMismatch");
                            details.complete(BJobState.failed);
                            encodingTestInfo.isEncodingCheckOK = false;
                            break;
                        }
                        encodingInfo = distEncodingInfo;
                    }
                } else {
                    details.failed("provisioningNiagara", "AbstractSoftwareStep.multipleEncodedDist");
                    details.complete(BJobState.failed);
                    encodingTestInfo.isEncodingCheckOK = false;
                    break;
                }
            }
            details.message("provisioningNiagara", "AbstractSoftwareStep.installing", aToInstall.toString(null));
        }
        encodingTestInfo.encodingInfo = encodingInfo;
        return encodingTestInfo;
    }

    @Override
    protected Optional<Consumer<FileTransferMessage>> updateMessageInitializer(PBEEncodingInfo encodingInfo, BDaemonSession session) throws Exception {
        if (encodingInfo == null || this.getDistPassphrase() == null || this.getDistPassphrase() == BPassword.DEFAULT) {
            return Optional.empty();
        }
        return !encodingInfo.test(AccessController.doPrivileged(() -> ((BPassword)this.getDistPassphrase()).getSecretChars())) ? Optional.empty() : Optional.of(DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)session, Optional.of(encodingInfo), Optional.ofNullable(AccessController.doPrivileged(() -> ((BPassword)this.getDistPassphrase()).getSecretChars()))));
    }

    public BIcon getIcon() {
        FilePath path = new FilePath(this.getInstallableFilePath());
        switch (BajaFileUtil.getExtension((String)path.getName())) {
            case "dist": {
                return BIcon.std((String)"modules.png");
            }
            case "jar": {
                return BPart.getPartTypeIcon((Type)BModulePart.TYPE);
            }
        }
        return super.getIcon();
    }

    public String toString(Context cx) {
        return LEX.getText("InstallStep.display", new Object[]{this.getInstallableFilePath()});
    }
}

