/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.program;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.program.BInstallCertificatePolicyEnum;
import com.tridium.util.TimeFormat;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.fox.BFoxProxySession;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="installPolicy", type="BInstallCertificatePolicyEnum", defaultValue="BInstallCertificatePolicyEnum.make(BInstallCertificatePolicyEnum.INSTALL_UNIQUE)")})
public class BInstallCertificateJobStep
extends BDeviceJobStep {
    public static final Property alias = BInstallCertificateJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property installPolicy = BInstallCertificateJobStep.newProperty((int)0, (BValue)BInstallCertificatePolicyEnum.make(0), null);
    public static final Type TYPE = Sys.loadType(BInstallCertificateJobStep.class);
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    private static final Lexicon lex = Lexicon.make((String)"provisioningNiagara");
    private static final BIcon icon = BIcon.make((String)lex.getText("InstallCertificateStepFactory.displayIcon"));

    public String getAlias() {
        return this.getString(alias);
    }

    public void setAlias(String v) {
        this.setString(alias, v, null);
    }

    public BInstallCertificatePolicyEnum getInstallPolicy() {
        return (BInstallCertificatePolicyEnum)this.get(installPolicy);
    }

    public void setInstallPolicy(BInstallCertificatePolicyEnum v) {
        this.set(installPolicy, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BInstallCertificateJobStep() {
    }

    public BInstallCertificateJobStep(String alias, BInstallCertificatePolicyEnum policy) {
        this.setAlias(alias);
        this.setInstallPolicy(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        BPlatformConnection platformConn = (BPlatformConnection)device.getMixIn(BPlatformConnection.TYPE);
        BDaemonSession daemonSession = platformConn.getDaemonSession();
        if (!daemonSession.getHostProperties().isNiagara4()) {
            details.failed("provisioningNiagara", "InstallCertificateJobStep.axStation", new String[]{device.getDisplayName(null)});
            details.complete(BJobState.failed);
            return;
        }
        BCertManagerService certService = (BCertManagerService)Sys.getService((Type)BCertManagerService.TYPE);
        X509Certificate cert = certService.getUserTrustStore().getCertificate(this.getAlias());
        BFoxProxySession session = BProvisioningNiagaraNetworkExt.getFoxProxySession((BNiagaraStation)device);
        String interestName = "installCertStep" + TimeFormat.format((BAbsTime)details.getStartTime(), (Context)TIMESTAMP_FORMAT);
        session.engageNoRetry(interestName);
        try {
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
            ChannelCryptoManager ccm = new ChannelCryptoManager((BComponent)remoteCertService);
            ICoreTrustStore trustStore = ccm.getUserTrustStore();
            String alias = this.getAlias();
            String existingAlias = trustStore.getCertificateAlias(cert);
            if (existingAlias != null) {
                alias = existingAlias;
            } else if (trustStore.getCertificate(alias) != null) {
                switch (this.getInstallPolicy().getOrdinal()) {
                    case 0: {
                        alias = CertUtils.getUniqueAlias((String)this.getAlias(), (ICoreTrustStore)trustStore);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        alias = null;
                        break;
                    }
                    default: {
                        alias = CertUtils.getUniqueAlias((String)this.getAlias(), (ICoreTrustStore)trustStore);
                    }
                }
            }
            if (alias != null) {
                trustStore.setCertificateEntry(alias, cert);
                trustStore.save();
            }
        }
        finally {
            session.disengage(interestName);
        }
    }

    public String toString(Context cx) {
        return lex.getText("InstallCertificateJobStep.display", new Object[]{this.getAlias()});
    }

    public BIcon getIcon() {
        return icon;
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

