/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.credentials;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import java.security.AccessController;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="username", type="String", defaultValue=""), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="admin", type="boolean", defaultValue="false")})
public class BAddStationUserStep
extends BDeviceJobStep {
    public static final Property username = BAddStationUserStep.newProperty((int)0, (String)"", null);
    public static final Property password = BAddStationUserStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property admin = BAddStationUserStep.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BAddStationUserStep.class);

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public boolean getAdmin() {
        return this.getBoolean(admin);
    }

    public void setAdmin(boolean v) {
        this.setBoolean(admin, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAddStationUserStep() {
    }

    public BAddStationUserStep(String username, BPassword password, boolean admin) {
        this.setUsername(username);
        this.setPassword(password);
        this.setAdmin(admin);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BFoxSession foxSession = util.getEngagedFoxSession();
            this.createNewUser(details, foxSession);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "AddStationUserStep.failed", (Throwable)e);
            details.complete(BJobState.failed);
        }
    }

    private void createNewUser(BDeviceStepDetails details, BFoxSession foxSession) {
        BPassword newPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()));
        BUserService service = (BUserService)BOrd.make((String)"service:baja:UserService").get((BObject)foxSession);
        service.lease();
        BUser user = service.getUser(this.getUsername());
        if (user != null) {
            details.vaFailed("AddStationUserStep.failed.duplicateUser", new String[]{this.getUsername()});
            details.complete(BJobState.failed);
        } else {
            user = new BUser();
            service.add(SlotPath.escape((String)this.getUsername()), (BValue)user);
            user = service.getUser(this.getUsername());
            user.lease(Integer.MAX_VALUE);
            try {
                BPasswordAuthenticator authenticator = (BPasswordAuthenticator)user.getAuthenticator();
                authenticator.lease(Integer.MAX_VALUE);
                authenticator.set(BPasswordAuthenticator.password, (BValue)newPassword, Context.forceValidate);
                if (this.getAdmin()) {
                    user.addRole("admin", null);
                }
                details.vaMessage("AddStationUserStep.userAdded", new String[]{this.getUsername()});
                details.success();
            }
            catch (Exception e) {
                service.remove(this.getUsername());
                throw e;
            }
        }
    }

    public String toString(Context context) {
        return super.toString(context) + " (" + this.getUsername() + ", admin = " + this.getAdmin() + ")";
    }
}

